/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.RemotingProxyFactory;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.grid.CleanDirJob;
import com.pmease.quickbuild.grid.DeleteDirJob;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.grid.NodeCharacteristics;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.grid.NodeJobExecuteTask;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.grid.WorkspaceBrowser;
import com.pmease.quickbuild.grid.WorkspaceFile;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.util.SerializationHelper;

@ScriptApi
public class GridNode
implements Serializable,
Comparable<GridNode> {
    public static final String SYSTEM_ATTRIBUTES = "systemAttributes";
    public static final String USER_ATTRIBUTES = "userAttributes";
    private static final long serialVersionUID = 1L;
    private volatile UUID id;
    private String ip;
    private int port;
    private volatile transient CloudProfile cloudProfile;
    private volatile transient String launchId;
    private volatile String hostName;
    private boolean isServer;
    private Long userId;
    private volatile boolean overSSL;
    private volatile long benchmark;
    private transient User user;
    private volatile NodeCharacteristics characteristics = new NodeCharacteristics();
    private volatile String token;
    private volatile boolean stopping;
    private transient Map<String, Object> legacyResources;
    private transient Map<String, Integer> resources;
    private transient Map<String, Integer> reservedResources;
    private transient Map<Long, String> workspaceUsages;
    private transient int stepCount = 0;
    private volatile transient Date lastPulse;
    private transient boolean resourceChecked;
    private volatile transient Date lastJobDate = new Date();
    private transient AtomicLong usedCount = new AtomicLong(0L);

    public GridNode(UUID id, String ip, int port, boolean overSSL) {
        this.id = id;
        this.ip = ip;
        this.port = port;
        this.overSSL = overSSL;
    }

    public synchronized void setSystemAttributes(Map<String, String> systemAttributes) {
        this.characteristics.getSystemAttributes().clear();
        this.characteristics.getSystemAttributes().putAll(systemAttributes);
    }

    @ScriptApi(value="Set user attributes via map. The second param indicates whether or not to save persist user attributes (save to file \"attributes.properties\"). Please note that this will only take effect when calling from server side.")
    public void setUserAttributes(Map<String, String> userAttributes, boolean persist) {
        this.setUserAttributes(null, userAttributes, persist);
    }

    @ScriptApi(value="Set user attributes via map. The second param indicates whether or not to save persist user attributes (save to file \"attributes.properties\"). Please note that this will only take effect when calling from server side.")
    public synchronized void setUserAttributes(Long userId, Map<String, String> userAttributes, boolean persist) {
        LinkedHashMap<String, String> originalAttributes = new LinkedHashMap<String, String>(this.characteristics.getUserAttributes());
        this.characteristics.getUserAttributes().clear();
        this.characteristics.getUserAttributes().putAll(userAttributes);
        if (persist) {
            User user;
            if (userId == null && (user = Context.getUser()) != null) {
                userId = user.getId();
            }
            if (this.isLocal()) {
                this.saveUserAttributes(userId);
                String previousContent = VersionedDocument.xstream.toXML(originalAttributes);
                String content = VersionedDocument.xstream.toXML(userAttributes);
                ServerService serverService = Quickbuild.getServerService();
                serverService.audit(userId, "Grid::Nodes", "User attributes of node '" + this.getAddress() + "' was modified.", content, previousContent);
            } else {
                this.getNodeService().setUserAttributes(userId, userAttributes);
            }
        }
    }

    public NodeService getNodeService() {
        if (this.isLocal()) {
            return NodeService.instance;
        }
        RemotingProxyFactory factory = new RemotingProxyFactory(this.getToken());
        return (NodeService)factory.create(NodeService.class, this.getUrl(), "/service/node");
    }

    public String getUrl() {
        if (this.isAgent()) {
            if (this.isOverSSL()) {
                return "https://" + this.ip + ":" + this.port;
            }
            return "http://" + this.ip + ":" + this.port;
        }
        if (Bootstrap.serverUrl == null) {
            if (this.isOverSSL()) {
                return "https://localhost:" + this.port;
            }
            return "http://localhost:" + this.port;
        }
        return Bootstrap.serverUrl;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof GridNode)) {
            return false;
        }
        GridNode otherNode = (GridNode)other;
        return new EqualsBuilder().append((Object)this.id, (Object)otherNode.getId()).isEquals();
    }

    @ScriptApi
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @ScriptApi(value="Get IP address of this node.")
    public String getIp() {
        return this.ip;
    }

    @ScriptApi(value="Get port number of this node.")
    public int getPort() {
        return this.port;
    }

    @ScriptApi(value="Is over SSL?")
    public boolean isOverSSL() {
        return this.overSSL;
    }

    public void setOverSSL(boolean overSSL) {
        this.overSSL = overSSL;
    }

    @ScriptApi(value="Get host name of this node.")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Date getLastPulse() {
        return this.lastPulse;
    }

    public void setLastPulse(Date lastPulse) {
        this.lastPulse = lastPulse;
    }

    @ScriptApi(value="Get attribute of specified name in user and system attributes. This method first examines the user attributes to see if specified attribute exists. If exists, the attribute value will be returned; otherwise, the system attributes will be examined. If both sources do not contain specified attribute, a null value will be returned.")
    public synchronized String getAttribute(String name) {
        String value = this.characteristics.getUserAttributes().get(name);
        if (value == null) {
            return this.characteristics.getSystemAttributes().get(name);
        }
        return value;
    }

    @ScriptApi(value="The same as getAttribute(name), but the second param provides a default value if the attribute can not be found.")
    public synchronized String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        return value != null ? value : defaultValue;
    }

    @ScriptApi(value="Whether or not the attribute is empty. An attribute is empty if it is defined with an empty value.")
    public boolean isAttributeEmpty(String name) {
        String value = this.getAttribute(name);
        return value != null && value.equals("");
    }

    @ScriptApi(value="Determines whether or not specified attribute is defined.")
    public synchronized boolean hasAttribute(String name) {
        Serializable value = (Serializable)((Object)this.characteristics.getUserAttributes().get(name));
        if (value == null) {
            value = (Serializable)((Object)this.characteristics.getSystemAttributes().get(name));
        }
        return value != null;
    }

    public synchronized Map<String, String> getSystemAttributes() {
        return new HashMap<String, String>(this.characteristics.getSystemAttributes());
    }

    @ScriptApi(value="Get all user attributes in map.")
    public synchronized Map<String, String> getUserAttributes() {
        return new LinkedHashMap<String, String>(this.characteristics.getUserAttributes());
    }

    private Map<String, Object> getLegacyResources() {
        if (!this.isLocal()) {
            throw new QuickbuildException("Resource of node '" + this.getAddress() + "' can only be accessed from the script running on node '" + this.getAddress() + "'.");
        }
        if (this.legacyResources == null) {
            this.legacyResources = new HashMap<String, Object>();
        }
        return this.legacyResources;
    }

    @ScriptApi(value="Get node resource of specified name. Null will returned if resource of the name is not found.")
    public synchronized Object getResource(String name) {
        return this.getLegacyResources().get(name);
    }

    @ScriptApi(value="Remove specified node resource.")
    public synchronized void removeResource(String name) {
        this.getLegacyResources().remove(name);
    }

    @ScriptApi(value="Clear all node resources.")
    public synchronized void clearResources() {
        this.getLegacyResources().clear();
    }

    @ScriptApi(value="Set node resource. The first param represents name of the resource, and the second param represents the actual resource.")
    public synchronized void setResource(String name, Object resource) {
        this.getLegacyResources().put(name, resource);
    }

    @ScriptApi(value="Get node resource of specified name (the first param). If resource is not found, the specified default resource (the second param) will be associated with the name.")
    public synchronized Object getResource(String name, Object defaultResource) {
        Object resource = this.getLegacyResources().get(name);
        if (resource == null) {
            this.getLegacyResources().put(name, defaultResource);
            return defaultResource;
        }
        return resource;
    }

    @ScriptApi(value="Get workspace directory path of specified configuration.")
    public String getWorkspaceDir(Long configurationId) {
        return this.getNodeService().getWorkspaceDir(configurationId);
    }

    public boolean isAbsolute(String path) {
        return this.getNodeService().isAbsolute(path);
    }

    public void createDir(String dir) {
        this.getNodeService().createDir(dir);
    }

    public void deleteDir(String dir) {
        this.executeJob(DeleteDirJob.class, new Serializable[]{dir});
    }

    public void deleteFile(String file) {
        this.getNodeService().deleteFile(file);
    }

    public void cleanDir(String dir) {
        this.executeJob(CleanDirJob.class, new Serializable[]{dir});
    }

    public String getFileTransferUrl() {
        return this.getUrl() + "/file_transfer";
    }

    public boolean isFileExists(String path) {
        return this.getNodeService().isFileExist(path);
    }

    public void setIsServer(boolean isServer) {
        this.isServer = isServer;
    }

    @ScriptApi(value="Whether or not this is a server node.")
    public boolean isServer() {
        return this.isServer;
    }

    @ScriptApi(value="Whether or not this is an agent node.")
    public boolean isAgent() {
        return !this.isServer();
    }

    @ScriptApi(value="Whether or not this is an user agent node.")
    public boolean isUserAgent() {
        if (this.isLocal()) {
            return Bootstrap.isUserAgent();
        }
        return this.userId != null;
    }

    @ScriptApi(value="Whether or not this is a build agent node.")
    public boolean isBuildAgent() {
        return this.isAgent() && !this.isUserAgent();
    }

    @ScriptApi(value="Get associated user if the node is an user agent node; otherwise, null will be returned.")
    public User getUser() {
        if (this.user == null && this.userId != null) {
            this.user = (User)UserManager.instance.load(this.userId);
        }
        return this.user;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
        this.user = null;
    }

    public Long getUserId() {
        return this.userId;
    }

    @ScriptApi(value="Whether or not this is local node.")
    public boolean isLocal() {
        return Grid.instance.getLocalNode().equals(this);
    }

    @ScriptApi(value="Get benchmark of this node.")
    public long getBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(long benchmark) {
        this.benchmark = benchmark;
    }

    public long predictLoad() {
        return this.getBenchmark() * (long)(this.getStepCount() + 1);
    }

    @ScriptApi(value="Get address of the node.")
    public String getAddress() {
        return this.hostName + ":" + this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserAttributes() {
        File attributeFile = new File(Bootstrap.installDir, "conf/attributes.properties");
        List<String> lines = FileUtils.readFileAsLines(attributeFile);
        GridNode gridNode = this;
        synchronized (gridNode) {
            this.characteristics.getUserAttributes().clear();
            for (String line : lines) {
                String name = StringUtils.substringBefore((String)line, (String)"=").trim();
                if (name.length() == 0) continue;
                this.characteristics.getUserAttributes().put(name, StringUtils.substringAfter((String)line, (String)"=").trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserAttributes(Long userId) {
        File attributesFile = new File(Bootstrap.installDir, "conf/attributes.properties");
        ArrayList<String> lines = new ArrayList<String>();
        GridNode gridNode = this;
        synchronized (gridNode) {
            for (Map.Entry<String, String> entry : this.characteristics.getUserAttributes().entrySet()) {
                lines.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        FileUtils.writeFile(attributesFile, lines);
    }

    private WorkspaceFile getWorkspaceFile(Configuration configuration, File file) {
        WorkspaceFile workspaceFile = new WorkspaceFile();
        workspaceFile.setLastModified(new Date(file.lastModified()));
        workspaceFile.setName(file.getName());
        if (file.isFile()) {
            workspaceFile.setSize(file.length());
            workspaceFile.setDirectory(false);
        } else {
            workspaceFile.setDirectory(true);
        }
        workspaceFile.setPath(FileUtils.getRelativePath(file.getAbsolutePath(), configuration.getWorkspaceDir().getAbsolutePath()));
        return workspaceFile;
    }

    public Serializable executeJob(Class<? extends NodeJob> jobClass, Serializable ... params) {
        if (this.isLocal()) {
            try {
                return jobClass.newInstance().execute(params);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        GridTaskFuture<Serializable> taskFuture = Grid.instance.execute(new NodeJobExecuteTask(), new NodeJobExecuteTask.NodeJobExecuteInfo(this, jobClass, params));
        return taskFuture.get();
    }

    public Serializable executeShortJob(Class<? extends NodeJob> jobClass, Serializable ... params) {
        if (this.isLocal()) {
            try {
                return jobClass.newInstance().execute(params);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return (Serializable)SerializationHelper.deserialize(this.getNodeService().executeShortJob(jobClass, SerializationHelper.serialize((Serializable)params)));
    }

    public WorkspaceBrowser getWorkspaceBrowser(final Configuration configuration) {
        return new WorkspaceBrowser(){

            @Override
            public List<WorkspaceFile> getChildren(WorkspaceFile parent) {
                if (GridNode.this.isLocal()) {
                    File parentFile = parent == null ? configuration.getWorkspaceDir() : new File(configuration.getWorkspaceDir(), parent.getPath());
                    File[] files = parentFile.listFiles();
                    if (files == null) {
                        return null;
                    }
                    ArrayList<WorkspaceFile> workspaceFiles = new ArrayList<WorkspaceFile>();
                    for (File file : files) {
                        workspaceFiles.add(GridNode.this.getWorkspaceFile(configuration, file));
                    }
                    return workspaceFiles;
                }
                return GridNode.this.getNodeService().getChildFiles(Context.getConfiguration().getId(), parent);
            }

            @Override
            public WorkspaceFile getParent(WorkspaceFile child) {
                if (GridNode.this.isLocal()) {
                    if (child == null) {
                        return null;
                    }
                    File childFile = new File(configuration.getWorkspaceDir(), child.getPath());
                    File parentFile = childFile.getParentFile();
                    if (parentFile.equals(configuration.getWorkspaceDir())) {
                        return null;
                    }
                    return GridNode.this.getWorkspaceFile(configuration, parentFile);
                }
                return GridNode.this.getNodeService().getParentFile(Context.getConfiguration().getId(), child);
            }
        };
    }

    public Map<String, Integer> getResources() {
        if (this.resources == null) {
            this.resources = new HashMap<String, Integer>();
        }
        return this.resources;
    }

    public Map<String, Integer> getReservedResources() {
        if (this.reservedResources == null) {
            this.reservedResources = new HashMap<String, Integer>();
        }
        return this.reservedResources;
    }

    @ScriptApi(value="Whether or not the node has specified resource, if yes, specified resource will be deducted from resource pool if the node is eventually selected to run steps. Only safe to be used in node selection setting of a step.")
    public boolean hasResource(String resource) {
        this.resourceChecked = true;
        if (this.isUserAgent()) {
            return false;
        }
        Integer count = this.getResources().get(resource);
        if (count == null) {
            throw new QuickbuildException("Resource '" + resource + "' is not defined.");
        }
        Integer reservedCount = this.getReservedResources().get(resource);
        if (reservedCount == null) {
            reservedCount = 0;
        }
        if (count > reservedCount) {
            Integer n = reservedCount;
            Integer n2 = reservedCount = Integer.valueOf(reservedCount + 1);
            this.getReservedResources().put(resource, reservedCount);
            return true;
        }
        return false;
    }

    public void takeReservedResources() {
        for (Map.Entry<String, Integer> entry : this.getResources().entrySet()) {
            Integer reservedCount = this.getReservedResources().get(entry.getKey());
            if (reservedCount == null) {
                reservedCount = 0;
            }
            entry.setValue(entry.getValue() - reservedCount);
        }
        ++this.stepCount;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    public Map<Long, String> getWorkspaceUsages() {
        if (this.workspaceUsages == null) {
            this.workspaceUsages = new HashMap<Long, String>();
        }
        return this.workspaceUsages;
    }

    public String getToken() {
        if (this.token == null) {
            return Bootstrap.getAgentToken();
        }
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isResourceChecked() {
        return this.resourceChecked;
    }

    public void setResourceChecked(boolean resourceChecked) {
        this.resourceChecked = resourceChecked;
    }

    @Override
    public int compareTo(GridNode o) {
        if (this.isServer()) {
            return -1;
        }
        if (o.isServer) {
            return 1;
        }
        return this.getAddress().compareToIgnoreCase(o.getAddress());
    }

    public Date getLastJobDate() {
        return this.lastJobDate;
    }

    public void setLastJobDate(Date lastJobDate) {
        this.lastJobDate = lastJobDate;
    }

    public CloudProfile getCloudProfile() {
        return this.cloudProfile;
    }

    public void setCloudProfile(CloudProfile cloudProfile) {
        this.cloudProfile = cloudProfile;
    }

    public String getLaunchId() {
        return this.launchId;
    }

    public void setLaunchId(String launchId) {
        this.launchId = launchId;
    }

    public NodeCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(NodeCharacteristics characteristic) {
        this.characteristics = characteristic;
    }

    public Long getUsedCount() {
        return this.usedCount.get();
    }

    public void setUsedCount(Long usedCount) {
        this.usedCount.set(usedCount);
    }

    public void increaseUsedCount() {
        this.usedCount.incrementAndGet();
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }
}

