/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.wicket.util.io.IOUtils;
import org.hibernate.util.SerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GridJob
implements Serializable,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final long TEST_INTERVAL = 30000L;
    private static final Logger logger = LoggerFactory.getLogger(GridJob.class);
    private String id = UUID.randomUUID().toString();
    private String taskId;
    private transient GridNode taskNode;
    private volatile transient Thread thread;
    private Throwable exception;

    public GridJob(String taskId) {
        this.taskId = taskId;
    }

    public String getId() {
        return this.id;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public GridNode getTaskNode() {
        return this.taskNode;
    }

    public void setTaskNode(GridNode taskNode) {
        this.taskNode = taskNode;
    }

    protected abstract void execute();

    protected void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        block34: {
            Thread.interrupted();
            this.thread = Thread.currentThread();
            Grid.instance.addJob(this);
            final AtomicInteger state = new AtomicInteger(1);
            try {
                InputStream is;
                block33: {
                    logger.debug("Executing job {}...", (Object)this.getId());
                    Quickbuild.getInstance().getExecutor().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AtomicInteger atomicInteger = state;
                            synchronized (atomicInteger) {
                                while (state.get() == 1) {
                                    try {
                                        Thread thread;
                                        if (!GridJob.this.taskNode.getNodeService().isGridJobActive(GridJob.this.taskId, GridJob.this.getId()) && (thread = GridJob.this.thread) != null) {
                                            thread.interrupt();
                                        }
                                        state.wait(30000L);
                                    }
                                    catch (Exception e) {
                                        Thread thread = GridJob.this.thread;
                                        if (thread == null) continue;
                                        thread.interrupt();
                                    }
                                }
                                state.set(3);
                                state.notify();
                            }
                        }
                    });
                    try {
                        this.execute();
                    }
                    catch (Throwable t) {
                        this.exception = t;
                    }
                    finally {
                        AtomicInteger atomicInteger = state;
                        synchronized (atomicInteger) {
                            state.set(2);
                            state.notify();
                            while (state.get() != 3) {
                                try {
                                    state.wait(10L);
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                    }
                    is = null;
                    try {
                        logger.trace("Notifying task node of job finishing (job class: {}, job id: {}, task node: {})...", new Object[]{this.getClass().getName(), this.getId(), this.getTaskNode().getAddress()});
                        GridNode localNode = Grid.instance.getLocalNode();
                        is = this.getTaskNode().getNodeService().gridJobFinished(SerializationHelper.serialize(this), localNode.getAddress());
                        if (is == null) break block33;
                        while (is.read() != -1) {
                        }
                    }
                    catch (Throwable t) {
                        try {
                            logger.error(String.format("Error notifying task node of job finishing (job class: %s, job id: %s, task node: %s)", this.getId(), this.getClass().getName(), this.getTaskNode().getAddress()), t);
                            break block34;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            IOUtils.closeQuietly(is);
                            this.cleanup();
                        }
                    }
                }
                IOUtils.closeQuietly((Closeable)is);
                this.cleanup();
            }
            catch (Throwable t) {
                logger.error("Error executing job '" + this.getId() + "'.", t);
            }
            finally {
                Grid.instance.removeJob(this.getId());
                logger.trace("Finished execution of job (job class: {}, job Id: {})...", (Object)this.getClass().getName(), (Object)this.getId());
                this.thread = null;
                Thread.interrupted();
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setTaskAttribute(String name, String value) {
        this.taskNode.getNodeService().setTaskAttribute(this.taskId, name, value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GridJob)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        GridJob otherJob = (GridJob)other;
        if (this.getId() == null && otherJob.getId() == null) {
            return super.equals(other);
        }
        return new EqualsBuilder().append((Object)this.getId(), (Object)otherJob.getId()).isEquals();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }
}

