/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.CopyFileJob;
import com.pmease.quickbuild.grid.CopyFilesJob;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTask;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.taskschedule.schedule.CronSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.map.ReferenceMap;
import org.hibernate.util.SerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GridImpl
implements Grid {
    private GridNode localNode;
    private Map<String, GridTaskFuture<?>> taskFutures = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private Map<String, GridJob> jobs = Collections.synchronizedMap(new HashMap());
    private Map<String, Date> jobIdCache = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = LoggerFactory.getLogger(GridImpl.class);

    public GridImpl() {
        this.localNode = Bootstrap.getPort() != 0 ? new GridNode(UUID.randomUUID(), Quickbuild.getInstance().getIp(), Bootstrap.getPort(), false) : new GridNode(UUID.randomUUID(), Quickbuild.getInstance().getIp(), Bootstrap.getSSLPort(), true);
        this.localNode.setHostName(Bootstrap.getHostName());
        this.localNode.setIsServer(Bootstrap.isServer());
        this.localNode.setToken(Bootstrap.getAgentToken());
        this.localNode.setBenchmark(Bootstrap.benchmark);
        HashMap<String, String> systemAttributes = new HashMap<String, String>(System.getenv());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            systemAttributes.put((String)entry.getKey(), (String)entry.getValue());
        }
        Iterator it = systemAttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry;
            entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key != null && value != null && !key.startsWith("osgi.") && !key.startsWith("org.osgi.") && !key.startsWith("eclipse.") && !key.startsWith("BuildGrid") && !key.startsWith("Grid") && !key.startsWith("org.eclipse.equinox.") && !key.startsWith("=")) continue;
            it.remove();
        }
        this.localNode.setSystemAttributes(systemAttributes);
        this.localNode.loadUserAttributes();
    }

    @Override
    public <T, R> GridTaskFuture<R> execute(GridTask<T, R> task, T arg) {
        Map<GridJob, GridNode> map = task.map(arg);
        GridTaskFuture<R> taskFuture = new GridTaskFuture<R>(task, map);
        this.taskFutures.put(task.getId(), taskFuture);
        for (Map.Entry<GridJob, GridNode> entry : map.entrySet()) {
            GridJob job = entry.getKey();
            GridNode node = entry.getValue();
            try {
                byte[] jobBytes = SerializationHelper.serialize(job);
                logger.trace("About to send job (job class: {}, job id: {}, job size: {}, job node: {})...", new Object[]{job.getClass().getName(), job.getId(), jobBytes.length, node.getAddress() + "(" + node.getIp() + ")"});
                if (job.getId().equals(node.getNodeService().executeGridJob(jobBytes, Grid.instance.getLocalNode()))) continue;
                throw new QuickbuildException("Failed to submit job '" + job.getId() + "' to node '" + node.getAddress() + "'.");
            }
            catch (Throwable t) {
                job.setException(t);
                taskFuture.jobFinished(job, false);
            }
        }
        return taskFuture;
    }

    @Override
    public GridTaskFuture<?> getTaskFuture(String taskId) {
        return this.taskFutures.get(taskId);
    }

    @Override
    public Collection<GridNode> getAllNodes() {
        ArrayList<GridNode> nodes = new ArrayList<GridNode>(this.getRemoteNodes());
        nodes.add(this.getLocalNode());
        return nodes;
    }

    @Override
    public GridNode getLocalNode() {
        return this.localNode;
    }

    @Override
    public GridNode getNode(UUID nodeId) {
        if (nodeId.equals(this.localNode.getId())) {
            return this.localNode;
        }
        if (Bootstrap.isServer()) {
            return AgentManager.instance.getAgentById(nodeId);
        }
        return Quickbuild.getServerService().getNodeById(nodeId);
    }

    @Override
    public Collection<GridNode> getRemoteNodes() {
        if (Bootstrap.isServer()) {
            ArrayList<GridNode> remoteNodes = new ArrayList<GridNode>();
            for (GridNode agentNode : AgentManager.instance.getBuildAgents()) {
                remoteNodes.add(agentNode);
            }
            return remoteNodes;
        }
        ArrayList<GridNode> remoteNodes = new ArrayList<GridNode>();
        ServerService serverService = Quickbuild.getServerService();
        remoteNodes.add(serverService.getServerNode());
        for (GridNode agentNode : serverService.getBuildAgentNodes()) {
            if (agentNode.getIp().equals(this.localNode.getIp()) && agentNode.getPort() == this.localNode.getPort()) continue;
            remoteNodes.add(agentNode);
        }
        return remoteNodes;
    }

    @Override
    public GridNode getServerNode() {
        if (Bootstrap.isServer()) {
            return this.getLocalNode();
        }
        return Quickbuild.getServerService().getServerNode();
    }

    @Override
    public void transferFiles(GridNode fromNode, String srcDir, String filePatterns, GridNode toNode, String destDir, boolean compress, String lockForReadPath, String lockForWritePath) {
        toNode.executeJob(CopyFilesJob.class, new Serializable[]{fromNode, srcDir, filePatterns, destDir, Boolean.valueOf(compress), lockForReadPath, lockForWritePath});
    }

    @Override
    public void transferFile(GridNode fromNode, String srcFile, GridNode toNode, String destFile, String lockForReadPath, String lockForWritePath) {
        toNode.executeJob(CopyFileJob.class, new Serializable[]{fromNode, srcFile, destFile, lockForReadPath, lockForWritePath});
    }

    @Override
    public GridNode getNode(String nodeAddress) {
        GridNode localNode = this.getLocalNode();
        if (localNode.getAddress().equals(nodeAddress)) {
            return localNode;
        }
        if (Bootstrap.isServer()) {
            return AgentManager.instance.getAgentByAddress(nodeAddress);
        }
        return Quickbuild.getServerService().getNodeByAddress(nodeAddress);
    }

    @Override
    public GridNode getUserNode(User user) {
        if (Bootstrap.isServer()) {
            return AgentManager.instance.getUserAgent(user);
        }
        return Quickbuild.getServerService().getUserAgentNode(HibernateUtils.getId(user));
    }

    @Override
    public void addJob(GridJob job) {
        this.jobs.put(job.getId(), job);
        this.jobIdCache.put(job.getId(), new Date());
    }

    @Override
    public GridJob getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    @Override
    public void removeJob(String jobId) {
        this.jobs.remove(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GridJob> getJobs() {
        Map<String, GridJob> map = this.jobs;
        synchronized (map) {
            return new ArrayList<GridJob>(this.jobs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasJobs() {
        Map<String, GridJob> map = this.jobs;
        synchronized (map) {
            return !this.jobs.isEmpty();
        }
    }

    @Override
    public List<String> getAttributeNames() {
        HashSet<String> attributeNames = new HashSet<String>();
        for (GridNode node : this.getAllNodes()) {
            attributeNames.addAll(node.getSystemAttributes().keySet());
            attributeNames.addAll(node.getUserAttributes().keySet());
        }
        for (CloudProfile profile : CacheManager.instance.getCloudProfiles()) {
            if (profile.getTestInfo() != null && profile.getTestInfo().getNodeCharacteristics() != null) {
                attributeNames.addAll(profile.getTestInfo().getNodeCharacteristics().getSystemAttributes().keySet());
                attributeNames.addAll(profile.getTestInfo().getNodeCharacteristics().getUserAttributes().keySet());
            }
            for (Property property : profile.getProfileAttributes()) {
                attributeNames.add(property.getName());
            }
        }
        ArrayList<String> list = new ArrayList<String>(attributeNames);
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Map<String, Date> map = this.jobIdCache;
        synchronized (map) {
            Iterator<Map.Entry<String, Date>> it = this.jobIdCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Date> entry = it.next();
                if (!entry.getValue().before(DateUtils.addDays((Date)new Date(), (int)-1))) continue;
                it.remove();
            }
        }
    }

    @Override
    public Schedule getSchedule() {
        CronSchedule schedule = new CronSchedule();
        schedule.setExpression("0 0 * * * ?");
        return schedule;
    }

    @Override
    public boolean isJobStarted(String jobId) {
        return this.jobIdCache.containsKey(jobId);
    }
}

