/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.ServletUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/file_transfer";
    private static final Logger logger = LoggerFactory.getLogger(FileTransferServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ServletOutputStream os;
        long time = System.currentTimeMillis();
        SecurityHelper.checkAgentToken(request);
        String filePath = request.getParameter("file");
        if (filePath != null) {
            Lock lock = null;
            String pathToLock = request.getParameter("lock");
            if (pathToLock != null) {
                lock = LockUtils.lockForRead(new File(pathToLock));
            }
            try {
                File file = new File(filePath);
                ServletUtils.serve(file, this.getServletContext().getMimeType(filePath), response);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
                if (Bootstrap.isServer()) {
                    MetricsManager.instance.downloadRequestProcessed(System.currentTimeMillis() - time);
                }
            }
        }
        try {
            os = response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final AtomicInteger state = new AtomicInteger(1);
        Quickbuild.getInstance().getExecutor().submit(new Runnable((OutputStream)os){
            final /* synthetic */ OutputStream val$os;
            {
                this.val$os = outputStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    while (state.get() == 1) {
                        try {
                            Thread.sleep(10L);
                            this.val$os.write(0);
                            this.val$os.flush();
                        }
                        catch (InterruptedException e) {
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                            return;
                        }
                    }
                }
                finally {
                    state.set(3);
                }
            }
        });
        String baseDir = request.getParameter("baseDir");
        String filePatterns = request.getParameter("filePatterns");
        boolean compress = "true".equals(request.getParameter("compress"));
        boolean tarToDisk = "true".equals(request.getParameter("tarToDisk"));
        logger.debug("Serving files (base dir: {}, file patterns: {}, compress: {}, tar to disk: {})", new Object[]{baseDir, filePatterns, compress, tarToDisk});
        if (!tarToDisk) {
            Lock lock = null;
            String pathToLock = request.getParameter("lock");
            if (pathToLock != null) {
                lock = LockUtils.lockForRead(new File(pathToLock));
            }
            try {
                Collection<File> files = FileUtils.listFiles(new File(baseDir), filePatterns);
                state.set(2);
                while (state.get() != 3) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                os.write(1);
                os.flush();
                FileUtils.tar(new File(baseDir), files, "true".equals(request.getParameter("compress")), (OutputStream)os);
                logger.debug("Finished serving files.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                state.set(2);
                if (lock != null) {
                    lock.unlock();
                }
                if (Bootstrap.isServer()) {
                    MetricsManager.instance.downloadRequestProcessed(System.currentTimeMillis() - time);
                }
            }
        }
        File tempFile = new File(Bootstrap.getTempDir(), "tar-" + UUID.randomUUID().toString());
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tempFile);
                Lock lock = null;
                String pathToLock = request.getParameter("lock");
                if (pathToLock != null) {
                    lock = LockUtils.lockForRead(new File(pathToLock));
                }
                try {
                    FileUtils.tar(new File(baseDir), filePatterns, compress, (OutputStream)fos);
                    logger.debug("Finished archiving files.");
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)fos);
            state.set(2);
            while (state.get() != 3) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            os.write(1);
            os.flush();
            FileInputStream is = null;
            try {
                int count;
                is = new FileInputStream(tempFile);
                byte[] data = new byte[65536];
                while ((count = ((InputStream)is).read(data)) != -1) {
                    os.write(data, 0, count);
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)is);
            logger.debug("Finished sending files.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            state.set(2);
            if (tempFile.exists()) {
                FileUtils.deleteFile(tempFile);
            }
            if (Bootstrap.isServer()) {
                MetricsManager.instance.downloadRequestProcessed(System.currentTimeMillis() - time);
            }
        }
    }
}

