/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.UnauthorizedAgent;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.util.HibernateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAgentManager
implements AgentManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAgentManager.class);
    @Inject
    private UserManager userManager;
    @Inject
    private CacheManager cacheManager;
    private List<GridNode> buildAgents = new ArrayList<GridNode>();
    private ReadWriteLock buildAgentsLock = new ReentrantReadWriteLock();
    private List<UnauthorizedAgent> unauthorizedBuildAgents = new ArrayList<UnauthorizedAgent>();
    private ReadWriteLock unauthorizedBuildAgentsLock = new ReentrantReadWriteLock();
    private Map<Long, GridNode> userAgents = new HashMap<Long, GridNode>();
    private ReadWriteLock userAgentsLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBuildAgentCount() {
        this.buildAgentsLock.readLock().lock();
        try {
            int n = this.buildAgents.size();
            return n;
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimedoutAgents(int timeout) {
        Serializable agent;
        Iterator<Object> it;
        Date threshholdTime = new Date(System.currentTimeMillis() - (long)(timeout * 1000));
        HashSet<String> activeLaunches = new HashSet<String>();
        ArrayList<String> alertAgents = new ArrayList<String>();
        this.buildAgentsLock.writeLock().lock();
        try {
            it = this.buildAgents.iterator();
            while (it.hasNext()) {
                agent = it.next();
                if (((GridNode)agent).getLastPulse().before(threshholdTime)) {
                    logger.info("Active build agent '{}' timed out, removing...", (Object)((GridNode)agent).getAddress());
                    Token token = this.cacheManager.getToken(((GridNode)agent).getIp(), ((GridNode)agent).getPort());
                    if (token != null && token.isOfflineAlert()) {
                        alertAgents.add(((GridNode)agent).getAddress());
                    }
                    it.remove();
                    continue;
                }
                if (((GridNode)agent).getLaunchId() == null) continue;
                activeLaunches.add(((GridNode)agent).getLaunchId());
            }
        }
        finally {
            this.buildAgentsLock.writeLock().unlock();
        }
        for (String each : alertAgents) {
            Alert alert = new Alert();
            alert.setAlertMessage("Build agent '" + each + "' is removed from active list as server " + "has not hear from it for '" + timeout + "' seconds.");
            alert.setPriority(Alert.AlertPriority.MEDIUM);
            alert.setSubject("Build agent offline");
            alert.setTrigger(Grid.instance.getLocalNode().getAddress());
            AlertManager.instance.alert(alert);
        }
        this.unauthorizedBuildAgentsLock.writeLock().lock();
        try {
            it = this.unauthorizedBuildAgents.iterator();
            while (it.hasNext()) {
                agent = (UnauthorizedAgent)it.next();
                if (!((UnauthorizedAgent)agent).getLastPulse().before(threshholdTime)) continue;
                logger.info("Unauthorized build agent '{}:{}' timed out, removing...", (Object)((UnauthorizedAgent)agent).getHostName(), (Object)((UnauthorizedAgent)agent).getPort());
                it.remove();
            }
        }
        finally {
            this.unauthorizedBuildAgentsLock.writeLock().unlock();
        }
        this.userAgentsLock.writeLock().lock();
        try {
            it = this.userAgents.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (!((GridNode)entry.getValue()).getLastPulse().before(threshholdTime)) continue;
                logger.info("Active user agent '{}' (for user '{}') timed out, removing...", (Object)((GridNode)entry.getValue()).getAddress(), (Object)((User)this.userManager.load((Long)entry.getKey())).getName());
                it.remove();
            }
        }
        finally {
            this.userAgentsLock.writeLock().unlock();
        }
        for (Token token : this.cacheManager.getTokens()) {
            if (token.getPort() == 0 || token.isTest() || token.getCloudProfile() == null || token.getNodeLaunchId() == null || activeLaunches.contains(token.getNodeLaunchId()) || (token = (Token)TokenManager.instance.get(token.getId())) == null || !token.getCloudProfile().getNodeLauncher().isTerminated(token.getNodeLaunchId())) continue;
            logger.info("Deleting terminated agent {}...", (Object)token.getAddress());
            TokenManager.instance.delete(token.getId());
        }
    }

    private GridNode newUserAgent(UUID agentNodeId, String agentIp, int agentPort, boolean overSSL, String agentName, String agentToken, long benchmark, Long userId) {
        GridNode agent = new GridNode(agentNodeId, agentIp, agentPort, overSSL);
        agent.setHostName(agentName);
        agent.setIsServer(false);
        agent.setBenchmark(benchmark);
        agent.setToken(agentToken);
        logger.info("Retrieving node characteristics from agent '{}'...", (Object)agent.getAddress());
        agent.setCharacteristics(agent.getNodeService().getNodeCharacteristics());
        agent.setUserId(userId);
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userAgentActive(User user, String agentIp, int agentPort, boolean overSSL, UUID agentNodeId, String agentName, String agentToken, long benchmark) {
        GridNode agent;
        this.userAgentsLock.readLock().lock();
        try {
            agent = this.userAgents.get(user.getId());
        }
        finally {
            this.userAgentsLock.readLock().unlock();
        }
        if (agent == null) {
            agent = this.newUserAgent(agentNodeId, agentIp, agentPort, overSSL, agentName, agentToken, benchmark, user.getId());
            this.userAgentsLock.writeLock().lock();
            try {
                this.userAgents.put(user.getId(), agent);
            }
            finally {
                this.userAgentsLock.writeLock().unlock();
            }
            logger.info("User agent '{}' (for user '{}') is active.", (Object)agent.getAddress(), (Object)user.getName());
        } else if (!agent.getId().equals(agentNodeId)) {
            agent = this.newUserAgent(agentNodeId, agentIp, agentPort, overSSL, agentName, agentToken, benchmark, user.getId());
            this.userAgentsLock.writeLock().lock();
            try {
                this.userAgents.put(user.getId(), agent);
            }
            finally {
                this.userAgentsLock.writeLock().unlock();
            }
            logger.info("User agent '{}' (for user '{}') is restarted.", (Object)agent.getAddress(), (Object)user.getName());
        } else if (!agent.getIp().equals(agentIp)) {
            logger.info("Ip address of user agent '{}' (for user '{}') is changed, restarting...", (Object)agent.getAddress(), (Object)user.getName());
            this.userAgentsLock.writeLock().lock();
            try {
                this.userAgents.remove(user.getId());
            }
            finally {
                this.userAgentsLock.writeLock().unlock();
            }
            agent = null;
        }
        if (agent != null) {
            agent.setHostName(agentName);
            agent.setLastPulse(new Date());
            agent.setToken(agentToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildAgentActive(String agentIp, int agentPort, boolean overSSL, UUID agentNodeId, String agentHostName, String agentToken, long benchmark, CloudProfile cloudProfile, String nodeInstanceId) {
        GridNode agent = null;
        this.buildAgentsLock.readLock().lock();
        try {
            for (GridNode each : this.buildAgents) {
                if (!each.getIp().equals(agentIp) || each.getPort() != agentPort) continue;
                agent = each;
                break;
            }
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
        if (agent == null) {
            boolean found = false;
            this.buildAgentsLock.writeLock().lock();
            try {
                Iterator<GridNode> it = this.buildAgents.iterator();
                while (it.hasNext()) {
                    agent = it.next();
                    if (!agent.getId().equals(agentNodeId)) continue;
                    logger.info("Ip address of build agent '{}' is changed, restarting...", (Object)agent.getAddress());
                    it.remove();
                    found = true;
                    break;
                }
            }
            finally {
                this.buildAgentsLock.writeLock().unlock();
            }
            if (!found) {
                agent = new GridNode(agentNodeId, agentIp, agentPort, overSSL);
                agent.setHostName(agentHostName);
                agent.setBenchmark(benchmark);
                agent.setIsServer(false);
                agent.setToken(agentToken);
                agent.setLaunchId(nodeInstanceId);
                agent.setLastPulse(new Date());
                this.useCloudProfile(agent, cloudProfile);
                logger.info("Build agent '{}' is active.", (Object)agent.getAddress());
                this.buildAgentsLock.writeLock().lock();
                try {
                    this.buildAgents.add(agent);
                }
                finally {
                    this.buildAgentsLock.writeLock().unlock();
                }
                BuildEngine.instance.processImmediately();
            }
        } else if (!agent.getId().equals(agentNodeId)) {
            agent.setId(agentNodeId);
            agent.setOverSSL(overSSL);
            agent.setHostName(agentHostName);
            agent.setToken(agentToken);
            agent.setBenchmark(benchmark);
            agent.setLaunchId(nodeInstanceId);
            this.useCloudProfile(agent, cloudProfile);
            agent.setLastPulse(new Date());
            logger.info("Build agent '{}' is restarted.", (Object)agent.getAddress());
        } else {
            agent.setHostName(agentHostName);
            agent.setLastPulse(new Date());
            agent.setToken(agentToken);
        }
    }

    private void useCloudProfile(GridNode node, CloudProfile profile) {
        if (profile != null && profile.getTestInfo() != null && profile.getTestInfo().getNodeCharacteristics() != null) {
            node.setCharacteristics(profile.getTestInfo().getNodeCharacteristics().copy());
        } else {
            logger.info("Retrieving node characteristics from agent '{}'...", (Object)node.getAddress());
            node.setCharacteristics(node.getNodeService().getNodeCharacteristics());
        }
        if (profile != null && !profile.getProfileAttributes().isEmpty()) {
            Map<String, String> userAttributes = node.getUserAttributes();
            for (Property property : profile.getProfileAttributes()) {
                userAttributes.put(property.getName(), property.getValue());
            }
            logger.info("Updating user attributes to agent '{}'...", (Object)node.getAddress());
            node.setUserAttributes(userAttributes, true);
        }
        if (profile != null) {
            node.setCloudProfile(new CloudProfile());
            node.getCloudProfile().setId(profile.getId());
            node.getCloudProfile().setName(profile.getName());
            node.getCloudProfile().setIdleTimeToTerminate(profile.getIdleTimeToTerminate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userAgentStopped(User user) {
        GridNode agent;
        this.userAgentsLock.writeLock().lock();
        try {
            agent = this.userAgents.remove(HibernateUtils.getId(user));
        }
        finally {
            this.userAgentsLock.writeLock().unlock();
        }
        if (agent != null) {
            logger.info("User agent '{}' (for user '{}') is stopped", (Object)agent.getAddress(), (Object)user.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildAgentStopped(String agentIp, int agentPort) {
        this.buildAgentsLock.writeLock().lock();
        try {
            Iterator<GridNode> it = this.buildAgents.iterator();
            while (it.hasNext()) {
                GridNode agent = it.next();
                if (!agent.getIp().equals(agentIp) || agent.getPort() != agentPort) continue;
                it.remove();
                logger.info("Build agent '{}' is stopped.", (Object)agent.getAddress());
                break;
            }
        }
        finally {
            this.buildAgentsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNode getAgentById(UUID nodeId) {
        this.buildAgentsLock.readLock().lock();
        try {
            for (GridNode agent : this.buildAgents) {
                if (!agent.getId().equals(nodeId)) continue;
                GridNode gridNode = agent;
                return gridNode;
            }
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
        this.userAgentsLock.readLock().lock();
        try {
            for (GridNode agent : this.userAgents.values()) {
                if (!agent.getId().equals(nodeId)) continue;
                GridNode gridNode = agent;
                return gridNode;
            }
        }
        finally {
            this.userAgentsLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNode getAgentByAddress(String nodeAddress) {
        this.buildAgentsLock.readLock().lock();
        try {
            for (GridNode agent : this.buildAgents) {
                if (!agent.getAddress().equals(nodeAddress)) continue;
                GridNode gridNode = agent;
                return gridNode;
            }
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
        this.userAgentsLock.readLock().lock();
        try {
            for (GridNode agent : this.userAgents.values()) {
                if (!agent.getAddress().equals(nodeAddress)) continue;
                GridNode gridNode = agent;
                return gridNode;
            }
        }
        finally {
            this.userAgentsLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNode getUserAgent(User user) {
        this.userAgentsLock.readLock().lock();
        try {
            GridNode gridNode = this.userAgents.get(HibernateUtils.getId(user));
            return gridNode;
        }
        finally {
            this.userAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unauthorizedAgentConnected(String ip, int port, boolean overSSL, String hostName) {
        this.unauthorizedBuildAgentsLock.readLock().lock();
        try {
            for (UnauthorizedAgent agent : this.unauthorizedBuildAgents) {
                if (!agent.getIp().equals(ip) || agent.getPort() != port) continue;
                agent.setHostName(hostName);
                agent.setLastPulse(new Date());
                return;
            }
        }
        finally {
            this.unauthorizedBuildAgentsLock.readLock().unlock();
        }
        UnauthorizedAgent agent = new UnauthorizedAgent(ip, port, overSSL, hostName);
        this.unauthorizedBuildAgentsLock.writeLock().lock();
        try {
            this.unauthorizedBuildAgents.add(agent);
        }
        finally {
            this.unauthorizedBuildAgentsLock.writeLock().unlock();
        }
        logger.info("Unauthorized build agent '{}:{}' connected", (Object)hostName, (Object)port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unauthorizedAgentDisconnected(String ip, int port) {
        this.unauthorizedBuildAgentsLock.writeLock().lock();
        try {
            Iterator<UnauthorizedAgent> it = this.unauthorizedBuildAgents.iterator();
            while (it.hasNext()) {
                UnauthorizedAgent agent = it.next();
                if (!agent.getIp().equals(ip) || agent.getPort() != port) continue;
                it.remove();
                logger.info("Unauthorized build agent '{}:{}' disconnected", (Object)agent.getHostName(), (Object)port);
                break;
            }
        }
        finally {
            this.unauthorizedBuildAgentsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UnauthorizedAgent> getUnauthorizedAgents() {
        this.unauthorizedBuildAgentsLock.readLock().lock();
        try {
            ArrayList<UnauthorizedAgent> arrayList = new ArrayList<UnauthorizedAgent>(this.unauthorizedBuildAgents);
            return arrayList;
        }
        finally {
            this.unauthorizedBuildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnauthorizedAgent(String ip, int port) {
        this.unauthorizedBuildAgentsLock.writeLock().lock();
        try {
            Iterator<UnauthorizedAgent> it = this.unauthorizedBuildAgents.iterator();
            while (it.hasNext()) {
                UnauthorizedAgent agent = it.next();
                if (!agent.getIp().equals(ip) || agent.getPort() != port) continue;
                it.remove();
            }
        }
        finally {
            this.unauthorizedBuildAgentsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBuildAgent(String ip, int port) {
        this.buildAgentsLock.writeLock().lock();
        try {
            Iterator<GridNode> it = this.buildAgents.iterator();
            while (it.hasNext()) {
                GridNode agent = it.next();
                if (!agent.getIp().equals(ip) || agent.getPort() != port) continue;
                it.remove();
                break;
            }
        }
        finally {
            this.buildAgentsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserAgent(User user) {
        this.userAgentsLock.writeLock().lock();
        try {
            this.userAgents.remove(HibernateUtils.getId(user));
        }
        finally {
            this.userAgentsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GridNode> getBuildAgents() {
        this.buildAgentsLock.readLock().lock();
        try {
            ArrayList<GridNode> arrayList = new ArrayList<GridNode>(this.buildAgents);
            return arrayList;
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNode getBuildAgentById(UUID nodeId) {
        this.buildAgentsLock.readLock().lock();
        try {
            for (GridNode agent : this.buildAgents) {
                if (!agent.getId().equals(nodeId)) continue;
                GridNode gridNode = agent;
                return gridNode;
            }
            GridNode gridNode = null;
            return gridNode;
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNode getBuildAgentByAddress(String address) {
        this.buildAgentsLock.readLock().lock();
        try {
            for (GridNode agent : this.buildAgents) {
                if (!agent.getAddress().equals(address)) continue;
                GridNode gridNode = agent;
                return gridNode;
            }
            GridNode gridNode = null;
            return gridNode;
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnauthorizedAgent getUnauthorizedAgent(String address) {
        this.unauthorizedBuildAgentsLock.readLock().lock();
        try {
            for (UnauthorizedAgent agent : this.unauthorizedBuildAgents) {
                if (!agent.getAddress().equals(address)) continue;
                UnauthorizedAgent unauthorizedAgent = agent;
                return unauthorizedAgent;
            }
            UnauthorizedAgent unauthorizedAgent = null;
            return unauthorizedAgent;
        }
        finally {
            this.unauthorizedBuildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnauthorizedAgentCount() {
        this.unauthorizedBuildAgentsLock.readLock().lock();
        try {
            int n = this.unauthorizedBuildAgents.size();
            return n;
        }
        finally {
            this.unauthorizedBuildAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserAgentCount() {
        this.userAgentsLock.readLock().lock();
        try {
            int n = this.userAgents.size();
            return n;
        }
        finally {
            this.userAgentsLock.readLock().unlock();
        }
    }

    @Override
    public int getAgentCount() {
        return this.getBuildAgentCount() + this.getUserAgentCount();
    }

    @Override
    public int getHeartbeatInterval() {
        int interval = (this.getAgentCount() + this.getUnauthorizedAgentCount()) / 5;
        if (interval < 2) {
            interval = 2;
        }
        return interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GridNode> getUserAgents() {
        this.userAgentsLock.readLock().lock();
        try {
            ArrayList<GridNode> arrayList = new ArrayList<GridNode>(this.userAgents.values());
            return arrayList;
        }
        finally {
            this.userAgentsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNode getBuildAgentByToken(String token) {
        this.buildAgentsLock.readLock().lock();
        try {
            for (GridNode node : this.buildAgents) {
                if (!token.equals(node.getToken())) continue;
                GridNode gridNode = node;
                return gridNode;
            }
            GridNode gridNode = null;
            return gridNode;
        }
        finally {
            this.buildAgentsLock.readLock().unlock();
        }
    }
}

