/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.ServletUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFilesJob
implements NodeJob {
    private static final Logger logger = LoggerFactory.getLogger(CopyFilesJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable execute(Serializable ... params) {
        String content;
        GridNode fromNode = (GridNode)params[0];
        String srcPath = (String)((Object)params[1]);
        String filePatterns = (String)((Object)params[2]);
        String destPath = (String)((Object)params[3]);
        Boolean compress = (Boolean)params[4];
        String lockForReadPath = (String)((Object)params[5]);
        String lockForWritePath = (String)((Object)params[6]);
        boolean tarToDisk = "true".equals(System.getProperty("TAR_TO_DISK"));
        GridNode localNode = Grid.instance.getLocalNode();
        if (localNode.getIp().equals(fromNode.getIp())) {
            if (FilenameUtils.equalsNormalizedOnSystem((String)srcPath, (String)destPath)) {
                logger.debug("No need to copy files since nodes and directories are the same.");
                return null;
            }
            logger.debug("Copying files (from dir: {}, to dir: {}, files: {}).", new Object[]{srcPath, destPath, filePatterns});
            Lock readLock = null;
            if (lockForReadPath != null) {
                readLock = LockUtils.lockForRead(new File(lockForReadPath));
            }
            try {
                Lock writeLock = null;
                if (lockForWritePath != null) {
                    writeLock = LockUtils.lockForWrite(new File(lockForWritePath));
                }
                try {
                    File destDir = new File(destPath);
                    FileUtils.createDir(destDir);
                    FileUtils.copyFiles(new File(srcPath), filePatterns, destDir);
                    return null;
                }
                finally {
                    if (writeLock != null) {
                        writeLock.unlock();
                    }
                }
            }
            finally {
                if (readLock != null) {
                    readLock.unlock();
                }
            }
        }
        long time = System.currentTimeMillis();
        logger.debug("Downloading files (from node: {}, from dir: {}, to dir: {}, files: {}, compress: {}, tar to disk: {})...", new Object[]{fromNode.getAddress(), srcPath, destPath, filePatterns, compress, tarToDisk});
        if (filePatterns == null) {
            filePatterns = "";
        }
        try {
            content = "baseDir=" + URLEncoder.encode(srcPath, "UTF-8") + "&filePatterns=" + URLEncoder.encode(filePatterns, "UTF-8");
            content = content + "&compress=" + compress;
            content = content + "&tarToDisk=" + tarToDisk;
            if (lockForReadPath != null) {
                content = content + "&lock=" + URLEncoder.encode(lockForReadPath, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (!tarToDisk) {
            Lock writeLock = null;
            if (lockForWritePath != null) {
                writeLock = LockUtils.lockForWrite(new File(lockForWritePath));
            }
            try {
                File destDir = new File(destPath);
                HttpURLConnection urlConn = null;
                BufferedInputStream bis = null;
                InputStream is = null;
                try {
                    FileUtils.createDir(destDir);
                    urlConn = (HttpURLConnection)new URL(fromNode.getFileTransferUrl() + "?" + content).openConnection();
                    urlConn.setConnectTimeout(120000);
                    urlConn.setReadTimeout(300000);
                    byte[] encoded = Base64.encodeBase64((byte[])fromNode.getToken().getBytes());
                    urlConn.setRequestProperty("Authorization", "Basic " + new String(encoded));
                    is = urlConn.getInputStream();
                    while (is.read() == 0) {
                    }
                    bis = new BufferedInputStream(is, 65536);
                    FileUtils.untar(bis, compress, destDir);
                    logger.debug("Finished downloading files.");
                }
                catch (MalformedURLException e) {
                    try {
                        throw new RuntimeException(e);
                        catch (IOException e2) {
                            throw ServletUtils.wrapException(urlConn, e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bis);
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)bis);
                IOUtils.closeQuietly((InputStream)is);
                return null;
            }
            finally {
                if (writeLock != null) {
                    writeLock.unlock();
                }
                if (Bootstrap.isServer()) {
                    MetricsManager.instance.uploadRequestProcessed(System.currentTimeMillis() - time);
                }
            }
        }
        File tempFile = new File(Bootstrap.getTempDir(), "untar-" + UUID.randomUUID().toString());
        try {
            HttpURLConnection urlConn = null;
            InputStream is = null;
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            try {
                int count;
                urlConn = (HttpURLConnection)new URL(fromNode.getFileTransferUrl() + "?" + content).openConnection();
                urlConn.setConnectTimeout(120000);
                urlConn.setReadTimeout(300000);
                byte[] encoded = Base64.encodeBase64((byte[])fromNode.getToken().getBytes());
                urlConn.setRequestProperty("Authorization", "Basic " + new String(encoded));
                is = urlConn.getInputStream();
                while (is.read() == 0) {
                }
                bis = new BufferedInputStream(is, 65536);
                byte[] data = new byte[65536];
                bos = new BufferedOutputStream(new FileOutputStream(tempFile), 65536);
                while ((count = ((InputStream)bis).read(data)) > -1) {
                    ((OutputStream)bos).write(data, 0, count);
                }
            }
            catch (MalformedURLException e) {
                try {
                    throw new RuntimeException(e);
                    catch (IOException e3) {
                        throw ServletUtils.wrapException(urlConn, e3);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)bos);
            logger.debug("Finished receiving files.");
            Lock writeLock = null;
            if (lockForWritePath != null) {
                writeLock = LockUtils.lockForWrite(new File(lockForWritePath));
            }
            try {
                File destDir = new File(destPath);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(tempFile);
                    FileUtils.createDir(destDir);
                    FileUtils.untar(fis, compress, destDir);
                    logger.debug("Finished extracting files.");
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
                return null;
            }
            finally {
                if (writeLock != null) {
                    writeLock.unlock();
                }
            }
        }
        finally {
            if (tempFile.exists()) {
                FileUtils.deleteFile(tempFile);
            }
            if (Bootstrap.isServer()) {
                MetricsManager.instance.uploadRequestProcessed(System.currentTimeMillis() - time);
            }
        }
    }
}

