/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.ServletUtils;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.FilenameUtils;

public class CopyFileJob
implements NodeJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable execute(Serializable ... params) {
        GridNode fromNode = (GridNode)params[0];
        String srcPath = (String)((Object)params[1]);
        String destPath = (String)((Object)params[2]);
        String lockForReadPath = (String)((Object)params[3]);
        String lockForWritePath = (String)((Object)params[4]);
        GridNode localNode = Grid.instance.getLocalNode();
        if (localNode.getIp().equals(fromNode.getIp())) {
            if (!FilenameUtils.equalsNormalizedOnSystem((String)srcPath, (String)destPath)) {
                Lock readLock = null;
                if (lockForReadPath != null) {
                    readLock = LockUtils.lockForRead(new File(lockForReadPath));
                }
                try {
                    Lock writeLock = null;
                    if (lockForWritePath != null) {
                        writeLock = LockUtils.lockForWrite(new File(lockForWritePath));
                    }
                    try {
                        File destFile = new File(destPath);
                        FileUtils.createDir(destFile.getParentFile());
                        FileUtils.copyFile(new File(srcPath), destFile);
                    }
                    finally {
                        if (writeLock != null) {
                            writeLock.unlock();
                        }
                    }
                }
                finally {
                    if (readLock != null) {
                        readLock.unlock();
                    }
                }
            }
        } else {
            long time = System.currentTimeMillis();
            try {
                String content = "file=" + URLEncoder.encode(srcPath, "UTF-8");
                if (lockForReadPath != null) {
                    content = content + "&lock=" + URLEncoder.encode(lockForReadPath, "UTF-8");
                }
                Lock writeLock = null;
                if (lockForWritePath != null) {
                    writeLock = LockUtils.lockForWrite(new File(lockForWritePath));
                }
                try {
                    File destFile = new File(destPath);
                    FileUtils.createDir(destFile.getParentFile());
                    ServletUtils.download(fromNode.getFileTransferUrl() + "?" + content, fromNode.getToken(), destFile);
                }
                finally {
                    if (writeLock != null) {
                        writeLock.unlock();
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (Bootstrap.isServer()) {
                    MetricsManager.instance.uploadRequestProcessed(System.currentTimeMillis() - time);
                }
            }
        }
        return null;
    }
}

