/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianServlet;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.AuthenticationException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.RemotingProxyFactory;
import com.pmease.quickbuild.RemotingSerializerFactory;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.bootstrap.ConnectResult;
import com.pmease.quickbuild.bootstrap.ConnectService;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.extensionpoint.NodeCloud;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeCharacteristics;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.cloud.UserDataRetrieverJob;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.EasySet;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.hibernate.util.SerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectServlet
extends HessianServlet
implements ConnectService {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<HttpServletRequest> requestHolder = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(ConnectServlet.class);
    public static final Set<String> ALLOWED_DIRS = EasySet.create("framework", "asset", "plugins");

    public SerializerFactory getSerializerFactory() {
        return new RemotingSerializerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        long time = System.currentTimeMillis();
        try {
            requestHolder.set((HttpServletRequest)request);
            SessionManager.openSession();
            super.service(request, response);
        }
        finally {
            requestHolder.set(null);
            SessionManager.closeSession();
            MetricsManager.instance.rpcRequestProcessed(System.currentTimeMillis() - time);
        }
    }

    private HttpServletRequest getRequest() {
        return requestHolder.get();
    }

    private String getAgentToken() {
        String authorizationHeader = this.getRequest().getHeader("Authorization");
        if (authorizationHeader != null) {
            String agentToken = StringUtils.substringAfter((String)authorizationHeader, (String)" ");
            return new String(Base64.decodeBase64((byte[])agentToken.getBytes()));
        }
        throw new AccessDeniedException();
    }

    public ConnectResult connect(int agentPort, boolean overSSL, String agentIp, String agentHostName, long benchmark, UUID agentNodeId, String serverToken) {
        if (agentIp == null && (agentIp = this.getRequest().getHeader("X-Forwarded-For")) == null) {
            agentIp = this.getRequest().getRemoteAddr();
        }
        ConnectResult result = new ConnectResult();
        result.setServerToken(Bootstrap.serverToken);
        result.setAgentIp(agentIp);
        result.setHeartbeatInterval(AgentManager.instance.getHeartbeatInterval());
        String agentToken = this.getAgentToken();
        result.setAgentToken(agentToken);
        if (agentNodeId != null) {
            if (agentToken.indexOf(58) == -1) {
                boolean authorized = false;
                Token token = CacheManager.instance.getToken(agentToken);
                if (token != null) {
                    GridNode agent = AgentManager.instance.getBuildAgentByToken(token.getValue());
                    if (agent != null) {
                        if (agent.getId().equals(agentNodeId) || agent.getIp().equals(agentIp) && agent.getPort() == agentPort) {
                            authorized = true;
                        }
                    } else {
                        authorized = true;
                    }
                }
                if (!authorized) {
                    RemotingProxyFactory factory = new RemotingProxyFactory(agentToken);
                    String url = overSSL ? "https://" + agentIp + ":" + agentPort : "http://" + agentIp + ":" + agentPort;
                    NodeService nodeService = (NodeService)factory.create(NodeService.class, url, "/service/node");
                    token = CacheManager.instance.getToken(agentIp, agentPort);
                    if (token != null) {
                        AccessDeniedException ex;
                        try {
                            nodeService.updateAgentToken(token.getValue());
                            ex = new AccessDeniedException("Access token has been sent to agent '" + agentIp + ":" + agentPort + "'. Now expecting " + "re-authentication with the new access token.");
                        }
                        catch (Exception e) {
                            logger.error("Error sending access token.", (Throwable)e);
                            ex = new AccessDeniedException("Failed to send access token from server to agent '" + agentIp + ":" + agentPort + "'. Please make sure the agent is reporting " + "the correct IP address and there is no firewall blocking connection from " + "server to this agent.");
                        }
                        ex.setPayload((Serializable)result);
                        throw ex;
                    }
                    try {
                        for (NodeCloud each : PluginManager.instance.getExtensions(NodeCloud.class)) {
                            Serializable[] retrieverParams = each.getUserDataRetrieverParams();
                            Serializable[] params = new Serializable[retrieverParams.length + 1];
                            params[0] = each.getUserDataRetrieverClass();
                            for (int i = 0; i < retrieverParams.length; ++i) {
                                params[i + 1] = retrieverParams[i];
                            }
                            byte[] userDataBytes = nodeService.executeShortJob(UserDataRetrieverJob.class, SerializationHelper.serialize((Serializable)params));
                            String userData = (String)SerializationHelper.deserialize(userDataBytes);
                            if (userData == null || !userData.startsWith("<$CloudNodeUserData$>")) continue;
                            agentToken = userData.substring("<$CloudNodeUserData$>".length());
                            token = CacheManager.instance.getToken(agentToken);
                            if (token != null) {
                                GridNode agent = AgentManager.instance.getBuildAgentByToken(token.getValue());
                                if (agent != null) {
                                    if (agent.getIp().equals(agentIp) && agent.getPort() == agentPort) {
                                        authorized = true;
                                    }
                                } else {
                                    authorized = true;
                                }
                                if (authorized) {
                                    nodeService.updateAgentToken(agentToken);
                                }
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error assuming '" + agentHostName + ":" + agentPort + "' as cloud node.", (Throwable)e);
                        }
                        authorized = false;
                    }
                }
                if (!authorized) {
                    AgentManager.instance.unauthorizedAgentConnected(agentIp, agentPort, overSSL, agentHostName);
                    AccessDeniedException ex = new AccessDeniedException("Build agent '" + agentHostName + ":" + agentPort + "' is not authorized to join the grid.\n" + "Please follow below steps to authorize this agent:\n" + "1. Keep this agent running.\n" + "2. Login to QuickBuild as administrator and switch to menu 'Grid->Unauthorized Nodes'.\n" + "3. Select the agent from there and click the authorize button.");
                    ex.setPayload((Serializable)result);
                    throw ex;
                }
                if (Bootstrap.serverToken.equals(serverToken)) {
                    CloudProfile cloudProfile = token.getCloudProfile() != null ? CacheManager.instance.getCloudProfile(token.getCloudProfile().getId()) : null;
                    if (cloudProfile != null && token.isTest()) {
                        if (cloudProfile.getTestInfo() != null && cloudProfile.getTestInfo().getTestToken().equals(token.getValue())) {
                            logger.info("Retrieving system and user attributes from cloud profile testing node '{}'...", (Object)(agentHostName + ":" + agentPort));
                            RemotingProxyFactory factory = new RemotingProxyFactory(agentToken);
                            String url = overSSL ? "https://" + agentIp + ":" + agentPort : "http://" + agentIp + ":" + agentPort;
                            NodeService nodeService = (NodeService)factory.create(NodeService.class, url, "/service/node");
                            NodeCharacteristics nodeCharacteristics = nodeService.getNodeCharacteristics();
                            cloudProfile = (CloudProfile)CloudProfileManager.instance.load(cloudProfile.getId());
                            if (cloudProfile.getTestInfo() != null) {
                                cloudProfile.getTestInfo().setErrorMessage(null);
                                cloudProfile.getTestInfo().setNodeCharacteristics(nodeCharacteristics);
                                cloudProfile.getTestInfo().setNodeBenchmark(benchmark);
                                cloudProfile.getTestInfo().setNodeOverSSL(overSSL);
                                CloudProfileManager.instance.save(cloudProfile);
                            }
                        }
                        logger.info("Terminating test launched node (profile: {}, address: {}, launch id: {})...", new Object[]{cloudProfile.getName(), agentHostName + ":" + agentPort, token.getNodeLaunchId()});
                        cloudProfile.getNodeLauncher().terminateNode(token.getNodeLaunchId());
                        TokenManager.instance.delete(TokenManager.instance.load(token.getId()));
                    } else {
                        AgentManager.instance.buildAgentActive(agentIp, agentPort, overSSL, agentNodeId, agentHostName, agentToken, benchmark, cloudProfile, token.getNodeLaunchId());
                        if (!token.getIp().equals(agentIp) || token.getPort() != agentPort || !token.getHostName().equals(agentHostName)) {
                            Token reloaded;
                            Token existing = CacheManager.instance.getToken(agentIp, agentPort);
                            if (existing != null && !existing.getId().equals(token.getId()) && (existing = (Token)TokenManager.instance.get(existing.getId())) != null) {
                                TokenManager.instance.delete(existing);
                            }
                            if ((reloaded = (Token)TokenManager.instance.get(token.getId())) == null) {
                                reloaded = new Token();
                                reloaded.setValue(token.getValue());
                                reloaded.setCloudProfile(token.getCloudProfile());
                                reloaded.setNodeLaunchId(token.getNodeLaunchId());
                                reloaded.setOfflineAlert(token.isOfflineAlert());
                                reloaded.setTest(token.isTest());
                            }
                            reloaded.setHostName(agentHostName);
                            reloaded.setIp(agentIp);
                            reloaded.setPort(agentPort);
                            TokenManager.instance.save(reloaded);
                        }
                    }
                }
                return result;
            }
            String userName = StringUtils.substringBefore((String)agentToken, (String)":");
            User user = CacheManager.instance.getUser(userName);
            if (user == null) {
                throw new AuthenticationException("User '" + userName + "' does not exist.");
            }
            String passwordHash = StringUtils.substringAfter((String)agentToken, (String)":");
            if (!user.getPassword().equals(passwordHash)) {
                throw new AuthenticationException("Password incorrect for user '" + userName + ".");
            }
            if (!CacheManager.instance.isAgentAllowed(user)) {
                throw new AccessDeniedException("User '" + user.getName() + "' does not have " + "permission to connect user agent.");
            }
            if (Bootstrap.serverToken.equals(serverToken)) {
                AgentManager.instance.userAgentActive(user, agentIp, agentPort, overSSL, agentNodeId, agentHostName, agentToken, benchmark);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disconnect(int agentPort, String agentIp) {
        String agentToken;
        if (agentIp == null && (agentIp = this.getRequest().getHeader("X-Forwarded-For")) == null) {
            agentIp = this.getRequest().getRemoteAddr();
        }
        if ((agentToken = this.getAgentToken()).indexOf(58) == -1) {
            Token token = CacheManager.instance.getToken(agentIp, agentPort);
            if (token != null) {
                if (!token.getValue().equals(agentToken)) throw new AccessDeniedException("Can not disconnect other agents.");
                AgentManager.instance.buildAgentStopped(agentIp, agentPort);
                return;
            } else {
                AgentManager.instance.unauthorizedAgentDisconnected(agentIp, agentPort);
            }
            return;
        } else {
            User user = CacheManager.instance.getUser(StringUtils.substringBefore((String)agentToken, (String)":"));
            String passwordHash = StringUtils.substringAfter((String)agentToken, (String)":");
            if (user == null || !user.getPassword().equals(passwordHash) || !CacheManager.instance.isAgentAllowed(user)) return;
            AgentManager.instance.userAgentStopped(user);
        }
    }

    public Map<String, Long> getFiles(String dir, String suffix) {
        boolean found = false;
        for (String each : ALLOWED_DIRS) {
            if (!dir.startsWith(each)) continue;
            found = true;
        }
        if (!found || dir.contains("..")) {
            throw new AccessDeniedException();
        }
        HashMap<String, Long> fileSizes = new HashMap<String, Long>();
        File[] files = new File(Bootstrap.installDir, dir).listFiles();
        Validate.notNull((Object)files);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || suffix != null && !files[i].getName().endsWith(suffix)) continue;
            fileSizes.put(files[i].getName(), files[i].length());
        }
        return fileSizes;
    }
}

