/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.RemotingProxyFactory;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.bootstrap.ConnectResult;
import com.pmease.quickbuild.bootstrap.ConnectService;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConnectivityTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AgentConnectivityTask.class);

    @Override
    public void run() {
        block14: {
            if (Bootstrap.isServer()) {
                while (true) {
                    int timeout;
                    if ((timeout = CacheManager.instance.getSystemSetting().getAgentTimeout()) == 0) {
                        timeout = 6 * AgentManager.instance.getHeartbeatInterval();
                    } else if (timeout < 3 * AgentManager.instance.getHeartbeatInterval()) {
                        timeout = 3 * AgentManager.instance.getHeartbeatInterval();
                        logger.warn("Agent timeout should be at least {} seconds.", (Object)timeout);
                    }
                    try {
                        AgentManager.instance.removeTimedoutAgents(timeout);
                    }
                    catch (Exception e) {
                        logger.error("Error monitoring agents.", (Throwable)e);
                    }
                    try {
                        Thread.sleep(timeout * 1000);
                    }
                    catch (InterruptedException e) {
                        break block14;
                    }
                }
            }
            while (true) {
                try {
                    GridNode localNode = Grid.instance.getLocalNode();
                    RemotingProxyFactory factory = new RemotingProxyFactory(Bootstrap.getAgentToken());
                    ConnectService connectService = (ConnectService)factory.create(ConnectService.class, Bootstrap.serverUrl + "/service/connect");
                    logger.trace("Sending heartbeat to server '" + Bootstrap.serverUrl + "'...");
                    ConnectResult connectResult = connectService.connect(localNode.getPort(), localNode.isOverSSL(), Quickbuild.getInstance().getSpecifiedNodeIp(), localNode.getHostName(), localNode.getBenchmark(), localNode.getId(), Bootstrap.serverToken);
                    if (Quickbuild.getInstance().processConnectResult(connectResult)) break;
                    Quickbuild.getInstance().setConnected(true);
                }
                catch (Throwable throwable) {
                    Quickbuild.getInstance().setConnected(false);
                    if (Quickbuild.getInstance().handleConnectException(throwable)) break;
                }
                try {
                    Thread.sleep(Bootstrap.heartbeatInterval * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            Quickbuild.getInstance().setConnected(false);
        }
    }
}

