/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.extensionpoint.support;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import com.pmease.quickbuild.web.page.dashboard.FailsafeGadget;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Gadget
extends TypeInstance {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Gadget.class);
    private String title;

    @Editable(order=1, description="Give a title to this gadget instance.")
    @Name
    @NotEmpty
    @Scriptable
    public String getTitle() {
        return this.title;
    }

    public String getInterpolatedTitle() {
        DashboardPage page = (DashboardPage)BasePage.get();
        if (SecurityHelper.isScriptAllowed(page.getActiveDashboard().getUser())) {
            try {
                return ScriptEngine.instance.interpolate(this.getTitle(), Context.buildEvalContext(null, null));
            }
            catch (Exception e) {
                logger.error("Error interpolating gadget title.", (Throwable)e);
                return "Error interpolating gadget title. Check server log for details.";
            }
        }
        if (ScriptEngine.instance.interpolative(this.getTitle())) {
            return "Title contains script but it is created by not trusted user.";
        }
        return this.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Component renderHead(String componentId) {
        return new Label(componentId, this.getInterpolatedTitle());
    }

    public abstract Component renderBody(String var1);

    public String getCssClass() {
        return null;
    }

    public static Gadget fromDOM(VersionedDocument dom) {
        try {
            Gadget gadget = (Gadget)dom.toBean();
            boolean found = false;
            PluginManager pluginManager = Quickbuild.getInstance(PluginManager.class);
            for (GadgetProvider provider : pluginManager.getExtensions(GadgetProvider.class)) {
                if (provider.getGadgetClass() != gadget.getClass()) continue;
                found = true;
                break;
            }
            if (!found) {
                String errorMessage = "Can not find provider of gadget class: " + gadget.getClass().getName();
                gadget = new FailsafeGadget(dom.getRootElement().elementTextTrim("title"), errorMessage);
            }
            return gadget;
        }
        catch (Exception e) {
            logger.error("Error constructing gadget from DOM.", (Throwable)e);
            FailsafeGadget gadget = new FailsafeGadget(dom.getRootElement().elementTextTrim("title"), e.getClass().getSimpleName() + ":" + e.getMessage());
            return gadget;
        }
    }

    public static Gadget newInstance(String gadgetClassName) {
        try {
            Class<?> gadgetClass = Class.forName(gadgetClassName);
            return (Gadget)gadgetClass.newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }
}

