/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.extensionpoint.support;

import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.extensionpoint.support.GadgetErrorPanel;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.ContextContainer;
import com.pmease.quickbuild.web.component.editor.EditContext;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationBasedGadget
extends Gadget {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationBasedGadget.class);
    private String configurationPath;

    @Editable(name="Configuration", order=10)
    @ConfigurationPath
    @NotEmpty
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Override
    public final Component renderHead(String componentId) {
        final Configuration configuration = ConfigurationManager.instance.get(this.getConfigurationPath());
        if (configuration != null) {
            return new ContextContainer(componentId, (IModel)new LoadableDetachableModel<Build>(){

                protected Build load() {
                    Build build = new Build();
                    build.setConfiguration((Configuration)ConfigurationManager.instance.load(configuration.getId()));
                    return build;
                }
            }){

                @Override
                protected Component render(String id) {
                    try {
                        return ConfigurationBasedGadget.this.renderHeadForConfiguration(id);
                    }
                    catch (Exception e) {
                        logger.error("Error rendering gadget head.", (Throwable)e);
                        return new Label(id, ConfigurationBasedGadget.this.getInterpolatedTitle());
                    }
                }
            };
        }
        return new Label(componentId, this.getInterpolatedTitle());
    }

    protected Component renderHeadForConfiguration(String componentId) {
        return new Label(componentId, this.getInterpolatedTitle());
    }

    public final Panel renderBody(String panelId) {
        final Configuration configuration = ConfigurationManager.instance.get(this.getConfigurationPath());
        if (configuration != null) {
            return new ContextContainer(panelId, (IModel)new LoadableDetachableModel<Build>(){

                protected Build load() {
                    Build build = new Build();
                    build.setConfiguration((Configuration)ConfigurationManager.instance.load(configuration.getId()));
                    return build;
                }
            }){

                @Override
                protected Component render(String id) {
                    try {
                        return ConfigurationBasedGadget.this.renderBodyForConfiguration(id);
                    }
                    catch (Exception e) {
                        logger.error("Error rendering gadget body.", (Throwable)e);
                        return new GadgetErrorPanel("content", ExceptionUtils.extractImportantMessage(e) + ": check server log for details.");
                    }
                }
            };
        }
        return new GadgetErrorPanel(panelId, "Can not find configuration '" + this.getConfigurationPath() + "'.");
    }

    protected static Configuration guessConfiguration() {
        String configurationPath = EditContext.EditableProperty.getValueAsString("configurationPath");
        if (configurationPath != null) {
            return ConfigurationManager.instance.get(configurationPath);
        }
        return null;
    }

    protected abstract Panel renderBodyForConfiguration(String var1);
}

