/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.extensionpoint.support;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.extensionpoint.support.ConfigurationBasedGadget;
import com.pmease.quickbuild.extensionpoint.support.GadgetErrorPanel;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.ContextContainer;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuildBasedGadget
extends ConfigurationBasedGadget {
    private static final Logger logger = LoggerFactory.getLogger(BuildBasedGadget.class);
    private String configurationPath;
    private BuildLocator buildLocator;

    @Override
    @Editable(name="Configuration", order=10)
    @ConfigurationPath
    @NotEmpty
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(name="Build", order=20)
    @NotNull
    public BuildLocator getBuildLocator() {
        return this.buildLocator;
    }

    public void setBuildLocator(BuildLocator buildLocator) {
        this.buildLocator = buildLocator;
    }

    @Override
    public final Component renderHeadForConfiguration(String componentId) {
        final Build build = this.buildLocator.locateBuild(Context.getConfiguration());
        if (build != null) {
            return new ContextContainer(componentId, (IModel)new LoadableDetachableModel<Build>(){

                protected Build load() {
                    return (Build)BuildManager.instance.load(build.getId());
                }
            }){

                @Override
                protected Component render(String id) {
                    try {
                        return BuildBasedGadget.this.renderHeadForBuild(id);
                    }
                    catch (Exception e) {
                        logger.error("Error rendering gadget head.", (Throwable)e);
                        return new Label(id, BuildBasedGadget.this.getInterpolatedTitle());
                    }
                }
            };
        }
        return new Label(componentId, this.getInterpolatedTitle());
    }

    protected Component renderHeadForBuild(String componentId) {
        return new Label(componentId, this.getInterpolatedTitle());
    }

    @Override
    protected final Panel renderBodyForConfiguration(String panelId) {
        final Build build = this.buildLocator.locateBuild(Context.getConfiguration());
        if (build != null) {
            return new ContextContainer(panelId, (IModel)new LoadableDetachableModel<Build>(){

                protected Build load() {
                    return (Build)BuildManager.instance.load(build.getId());
                }
            }){

                @Override
                protected Component render(String id) {
                    try {
                        return BuildBasedGadget.this.renderBodyForBuild(id);
                    }
                    catch (Exception e) {
                        logger.error("Error rendering gadget body.", (Throwable)e);
                        return new GadgetErrorPanel("content", ExceptionUtils.extractImportantMessage(e) + ": check server log for details.");
                    }
                }
            };
        }
        return new GadgetErrorPanel(panelId, "Can not find specified build in configuration '" + this.getConfigurationPath() + "'.");
    }

    protected static Build guessBuild() {
        Configuration configuration = BuildBasedGadget.guessConfiguration();
        if (configuration != null) {
            Build build = null;
            EditContext.EditableProperty property = EditContext.EditableProperty.get("buildLocator");
            if (property.getValue() != null) {
                EditContext context = (EditContext)property.getValue();
                if (context.getBeanClass() == LatestFinishedBuildLocator.class) {
                    build = BuildManager.instance.getLatestFinished(configuration);
                } else if (context.getBeanClass() == LatestSuccessfulBuildLocator.class) {
                    build = BuildManager.instance.getLatest(configuration, Build.Status.SUCCESSFUL);
                } else if (context.getBeanClass() == LatestRecommendedBuildLocator.class) {
                    build = BuildManager.instance.getLatest(configuration, Build.Status.RECOMMENDED);
                } else {
                    String buildVersion = EditContext.EditableProperty.getValueAsString("buildLocator/buildVersion");
                    if (buildVersion != null) {
                        build = BuildManager.instance.get(configuration, buildVersion);
                    }
                }
            }
            return build;
        }
        return null;
    }

    protected abstract Panel renderBodyForBuild(String var1);

    @Editable(name="Build with Specified Version", order=400)
    public static class SpecifiedBuildLocator
    implements BuildLocator {
        private static final long serialVersionUID = 1L;
        private String buildVersion;

        @Editable
        @NotEmpty
        public String getBuildVersion() {
            return this.buildVersion;
        }

        public void setBuildVersion(String buildVersion) {
            this.buildVersion = buildVersion;
        }

        @Override
        public Build locateBuild(Configuration configuration) {
            return BuildManager.instance.get(configuration, this.getBuildVersion());
        }
    }

    @Editable(name="Latest Recommended Build", order=300)
    public static class LatestRecommendedBuildLocator
    implements BuildLocator {
        private static final long serialVersionUID = 1L;

        @Override
        public Build locateBuild(Configuration configuration) {
            return BuildManager.instance.getLatest(configuration, Build.Status.RECOMMENDED);
        }
    }

    @Editable(name="Latest Successful Build", order=200)
    public static class LatestSuccessfulBuildLocator
    implements BuildLocator {
        private static final long serialVersionUID = 1L;

        @Override
        public Build locateBuild(Configuration configuration) {
            return BuildManager.instance.getLatest(configuration, Build.Status.SUCCESSFUL);
        }
    }

    @Editable(name="Latest Finished Build", order=100)
    public static class LatestFinishedBuildLocator
    implements BuildLocator {
        private static final long serialVersionUID = 1L;

        @Override
        public Build locateBuild(Configuration configuration) {
            return BuildManager.instance.getLatestFinished(configuration);
        }
    }

    public static interface BuildLocator
    extends Serializable {
        public Build locateBuild(Configuration var1);
    }
}

