/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.execution.killtree;

import com.pmease.quickbuild.execution.killtree.VariableResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");

    public static String replaceMacro(String s, Map<String, String> properties) {
        return Util.replaceMacro(s, new VariableResolver.ByMap<String>(properties));
    }

    public static String replaceMacro(String s, VariableResolver<String> resolver) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher(s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = resolver.resolve(key);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = s.substring(0, m.start()) + value + s.substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }

    public static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String fixEmpty(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String fixEmptyAndTrim(String s) {
        if (s == null) {
            return null;
        }
        return Util.fixEmpty(s.trim());
    }

    public static <T> List<T> fixNull(List<T> l) {
        return l != null ? l : Collections.emptyList();
    }

    public static <T> Set<T> fixNull(Set<T> l) {
        return l != null ? l : Collections.emptySet();
    }

    public static <T> Collection<T> fixNull(Collection<T> l) {
        return l != null ? l : Collections.emptySet();
    }

    public static <T> Iterable<T> fixNull(Iterable<T> l) {
        return l != null ? l : Collections.emptySet();
    }

    public static String join(Collection<?> strings, String separator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Object s : strings) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> join(Collection<? extends T> ... items) {
        void var5_8;
        int size = 0;
        for (Collection<T> collection : items) {
            size += collection.size();
        }
        ArrayList<? extends T> r = new ArrayList<T>(size);
        Collection<? extends T>[] arr$ = items;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Collection<? extends T> item = arr$[var5_8];
            r.addAll(item);
            ++var5_8;
        }
        return r;
    }
}

