/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.execution.killtree;

import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.killtree.EnvVars;
import com.pmease.quickbuild.execution.killtree.GNUCLibrary;
import com.pmease.quickbuild.execution.killtree.ProcessTreeRemoting;
import com.pmease.quickbuild.execution.killtree.QuotedStringTokenizer;
import com.pmease.quickbuild.execution.killtree.Util;
import com.pmease.quickbuild.util.FileUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessTree
implements Iterable<OSProcess>,
ProcessTreeRemoting.IProcessTree {
    protected final Map<Integer, OSProcess> processes = new HashMap<Integer, OSProcess>();
    private static final Logger logger = LoggerFactory.getLogger(ProcessTree.class);
    static final ProcessTree DEFAULT = new ProcessTree(){

        @Override
        public OSProcess get(final Process proc) {
            return new OSProcess(-1){

                @Override
                public OSProcess getParent() {
                    return null;
                }

                @Override
                public void killRecursively(boolean forcibly) {
                    File killScript = FileUtils.locateLib(Commandline.class, "kill-tree.sh");
                    Commandline cmdline = new Commandline();
                    cmdline.setExecutable("sh");
                    cmdline.addArgValue(killScript.getAbsolutePath());
                    try {
                        cmdline.addArgValue(String.valueOf(UnixReflection.PID_FIELD.get(proc)));
                    }
                    catch (IllegalAccessException e) {
                        IllegalAccessError x = new IllegalAccessError();
                        x.initCause(e);
                        throw x;
                    }
                    cmdline.setCancellable(false);
                    cmdline.execute(new LineConsumer.InfoLogger(), new LineConsumer.ErrorLogger()).checkReturnCode();
                }

                @Override
                public void kill(boolean forcibly) throws InterruptedException {
                    proc.destroy();
                }

                @Override
                public List<String> getArguments() {
                    return Collections.emptyList();
                }

                @Override
                public EnvVars getEnvironmentVariables() {
                    return new EnvVars();
                }
            };
        }

        @Override
        public void killAll(Map<String, String> modelEnvVars, boolean forcibly) {
        }
    };
    private static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    public static boolean enabled = true;

    private ProcessTree() {
    }

    public final OSProcess get(int pid) {
        return this.processes.get(pid);
    }

    @Override
    public final Iterator<OSProcess> iterator() {
        return this.processes.values().iterator();
    }

    public abstract OSProcess get(Process var1);

    @Override
    public abstract void killAll(Map<String, String> var1, boolean var2) throws InterruptedException;

    public void killAll(Process proc, Map<String, String> modelEnvVars, boolean forcibly) throws InterruptedException {
        block3: {
            try {
                proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                OSProcess p = this.get(proc);
                if (p == null) break block3;
                p.killRecursively(forcibly);
            }
        }
        if (modelEnvVars != null) {
            this.killAll(modelEnvVars, forcibly);
        }
    }

    public static ProcessTree get() {
        if (!enabled) {
            return DEFAULT;
        }
        try {
            if (File.pathSeparatorChar == ';') {
                return new Windows();
            }
            String os = Util.fixNull(System.getProperty("os.name"));
            if (os.equals("Linux")) {
                return new Linux();
            }
            if (os.equals("SunOS")) {
                return new Solaris();
            }
            if (os.equals("Mac OS X")) {
                return new Darwin();
            }
        }
        catch (LinkageError e) {
            logger.warn("Failed to load winp. Reverting to the default", (Throwable)e);
            enabled = false;
        }
        return DEFAULT;
    }

    private static class Darwin
    extends Unix {
        private final int sizeOf_kinfo_proc;
        private static final int sizeOf_kinfo_proc_32 = 492;
        private static final int sizeOf_kinfo_proc_64 = 648;
        private final int kinfo_proc_pid_offset;
        private static final int kinfo_proc_pid_offset_32 = 24;
        private static final int kinfo_proc_pid_offset_64 = 40;
        private final int kinfo_proc_ppid_offset;
        private static final int kinfo_proc_ppid_offset_32 = 416;
        private static final int kinfo_proc_ppid_offset_64 = 560;
        private static final int sizeOfInt = Native.getNativeSize(Integer.TYPE);
        private static final int CTL_KERN = 1;
        private static final int KERN_PROC = 14;
        private static final int KERN_PROC_ALL = 0;
        private static final int ENOMEM = 12;
        private static int[] MIB_PROC_ALL = new int[]{1, 14, 0};
        private static final int KERN_ARGMAX = 8;
        private static final int KERN_PROCARGS2 = 49;

        Darwin() {
            String arch = System.getProperty("sun.arch.data.model");
            if ("64".equals(arch)) {
                this.sizeOf_kinfo_proc = 648;
                this.kinfo_proc_pid_offset = 40;
                this.kinfo_proc_ppid_offset = 560;
            } else {
                this.sizeOf_kinfo_proc = 492;
                this.kinfo_proc_pid_offset = 24;
                this.kinfo_proc_ppid_offset = 416;
            }
            try {
                Memory m;
                IntByReference size;
                block7: {
                    IntByReference _ = new IntByReference(sizeOfInt);
                    size = new IntByReference(sizeOfInt);
                    int nRetry = 0;
                    do {
                        if (GNUCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, Pointer.NULL, size, Pointer.NULL, _) != 0) {
                            throw new IOException("Failed to obtain memory requirement: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                        }
                        m = new Memory((long)size.getValue());
                        if (GNUCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, (Pointer)m, size, Pointer.NULL, _) == 0) break block7;
                    } while (Native.getLastError() == 12 && nRetry++ < 16);
                    throw new IOException("Failed to call kern.proc.all: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                }
                for (int base = 0; base < size.getValue(); base += this.sizeOf_kinfo_proc) {
                    int pid = m.getInt((long)(base + this.kinfo_proc_pid_offset));
                    int ppid = m.getInt((long)(base + this.kinfo_proc_ppid_offset));
                    this.processes.put(pid, new DarwinProcess(pid, ppid));
                }
            }
            catch (IOException e) {
                logger.warn("Failed to obtain process list", (Throwable)e);
            }
        }

        private class DarwinProcess
        extends UnixProcess {
            private final int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            DarwinProcess(int pid, int ppid) {
                super(pid);
                this.ppid = ppid;
            }

            @Override
            public OSProcess getParent() {
                return Darwin.this.get(this.ppid);
            }

            @Override
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.parse();
                return this.envVars;
            }

            @Override
            public List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.parse();
                return this.arguments;
            }

            private void parse() {
                try {
                    this.arguments = new ArrayList<String>();
                    this.envVars = new EnvVars();
                    IntByReference _ = new IntByReference();
                    IntByReference argmaxRef = new IntByReference(0);
                    IntByReference size = new IntByReference(sizeOfInt);
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, Pointer.NULL, _) != 0) {
                        throw new IOException("Failed to get kernl.argmax: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    int argmax = argmaxRef.getValue();
                    class StringArrayMemory
                    extends Memory {
                        private long offset;

                        StringArrayMemory(long l) {
                            super(l);
                            this.offset = 0L;
                        }

                        int readInt() {
                            int r = this.getInt(this.offset);
                            this.offset += (long)sizeOfInt;
                            return r;
                        }

                        byte peek() {
                            return this.getByte(this.offset);
                        }

                        String readString() {
                            byte ch;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            while ((ch = this.getByte(this.offset++)) != 0) {
                                baos.write(ch);
                            }
                            return baos.toString();
                        }

                        void skip0() {
                            while (this.getByte(this.offset) == 0) {
                                ++this.offset;
                            }
                        }
                    }
                    StringArrayMemory m = new StringArrayMemory(argmax);
                    size.setValue(argmax);
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 49, this.pid}, 3, (Pointer)m, size, Pointer.NULL, _) != 0) {
                        throw new IOException("Failed to obtain ken.procargs2: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    int argc = m.readInt();
                    String args0 = m.readString();
                    m.skip0();
                    try {
                        for (int i = 0; i < argc; ++i) {
                            this.arguments.add(m.readString());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalStateException("Failed to parse arguments: pid=" + this.pid + ", arg0=" + args0 + ", arguments=" + this.arguments + ", nargs=" + argc + ". Please run 'ps e " + this.pid + "' and report this to https://issues.jenkins-ci.org/browse/JENKINS-9634", e);
                    }
                    while (m.peek() != 0) {
                        this.envVars.addLine(m.readString());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static class Solaris
    extends ProcfsUnix {
        Solaris() {
        }

        @Override
        protected OSProcess createProcess(int pid) throws IOException {
            return new SolarisProcess(pid);
        }

        private static long to64(int i) {
            return (long)i & 0xFFFFFFFFL;
        }

        private static int adjust(int i) {
            if (IS_LITTLE_ENDIAN) {
                return i << 24 | i << 8 & 0xFF0000 | i >> 8 & 0xFF00 | i >>> 24;
            }
            return i;
        }

        private class SolarisProcess
        extends UnixProcess {
            private final int ppid;
            private final int envp;
            private final int argp;
            private final int argc;
            private EnvVars envVars;
            private List<String> arguments;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private SolarisProcess(int pid) throws IOException {
                super(pid);
                RandomAccessFile psinfo = new RandomAccessFile(this.getFile("psinfo"), "r");
                try {
                    psinfo.seek(8L);
                    if (Solaris.adjust(psinfo.readInt()) != pid) {
                        throw new IOException("psinfo PID mismatch");
                    }
                    this.ppid = Solaris.adjust(psinfo.readInt());
                    psinfo.seek(188L);
                    this.argc = Solaris.adjust(psinfo.readInt());
                    this.argp = Solaris.adjust(psinfo.readInt());
                    this.envp = Solaris.adjust(psinfo.readInt());
                }
                finally {
                    psinfo.close();
                }
                if (this.ppid == -1) {
                    throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
                }
            }

            @Override
            public OSProcess getParent() {
                return Solaris.this.get(this.ppid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>(this.argc);
                try {
                    RandomAccessFile as = new RandomAccessFile(this.getFile("as"), "r");
                    try {
                        for (int n = 0; n < this.argc; ++n) {
                            as.seek(Solaris.to64(this.argp + n * 4));
                            int p = Solaris.adjust(as.readInt());
                            this.arguments.add(this.readLine(as, p, "argv[" + n + "]"));
                        }
                    }
                    finally {
                        as.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                try {
                    RandomAccessFile as = new RandomAccessFile(this.getFile("as"), "r");
                    try {
                        int n = 0;
                        while (true) {
                            as.seek(Solaris.to64(this.envp + n * 4));
                            int p = Solaris.adjust(as.readInt());
                            if (p == 0) {
                                break;
                            }
                            this.envVars.addLine(this.readLine(as, p, "env[" + n + "]"));
                            ++n;
                        }
                    }
                    finally {
                        as.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.envVars;
            }

            private String readLine(RandomAccessFile as, int p, String prefix) throws IOException {
                int ch;
                as.seek(Solaris.to64(p));
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                while ((ch = as.read()) > 0) {
                    buf.write(ch);
                }
                return buf.toString();
            }
        }
    }

    static class Linux
    extends ProcfsUnix {
        Linux() {
        }

        @Override
        protected LinuxProcess createProcess(int pid) throws IOException {
            return new LinuxProcess(pid);
        }

        class LinuxProcess
        extends UnixProcess {
            private int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            LinuxProcess(int pid) throws IOException {
                super(pid);
                this.ppid = -1;
                BufferedReader r = new BufferedReader(new FileReader(this.getFile("status")));
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("ppid:")) continue;
                        this.ppid = Integer.parseInt(line.substring(5).trim());
                        break;
                    }
                }
                finally {
                    r.close();
                }
                if (this.ppid == -1) {
                    throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
                }
            }

            @Override
            public OSProcess getParent() {
                return Linux.this.get(this.ppid);
            }

            @Override
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>();
                try {
                    byte[] cmdline = FileUtils.readFileToByteArray((File)this.getFile("cmdline"));
                    int pos = 0;
                    for (int i = 0; i < cmdline.length; ++i) {
                        byte b = cmdline[i];
                        if (b != 0) continue;
                        this.arguments.add(new String(cmdline, pos, i - pos));
                        pos = i + 1;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            @Override
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                try {
                    byte[] environ = FileUtils.readFileToByteArray((File)this.getFile("environ"));
                    int pos = 0;
                    for (int i = 0; i < environ.length; ++i) {
                        byte b = environ[i];
                        if (b != 0) continue;
                        this.envVars.addLine(new String(environ, pos, i - pos));
                        pos = i + 1;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.envVars;
            }
        }
    }

    private static final class UnixReflection {
        private static final Field PID_FIELD;
        private static final Method DESTROY_PROCESS;

        private UnixReflection() {
        }

        public static void destroy(int pid) throws IllegalAccessException, InvocationTargetException {
            if (UnixReflection.isPreJava8()) {
                DESTROY_PROCESS.invoke(null, pid);
            } else {
                DESTROY_PROCESS.invoke(null, pid, false);
            }
        }

        private static boolean isPreJava8() {
            int javaVersionAsAnInteger = Integer.parseInt(System.getProperty("java.version").replaceAll("\\.", "").replaceAll("_", "").substring(0, 2));
            return javaVersionAsAnInteger < 18;
        }

        static {
            try {
                Class<?> clazz = Class.forName("java.lang.UNIXProcess");
                PID_FIELD = clazz.getDeclaredField("pid");
                PID_FIELD.setAccessible(true);
                DESTROY_PROCESS = UnixReflection.isPreJava8() ? clazz.getDeclaredMethod("destroyProcess", Integer.TYPE) : clazz.getDeclaredMethod("destroyProcess", Integer.TYPE, Boolean.TYPE);
                DESTROY_PROCESS.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                LinkageError x = new LinkageError();
                x.initCause(e);
                throw x;
            }
            catch (NoSuchFieldException e) {
                LinkageError x = new LinkageError();
                x.initCause(e);
                throw x;
            }
            catch (NoSuchMethodException e) {
                LinkageError x = new LinkageError();
                x.initCause(e);
                throw x;
            }
        }
    }

    public abstract class UnixProcess
    extends OSProcess {
        protected UnixProcess(int pid) {
            super(pid);
        }

        protected final File getFile(String relativePath) {
            return new File(new File("/proc/" + this.getPid()), relativePath);
        }

        @Override
        public void kill(boolean forcibly) throws InterruptedException {
            if (!forcibly) {
                try {
                    int pid = this.getPid();
                    logger.info("Killing process " + pid + "...");
                    UnixReflection.destroy(pid);
                }
                catch (IllegalAccessException e) {
                    IllegalAccessError x = new IllegalAccessError();
                    x.initCause(e);
                    throw x;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof Error) {
                        throw (Error)e.getTargetException();
                    }
                    logger.warn("Failed to terminate pid=" + this.getPid(), (Throwable)e);
                }
            } else {
                int pid = this.getPid();
                logger.info("Calling kill utility to forcibly kill process " + pid + "...");
                Commandline cmdline = new Commandline();
                cmdline.setExecutable("kill");
                cmdline.setCancellable(false);
                cmdline.createArgument().setLine("-9 " + pid);
                cmdline.execute(new LineConsumer.InfoLogger(), new LineConsumer.ErrorLogger()).checkReturnCode();
            }
        }

        @Override
        public void killRecursively(boolean forcibly) throws InterruptedException {
            for (OSProcess p : this.getChildren()) {
                p.killRecursively(forcibly);
            }
            this.kill(forcibly);
        }
    }

    static abstract class ProcfsUnix
    extends Unix {
        ProcfsUnix() {
            File[] processes = new File("/proc").listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            if (processes == null) {
                logger.info("No /proc");
                return;
            }
            for (File p : processes) {
                int pid;
                try {
                    pid = Integer.parseInt(p.getName());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                try {
                    this.processes.put(pid, this.createProcess(pid));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        protected abstract OSProcess createProcess(int var1) throws IOException;
    }

    static abstract class Unix
    extends ProcessTree {
        Unix() {
        }

        @Override
        public OSProcess get(Process proc) {
            try {
                return this.get((Integer)UnixReflection.PID_FIELD.get(proc));
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
        }

        @Override
        public void killAll(Map<String, String> modelEnvVars, boolean forcibly) throws InterruptedException {
            for (OSProcess p : this) {
                if (!p.hasMatchingEnvVars(modelEnvVars)) continue;
                p.killRecursively(forcibly);
            }
        }
    }

    private static final class Windows
    extends ProcessTree {
        Windows() {
            for (final WinProcess p : WinProcess.all()) {
                int pid = p.getPid();
                if (pid == 0 || pid == 4) continue;
                this.processes.put(pid, new OSProcess(pid){
                    private EnvVars env;
                    private List<String> args;

                    @Override
                    public OSProcess getParent() {
                        return null;
                    }

                    @Override
                    public void killRecursively(boolean forcibly) throws InterruptedException {
                        p.killRecursively(forcibly);
                    }

                    @Override
                    public void kill(boolean forcibly) throws InterruptedException {
                        p.kill(forcibly);
                    }

                    @Override
                    public synchronized List<String> getArguments() {
                        if (this.args == null) {
                            this.args = Arrays.asList(QuotedStringTokenizer.tokenize(p.getCommandLine()));
                        }
                        return this.args;
                    }

                    @Override
                    public synchronized EnvVars getEnvironmentVariables() {
                        if (this.env != null) {
                            return this.env;
                        }
                        this.env = new EnvVars();
                        try {
                            this.env.putAll(p.getEnvironmentVariables());
                        }
                        catch (WinpException e) {
                            logger.trace("Failed to get environment variable ", (Throwable)e);
                        }
                        return this.env;
                    }
                });
            }
        }

        @Override
        public OSProcess get(Process proc) {
            return this.get(new WinProcess(proc).getPid());
        }

        @Override
        public void killAll(Map<String, String> modelEnvVars, boolean forcibly) throws InterruptedException {
            for (OSProcess p : this) {
                boolean matched;
                if (p.getPid() < 10) continue;
                try {
                    matched = p.hasMatchingEnvVars(modelEnvVars);
                }
                catch (WinpException e) {
                    logger.trace("Failed to check environment variable match", (Throwable)e);
                    continue;
                }
                if (!matched) continue;
                p.killRecursively(forcibly);
            }
        }

        static {
            WinProcess.enableDebugPrivilege();
        }
    }

    public abstract class OSProcess
    implements ProcessTreeRemoting.IOSProcess {
        final int pid;

        private OSProcess(int pid) {
            this.pid = pid;
        }

        @Override
        public final int getPid() {
            return this.pid;
        }

        @Override
        public abstract OSProcess getParent();

        final ProcessTree getTree() {
            return ProcessTree.this;
        }

        public final List<OSProcess> getChildren() {
            ArrayList<OSProcess> r = new ArrayList<OSProcess>();
            for (OSProcess p : ProcessTree.this) {
                if (p.getParent() != this) continue;
                r.add(p);
            }
            return r;
        }

        @Override
        public abstract void kill(boolean var1) throws InterruptedException;

        @Override
        public abstract void killRecursively(boolean var1) throws InterruptedException;

        @Override
        public abstract List<String> getArguments();

        public abstract EnvVars getEnvironmentVariables();

        public final boolean hasMatchingEnvVars(Map<String, String> modelEnvVar) {
            if (modelEnvVar.isEmpty()) {
                return false;
            }
            EnvVars envs = this.getEnvironmentVariables();
            for (Map.Entry<String, String> e : modelEnvVar.entrySet()) {
                String v = (String)envs.get(e.getKey());
                if (v != null && v.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }
    }
}

