/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.execution;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.Step;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;

public class ProcessStreamPumper {
    private static final int BUFFER_SIZE = 64000;
    private Future<?> stdoutPumper;
    private Future<?> stderrPumper;
    private Future<?> stdinPumper;
    private OutputStream stdoutStream;
    private OutputStream stderrStream;
    private InputStream stdinStream;
    private Process process;

    public ProcessStreamPumper(Process process, OutputStream stdoutStream, OutputStream stderrStream, InputStream stdinStream) {
        this.process = process;
        this.stdoutStream = stdoutStream;
        this.stderrStream = stderrStream;
        this.stdinStream = stdinStream;
    }

    public void start() {
        this.stdoutPumper = this.createPump(this.process.getInputStream(), this.stdoutStream, false);
        this.stderrPumper = this.createPump(this.process.getErrorStream(), this.stderrStream, false);
        if (this.stdinStream != null) {
            this.stdinPumper = this.createPump(this.stdinStream, this.process.getOutputStream(), true);
        }
    }

    public boolean closed() {
        if (!this.stdoutPumper.isDone() || !this.stderrPumper.isDone() || this.stdinPumper != null && !this.stdinPumper.isDone()) {
            return false;
        }
        try {
            if (this.stderrStream != null) {
                this.stderrStream.flush();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.stdoutStream != null) {
                this.stdoutStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private Future<?> createPump(final InputStream input, final OutputStream output, final boolean closeWhenExhausted) {
        final Build originalBuild = Context.get();
        final Step originalStep = Context.getStep();
        return Quickbuild.getInstance().getExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (originalBuild != null) {
                    Context.push(originalBuild);
                }
                if (originalStep != null) {
                    Context.pushStep(originalStep);
                }
                byte[] buf = new byte[64000];
                try {
                    int length;
                    while ((length = input.read(buf)) > 0) {
                        if (output == null) continue;
                        output.write(buf, 0, length);
                    }
                }
                catch (Exception e) {
                    Context.getLogger().error("Error pumping stream.", (Throwable)e);
                    ProcessStreamPumper.this.process.destroy();
                }
                finally {
                    if (originalBuild != null) {
                        Context.pop();
                    }
                    if (originalStep != null) {
                        Context.popStep();
                    }
                    if (closeWhenExhausted && output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }
}

