/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.execution;

import com.pmease.quickbuild.Context;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class LineConsumer
extends OutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean skip = false;
    private String encoding;

    public LineConsumer(String encoding) {
        this.encoding = encoding;
    }

    public LineConsumer() {
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    protected void processBuffer() {
        try {
            this.consume(this.encoding != null ? this.buffer.toString(this.encoding) : this.buffer.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.buffer.reset();
        }
    }

    public abstract void consume(String var1);

    @Override
    public void flush() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public static class NoOp
    extends LineConsumer {
        @Override
        public void consume(String line) {
        }
    }

    public static class ErrorLogger
    extends LineConsumer {
        public ErrorLogger(String encoding) {
            super(encoding);
        }

        public ErrorLogger() {
        }

        @Override
        public void consume(String line) {
            Context.getLogger().error(line);
        }
    }

    public static class WarnLogger
    extends LineConsumer {
        public WarnLogger(String encoding) {
            super(encoding);
        }

        public WarnLogger() {
        }

        @Override
        public void consume(String line) {
            Context.getLogger().warn(line);
        }
    }

    public static class TraceLogger
    extends LineConsumer {
        public TraceLogger(String encoding) {
            super(encoding);
        }

        public TraceLogger() {
        }

        @Override
        public void consume(String line) {
            Context.getLogger().trace(line);
        }
    }

    public static class DebugLogger
    extends LineConsumer {
        public DebugLogger(String encoding) {
            super(encoding);
        }

        public DebugLogger() {
        }

        @Override
        public void consume(String line) {
            Context.getLogger().debug(line);
        }
    }

    public static class InfoLogger
    extends LineConsumer {
        public InfoLogger(String encoding) {
            super(encoding);
        }

        public InfoLogger() {
        }

        @Override
        public void consume(String line) {
            Context.getLogger().info(line);
        }
    }
}

