/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.execution;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.ProcessStreamPumper;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.execution.killtree.ProcessTree;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.tools.ant.types.Environment;

public class Commandline {
    private static final int MAX_COMMAND_LENGTH = 1024;
    private static final String SESSION_ENV_NAME = "QB_COMMAND_EXECUTOR_SESSION";
    private List<Argument> arguments = new ArrayList<Argument>();
    private String executable = null;
    private SecretMasker masker;
    private String description;
    private File deleteAfterExecution;
    private boolean cancellable = true;

    public Commandline(String command, SecretMasker masker) {
        String[] parts;
        if (command != null && (parts = StringUtils.parseQuoteTokens(command)) != null && parts.length > 0) {
            this.setExecutable(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                this.addArgValue(parts[i]);
            }
        }
        this.masker = masker;
    }

    public Commandline(String command) {
        this(command, null);
    }

    public Commandline(SecretMasker masker) {
        this(null, masker);
    }

    public Commandline() {
        this(null, null);
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Commandline addArgValue(String argValue) {
        this.createArgument().setValue(argValue);
        return this;
    }

    public Commandline addArgLine(String argLine) {
        this.createArgument().setLine(argLine);
        return this;
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.add(0, argument);
        } else {
            this.arguments.add(argument);
        }
        return argument;
    }

    public void setSecretMasker(SecretMasker masker) {
        this.masker = masker;
    }

    public Commandline setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return this;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return this;
    }

    public String getExecutable() {
        return this.executable;
    }

    public Commandline addArguments(String[] argumentValues) {
        for (int i = 0; i < argumentValues.length; ++i) {
            this.createArgument().setValue(argumentValues[i]);
        }
        return this;
    }

    public String[] getCommandParts() {
        LinkedList<String> parts = new LinkedList<String>();
        if (this.executable != null) {
            parts.add(this.executable);
        }
        parts.addAll(Arrays.asList(this.getArgumentParts()));
        return parts.toArray(new String[parts.size()]);
    }

    public boolean willOverflow(String argValue) {
        int length = 0;
        if (this.executable != null) {
            length = this.executable.length() + 1;
            if (this.executable.indexOf(32) != -1 || this.executable.indexOf(9) != -1) {
                length += 2;
            }
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = this.arguments.get(i);
            String[] s = arg.getParts();
            if (s == null) continue;
            for (int j = 0; j < s.length; ++j) {
                length += s[j].length() + 1;
                if (s[j].indexOf(32) == -1 && s[j].indexOf(9) == -1) continue;
                length += 2;
            }
        }
        length += argValue.length();
        if (argValue.indexOf(32) != -1 || argValue.indexOf(9) != -1) {
            length += 2;
        }
        return length > 1024;
    }

    public String[] getArgumentParts() {
        ArrayList<String> parts = new ArrayList<String>(this.arguments.size() * 2);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = this.arguments.get(i);
            String[] s = arg.getParts();
            if (s == null) continue;
            for (int j = 0; j < s.length; ++j) {
                parts.add(s[j]);
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    public String toString() {
        return this.describe();
    }

    public Commandline clear() {
        this.executable = null;
        this.arguments.clear();
        return this;
    }

    public Commandline clearArgs() {
        this.arguments.clear();
        return this;
    }

    public String describe() {
        StringBuffer buf = new StringBuffer();
        if (this.getDescription() == null) {
            String[] args = this.getCommandParts();
            if (args == null || args.length == 0) {
                return "";
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].contains(" ") || args[i].contains("\t")) {
                    buf.append("\"").append(StringUtils.replace((String)args[i], (String)"\n", (String)"\\n")).append("\"").append(" ");
                    continue;
                }
                buf.append(StringUtils.replace((String)args[i], (String)"\n", (String)"\\n")).append(" ");
            }
        } else if (this.getDescription().trim().contains("\n")) {
            buf.append("\n" + this.getDescription());
        } else {
            buf.append(this.getDescription());
        }
        String result = this.masker != null ? this.masker.mask(buf.toString()) : buf.toString();
        if (Context.get() != null) {
            result = Context.get().obfuscateSecrets(result);
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExecuteResult execute(File workingDir, Environment execEnv, OutputStream stdoutConsumer, LineConsumer stderrConsumer) {
        return this.execute(workingDir, execEnv, stdoutConsumer, stderrConsumer, null);
    }

    public ExecuteResult execute(File workingDir, OutputStream stdoutConsumer, LineConsumer stderrConsumer) {
        return this.execute(workingDir, null, stdoutConsumer, stderrConsumer, null);
    }

    public ExecuteResult execute(OutputStream stdoutConsumer, LineConsumer stderrConsumer) {
        return this.execute(null, null, stdoutConsumer, stderrConsumer, null);
    }

    public ExecuteResult execute(Environment execEnv, OutputStream stdoutConsumer, LineConsumer stderrConsumer) {
        return this.execute(null, execEnv, stdoutConsumer, stderrConsumer, null);
    }

    public ExecuteResult execute(OutputStream stdoutConsumer, LineConsumer stderrConsumer, String stdinString) {
        return this.execute(null, null, stdoutConsumer, stderrConsumer, stdinString);
    }

    public ExecuteResult execute(Environment execEnv, OutputStream stdoutConsumer, LineConsumer stderrConsumer, String stdinString) {
        return this.execute(null, execEnv, stdoutConsumer, stderrConsumer, stdinString);
    }

    public File getDeleteAfterExecution() {
        return this.deleteAfterExecution;
    }

    public void setDeleteAfterExecution(File deleteAfterExecution) {
        this.deleteAfterExecution = deleteAfterExecution;
    }

    public void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private ProcessBuilder getProcessBuilder(File workingDir, Environment execEnv) {
        String[] cmdParts;
        if (workingDir == null) {
            workingDir = new File(Bootstrap.installDir, "bin");
        }
        if (!new File((cmdParts = this.getCommandParts())[0]).isAbsolute()) {
            if (new File(workingDir, cmdParts[0]).isFile()) {
                cmdParts[0] = new File(workingDir, cmdParts[0]).getAbsolutePath();
            } else if (new File(workingDir, cmdParts[0] + ".exe").isFile()) {
                cmdParts[0] = new File(workingDir, cmdParts[0] + ".exe").getAbsolutePath();
            } else if (new File(workingDir, cmdParts[0] + ".bat").isFile()) {
                cmdParts[0] = new File(workingDir, cmdParts[0] + ".bat").getAbsolutePath();
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmdParts);
        processBuilder.directory(workingDir);
        if (execEnv != null) {
            Map<String, String> procEnv = processBuilder.environment();
            for (Environment.Variable variable : execEnv.getVariablesVector()) {
                if (variable.getKey() == null || variable.getValue() == null) continue;
                procEnv.put(variable.getKey(), variable.getValue());
            }
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Executing command: " + this.describe());
            Context.getLogger().debug("Command working directory: " + processBuilder.directory().getAbsolutePath());
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry entry : processBuilder.environment().entrySet()) {
                buffer.append("\t" + (String)entry.getKey() + "=" + (String)entry.getValue() + "\n");
            }
            Context.getLogger().trace("Command execution environments:\n" + StringUtils.stripEnd((String)buffer.toString(), (String)"\n"));
        }
        return processBuilder;
    }

    public ExecuteResult execute(File workingDir, Environment execEnv, OutputStream stdoutConsumer, final LineConsumer stderrConsumer, String stdinString) {
        Process process;
        String session = UUID.randomUUID().toString();
        try {
            ProcessBuilder processBuilder = this.getProcessBuilder(workingDir, execEnv);
            processBuilder.environment().put(SESSION_ENV_NAME, session);
            process = processBuilder.redirectErrorStream(stderrConsumer == null).start();
        }
        catch (IOException e) {
            if (this.getDeleteAfterExecution() != null && this.getDeleteAfterExecution().exists()) {
                FileUtils.deleteFile(this.getDeleteAfterExecution());
            }
            String message = e.getMessage();
            if (this.masker != null) {
                message = this.masker.mask(message);
            }
            if (Context.get() != null) {
                message = Context.get().obfuscateSecrets(message);
            }
            throw new QuickbuildException(message);
        }
        ByteArrayInputStream inputStream = null;
        if (stdinString != null && stdinString.length() != 0) {
            inputStream = new ByteArrayInputStream(stdinString.getBytes());
        }
        final StringBuffer errorMessage = new StringBuffer();
        LineConsumer errorMessageCollector = null;
        if (stderrConsumer != null) {
            errorMessageCollector = new LineConsumer(stderrConsumer.getEncoding()){

                @Override
                public void consume(String line) {
                    if (errorMessage.length() != 0) {
                        errorMessage.append("\n");
                    }
                    errorMessage.append(line);
                    if (Commandline.this.masker != null) {
                        stderrConsumer.consume(Commandline.this.masker.mask(line));
                    } else {
                        stderrConsumer.consume(line);
                    }
                }
            };
        }
        ProcessStreamPumper streamPumper = new ProcessStreamPumper(process, stdoutConsumer, errorMessageCollector, inputStream);
        streamPumper.start();
        ExecuteResult result = new ExecuteResult();
        if (this.cancellable) {
            InterruptedException interruptedException = null;
            try {
                result.setReturnCode(process.waitFor());
            }
            catch (InterruptedException e) {
                interruptedException = e;
                Context.getLogger().info("Terminating launched command gracefully...");
                this.terminateProcessTree(process, session, false);
            }
            long lastTime = System.currentTimeMillis();
            while (!streamPumper.closed()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    if (System.currentTimeMillis() - lastTime <= 5000L) continue;
                    Context.getLogger().info("Unable to terminate launched command gracefully, terminating forcibly instead...");
                    this.terminateProcessTree(process, session, true);
                    lastTime = System.currentTimeMillis();
                }
            }
            if (this.getDeleteAfterExecution() != null && this.getDeleteAfterExecution().exists()) {
                FileUtils.deleteFile(this.getDeleteAfterExecution());
            }
            if (interruptedException != null) {
                throw new RuntimeException(interruptedException);
            }
        } else {
            while (true) {
                try {
                    result.setReturnCode(process.waitFor());
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            while (!streamPumper.closed()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            if (this.getDeleteAfterExecution() != null && this.getDeleteAfterExecution().exists()) {
                FileUtils.deleteFile(this.getDeleteAfterExecution());
            }
        }
        if (errorMessage.length() != 0) {
            if (Context.get() != null) {
                result.setErrorMessage(Context.get().obfuscateSecrets(errorMessage.toString()));
            } else {
                result.setErrorMessage(errorMessage.toString());
            }
        }
        return result;
    }

    private void terminateProcessTree(Process process, String session, boolean forcibly) {
        try {
            HashMap<String, String> sessionVar = new HashMap<String, String>();
            sessionVar.put(SESSION_ENV_NAME, session);
            ProcessTree.get().killAll(process, sessionVar, forcibly);
        }
        catch (Exception e) {
            Context.getLogger().error("Error terminating process tree.", (Throwable)e);
        }
    }

    public void executeWithoutWait() {
        this.executeWithoutWait(null, null);
    }

    public void executeWithoutWait(File workingDir) {
        this.executeWithoutWait(workingDir, null);
    }

    public void executeWithoutWait(File workingDir, Environment execEnv) {
        this.executeWithoutWait(workingDir, execEnv, null);
    }

    public void executeWithoutWait(Environment execEnv) {
        this.executeWithoutWait(null, execEnv);
    }

    public void executeWithoutWait(File workingDir, Environment execEnv, String stdinString) {
        Process process;
        ByteArrayInputStream stdinStream = null;
        if (stdinString != null && stdinString.length() != 0) {
            stdinStream = new ByteArrayInputStream(stdinString.getBytes());
        }
        try {
            process = this.getProcessBuilder(workingDir, execEnv).start();
            new ProcessStreamPumper(process, null, null, stdinStream).start();
        }
        catch (IOException e) {
            if (this.getDeleteAfterExecution() != null && this.getDeleteAfterExecution().exists()) {
                FileUtils.deleteFile(this.getDeleteAfterExecution());
            }
            throw new RuntimeException(e);
        }
        Quickbuild.getInstance().getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Commandline.this.getDeleteAfterExecution() != null && Commandline.this.getDeleteAfterExecution().exists()) {
                    FileUtils.deleteFile(Commandline.this.getDeleteAfterExecution());
                }
            }
        });
    }

    public static class Argument {
        private String[] parts;

        public void setValue(String value) {
            this.parts = new String[]{value};
        }

        public void setLine(String line) {
            this.parts = StringUtils.parseQuoteTokens(line);
        }

        public String[] getParts() {
            return this.parts;
        }
    }

    public class ExecuteResult {
        private int returnCode;
        private String errorMessage;

        public int getReturnCode() {
            return this.returnCode;
        }

        public void setReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = Commandline.this.masker != null ? Commandline.this.masker.mask(errorMessage) : errorMessage;
        }

        public QuickbuildException buildException() {
            if (this.errorMessage != null) {
                throw new QuickbuildException("Failed to run command: " + Commandline.this.describe() + "\nCommand return code: " + this.getReturnCode() + "\nCommand error output: " + this.errorMessage);
            }
            throw new QuickbuildException("Failed to run command: " + Commandline.this.describe() + "\nCommand return code: " + this.getReturnCode());
        }

        public void checkReturnCode() {
            if (this.getReturnCode() != 0) {
                throw this.buildException();
            }
        }
    }
}

