/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.UserShareManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.Synchronization;
import org.hibernate.Query;

@Singleton
public class DefaultUserShareManager
extends AbstractEntityManager<UserShare>
implements UserShareManager {
    @Override
    @SessionAware(transactional=true)
    public void delete(final UserShare share) {
        super.delete(share);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.userShareRemoved(share.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final UserShare share) {
        super.save(share);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.userShareSaved(share);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void share(Dashboard dashboard, Collection<User> users) {
        boolean found;
        Iterator<UserShare> it = dashboard.getUserShares().iterator();
        while (it.hasNext()) {
            UserShare share = it.next();
            if (share.getId() == null) {
                it.remove();
                continue;
            }
            found = false;
            for (User user : users) {
                if (!user.getId().equals(share.getUser().getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
            this.delete(share);
        }
        for (User user : users) {
            found = false;
            for (UserShare share : dashboard.getUserShares()) {
                if (!share.getUser().getId().equals(user.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            UserShare share = new UserShare();
            share.setUser(user);
            share.setDashboard(dashboard);
            dashboard.getUserShares().add(share);
            this.save(share);
        }
    }

    @Override
    @SessionAware(transactional=true)
    public void unshare(Dashboard dashboard, User user) {
        Query query = this.getSession().createQuery("from UserShare where user=:user and dashboard=:dashboard");
        query.setParameter("user", (Object)user);
        query.setParameter("dashboard", (Object)dashboard);
        UserShare share = (UserShare)query.uniqueResult();
        if (share != null) {
            this.delete(share);
        }
    }
}

