/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.DashboardManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.entitymanager.UserShareManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.List;
import javax.transaction.Synchronization;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultUserManager
extends AbstractEntityManager<User>
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUserManager.class);
    @Inject
    private MembershipManager membershipManager;
    @Inject
    private DashboardManager dashboardManager;
    @Inject
    private UserShareManager shareManager;

    @Override
    @SessionAware(transactional=true)
    public void save(final User user) {
        super.save(user);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.userSaved(user);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public User get(String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from User user where user.name=:name");
        query.setParameter("name", (Object)name);
        query.setCacheable(true);
        return (User)query.uniqueResult();
    }

    @Override
    @SessionAware
    public User getByFullName(String fullName) {
        Session session = this.getSession();
        Query query = session.createQuery("from User user where user.fullName=:fullName");
        query.setParameter("fullName", (Object)fullName);
        List users = query.list();
        if (users.size() > 1) {
            logger.warn("The full name '{}' is used by more than one users.", (Object)fullName);
            return (User)users.get(0);
        }
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final User user) {
        if (user.isRoot()) {
            throw new QuickbuildException("Can not delete root user.");
        }
        Session session = this.getSession();
        session.buildLockRequest(LockOptions.NONE).lock((Object)user);
        Query query = session.createQuery("update Build set requester=null where requester=:requester");
        query.setParameter("requester", (Object)user);
        query.executeUpdate();
        query = session.createQuery("update Build set canceller=null where canceller=:canceller");
        query.setParameter("canceller", (Object)user);
        query.executeUpdate();
        for (Dashboard dashboard : user.getDashboards()) {
            this.dashboardManager.delete(dashboard);
        }
        for (UserShare share : user.getShares()) {
            this.shareManager.delete(share);
        }
        for (Membership membership : user.getMemberships()) {
            this.membershipManager.delete(membership);
        }
        session.delete((Object)user);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.userRemoved(user.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    public User copyAsNew(User user) {
        User newUser = (User)BeanUtils.clone(user);
        newUser.setId(null);
        for (Membership membership : user.getMemberships()) {
            Membership newMembership = new Membership();
            newMembership.setGroup(membership.getGroup());
            newMembership.setUser(newUser);
            newUser.getMemberships().add(newMembership);
        }
        return newUser;
    }
}

