/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.TriggerDependenceManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.TriggerDependence;
import java.util.List;
import javax.transaction.Synchronization;
import org.hibernate.Query;
import org.hibernate.Session;

@Singleton
public class DefaultTriggerDependenceManager
extends AbstractEntityManager<TriggerDependence>
implements TriggerDependenceManager {
    @Inject
    private CacheManager cacheManager;

    @Override
    @SessionAware(transactional=true)
    public void delete(final TriggerDependence dependence) {
        super.delete(dependence);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultTriggerDependenceManager.this.cacheManager.triggerDependenceRemoved(dependence.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final TriggerDependence dependence) {
        super.save(dependence);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultTriggerDependenceManager.this.cacheManager.triggerDependenceSaved(dependence);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public List<TriggerDependence> getDependencies(Configuration configuration) {
        Session session = this.getSession();
        Query query = session.createQuery("from TriggerDependence where dependent=:dependent");
        query.setParameter("dependent", (Object)configuration);
        return query.list();
    }

    @Override
    @SessionAware
    public List<TriggerDependence> getDependents(Configuration configuration) {
        Session session = this.getSession();
        Query query = session.createQuery("from TriggerDependence where dependency=:dependency");
        query.setParameter("dependency", (Object)configuration);
        return query.list();
    }
}

