/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Token;
import javax.transaction.Synchronization;
import org.hibernate.Query;
import org.hibernate.Session;

@Singleton
public class DefaultTokenManager
extends AbstractEntityManager<Token>
implements TokenManager {
    @Override
    @SessionAware(transactional=true)
    public void save(final Token token) {
        super.save(token);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.tokenSaved(token);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public Token getByValue(String tokenValue) {
        Session session = this.getSession();
        Query query = session.createQuery("from Token where value=:value");
        query.setParameter("value", (Object)tokenValue);
        query.setCacheable(true);
        return (Token)query.uniqueResult();
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final Token token) {
        super.delete(token);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.tokenRemoved(token.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(Long tokenId) {
        Token token = (Token)this.get(tokenId);
        if (token != null) {
            this.delete(token);
        }
    }
}

