/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.license.License;
import com.pmease.quickbuild.model.Setting;
import com.pmease.quickbuild.setting.system.AlertRetentionSetting;
import com.pmease.quickbuild.setting.system.AutoBackupSetting;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.setting.system.SecuritySetting;
import com.pmease.quickbuild.setting.system.SystemSetting;
import java.io.Serializable;
import javax.transaction.Synchronization;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;

@Singleton
public class DefaultSettingManager
extends AbstractEntityManager<Setting>
implements SettingManager {
    @Inject
    private ScriptEngine scriptEngine;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private BuildEngine buildEngine;

    @Override
    @SessionAware
    public int getDataVersion() {
        return (Integer)((Setting)this.load(Setting.DATA_VERSION_ID)).getObject();
    }

    @Override
    @SessionAware
    public SystemSetting getSystemSettingDef() {
        return (SystemSetting)((Setting)this.load(Setting.SYSTEM_SETTING_ID)).getObject();
    }

    @Override
    public SystemSetting getSystemSetting() {
        SystemSetting systemSetting = this.getSystemSettingDef();
        return (SystemSetting)this.scriptEngine.installInterpolator(systemSetting);
    }

    @Override
    @SessionAware(transactional=true)
    public void saveSystemSetting(final SystemSetting systemSetting) {
        Session session = this.getSession();
        Setting setting = (Setting)this.get(Setting.SYSTEM_SETTING_ID);
        if (setting == null) {
            setting = new Setting();
            setting.setId(Setting.SYSTEM_SETTING_ID);
        }
        setting.setObject(systemSetting);
        session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultSettingManager.this.cacheManager.systemSettingSaved((SystemSetting)DefaultSettingManager.this.scriptEngine.installInterpolator(systemSetting));
                    DefaultSettingManager.this.buildEngine.processImmediately();
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public EmailSetting getEmailSettingDef() {
        return (EmailSetting)((Setting)this.load(Setting.EMAIL_SETTING_ID)).getObject();
    }

    @Override
    public EmailSetting getEmailSetting() {
        EmailSetting emailSetting = this.getEmailSettingDef();
        if (emailSetting != null) {
            return (EmailSetting)this.scriptEngine.installInterpolator(emailSetting);
        }
        return null;
    }

    @Override
    @SessionAware(transactional=true)
    public void saveEmailSetting(final EmailSetting emailSetting) {
        Session session = this.getSession();
        Setting setting = (Setting)this.get(Setting.EMAIL_SETTING_ID);
        if (setting == null) {
            setting = new Setting();
            setting.setId(Setting.EMAIL_SETTING_ID);
        }
        setting.setObject(emailSetting);
        session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultSettingManager.this.cacheManager.emailSettingSaved((EmailSetting)DefaultSettingManager.this.scriptEngine.installInterpolator(emailSetting));
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public String getLicenseKey() {
        return (String)((Object)((Setting)this.load(Setting.LICENSE_KEY_ID)).getObject());
    }

    @Override
    @SessionAware(transactional=true)
    public void saveLicenseKey(final String licenseKey) {
        Session session = this.getSession();
        Setting setting = (Setting)this.get(Setting.LICENSE_KEY_ID);
        if (setting == null) {
            setting = new Setting();
            setting.setId(Setting.LICENSE_KEY_ID);
        }
        setting.setObject((Serializable)((Object)licenseKey));
        session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultSettingManager.this.cacheManager.licenseSaved(License.fromKey(licenseKey));
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public SecuritySetting getSecuritySettingDef() {
        return (SecuritySetting)((Setting)this.load(Setting.SECURITY_SETTING_ID)).getObject();
    }

    @Override
    public SecuritySetting getSecuritySetting() {
        SecuritySetting securitySetting = this.getSecuritySettingDef();
        return (SecuritySetting)this.scriptEngine.installInterpolator(securitySetting);
    }

    @Override
    @SessionAware(transactional=true)
    public void saveSecuritySetting(SecuritySetting securitySetting) {
        Session session = this.getSession();
        Setting setting = (Setting)this.get(Setting.SECURITY_SETTING_ID);
        if (setting == null) {
            setting = new Setting();
            setting.setId(Setting.SECURITY_SETTING_ID);
        }
        setting.setObject(securitySetting);
        session.replicate((Object)setting, ReplicationMode.OVERWRITE);
    }

    @Override
    @SessionAware
    public AutoBackupSetting getAutoBackupSettingDef() {
        return (AutoBackupSetting)((Setting)this.load(Setting.AUTOBACKUP_SETTING_ID)).getObject();
    }

    @Override
    public AutoBackupSetting getAutoBackupSetting() {
        AutoBackupSetting autoBackupSetting = this.getAutoBackupSettingDef();
        if (autoBackupSetting != null) {
            return (AutoBackupSetting)this.scriptEngine.installInterpolator(autoBackupSetting);
        }
        return null;
    }

    @Override
    @SessionAware(transactional=true)
    public void saveAutoBackupSetting(AutoBackupSetting autoBackupSetting) {
        Session session = this.getSession();
        Setting setting = (Setting)this.get(Setting.AUTOBACKUP_SETTING_ID);
        if (setting == null) {
            setting = new Setting();
            setting.setId(Setting.AUTOBACKUP_SETTING_ID);
        }
        setting.setObject(autoBackupSetting);
        session.replicate((Object)setting, ReplicationMode.OVERWRITE);
    }

    @Override
    public AlertRetentionSetting getAlertRetentionSetting() {
        return (AlertRetentionSetting)((Setting)this.load(Setting.ALERT_SETTING_ID)).getObject();
    }

    @Override
    @SessionAware(transactional=true)
    public void saveAlertRetentionSetting(final AlertRetentionSetting alertSetting) {
        Session session = this.getSession();
        Setting setting = (Setting)this.get(Setting.ALERT_SETTING_ID);
        if (setting == null) {
            setting = new Setting();
            setting.setId(Setting.ALERT_SETTING_ID);
        }
        setting.setObject(alertSetting);
        session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultSettingManager.this.cacheManager.alertSettingSaved(alertSetting);
                }
            }

            public void beforeCompletion() {
            }
        });
    }
}

