/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.ResourceAccessManager;
import com.pmease.quickbuild.entitymanager.ResourceManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Resource;
import javax.transaction.Synchronization;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultResourceManager
extends AbstractEntityManager<Resource>
implements ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResourceManager.class);

    @Override
    @SessionAware
    public Resource get(String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from Resource where name=:name");
        query.setParameter("name", (Object)name);
        query.setCacheable(true);
        return (Resource)query.uniqueResult();
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final Resource resource) {
        super.delete(resource);
        for (Configuration conf : ConfigurationManager.instance.getAll()) {
            boolean changed = false;
            for (VersionedDocument dom : conf.getStepDOMs().values()) {
                for (Node node : dom.selectNodes("//*[@class='com.pmease.quickbuild.setting.step.nodematcher.HasResourceMatcher']")) {
                    Element element = (Element)node;
                    Element resourceElement = element.element("resource");
                    if (!resourceElement.getTextTrim().equals(resource.getName())) continue;
                    element.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.AnyNodeMatcher");
                    element.clearContent();
                    changed = true;
                }
            }
            if (!changed) continue;
            logger.debug("Removing resource reference in configuration: " + conf);
            ConfigurationManager.instance.save(conf);
        }
        ResourceAccessManager.instance.deleteBy(resource);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.resourceRemoved(resource.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Resource resource, String previousName) {
        super.save(resource);
        if (previousName != null && !previousName.equals(resource.getName())) {
            for (Configuration conf : ConfigurationManager.instance.getAll()) {
                boolean changed = false;
                for (VersionedDocument dom : conf.getStepDOMs().values()) {
                    for (Node node : dom.selectNodes("//*[@class='com.pmease.quickbuild.setting.step.nodematcher.HasResourceMatcher']")) {
                        Element element = (Element)node;
                        Element resourceElement = element.element("resource");
                        if (!resourceElement.getTextTrim().equals(previousName)) continue;
                        resourceElement.setText(resource.getName());
                        changed = true;
                    }
                }
                if (!changed) continue;
                logger.debug("Updating resource reference in configuration: " + conf);
                ConfigurationManager.instance.save(conf);
            }
        }
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.resourceSaved(resource);
                }
            }

            public void beforeCompletion() {
            }
        });
    }
}

