/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.ResourceAccessManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.model.ResourceAccess;
import javax.transaction.Synchronization;
import org.hibernate.Query;

@Singleton
public class DefaultResourceAccessManager
extends AbstractEntityManager<ResourceAccess>
implements ResourceAccessManager {
    @Override
    @SessionAware(transactional=true)
    public void deleteBy(Configuration configuration) {
        Query query = this.getSession().createQuery("delete from ResourceAccess where configuration.id=:configurationId");
        query.setParameter("configurationId", (Object)configuration.getId());
        query.executeUpdate();
    }

    @Override
    @SessionAware(transactional=true)
    public void deleteBy(Resource resource) {
        Query query = this.getSession().createQuery("delete from ResourceAccess where resource.id=:resourceId");
        query.setParameter("resourceId", (Object)resource.getId());
        query.executeUpdate();
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final ResourceAccess resourceUsage) {
        super.save(resourceUsage);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.resourceUsageSaved(resourceUsage);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void saveOrUpdate(ResourceAccess resourceAccess) {
        Query query = this.getSession().createQuery("from ResourceAccess where configuration.id=:configurationId and resource.id=:resourceId");
        query.setParameter("configurationId", (Object)resourceAccess.getConfiguration().getId());
        query.setParameter("resourceId", (Object)resourceAccess.getResource().getId());
        ResourceAccess resourceAccessInDB = (ResourceAccess)query.uniqueResult();
        if (resourceAccessInDB != null) {
            resourceAccessInDB.setDuration(resourceAccess.getDuration());
            resourceAccessInDB.setWhen(resourceAccess.getWhen());
            resourceAccessInDB.setSteps(resourceAccess.getSteps());
            this.save(resourceAccessInDB);
        } else {
            this.save(resourceAccess);
        }
    }
}

