/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.PromoteOptionManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.PromoteOption;
import com.pmease.quickbuild.model.User;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

@Singleton
public class DefaultPromoteOptionManager
extends AbstractEntityManager<PromoteOption>
implements PromoteOptionManager {
    @Override
    @SessionAware
    public PromoteOption get(User user, Configuration configuration, String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from PromoteOption where user=:user and configuration=:configuration and name=:name");
        query.setParameter("user", (Object)user);
        query.setParameter("configuration", (Object)configuration);
        query.setParameter("name", (Object)name);
        return (PromoteOption)query.uniqueResult();
    }

    @Override
    @SessionAware
    public PromoteOption getActive(User user, Configuration configuration) {
        Session session = this.getSession();
        Query query = session.createQuery("from PromoteOption where user=:user and configuration=:configuration and active=true");
        query.setParameter("user", (Object)user);
        query.setParameter("configuration", (Object)configuration);
        List result = query.list();
        if (!result.isEmpty()) {
            return (PromoteOption)result.get(0);
        }
        return null;
    }

    @Override
    @SessionAware(transactional=true)
    public void setActive(User user, Configuration configuration, String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from PromoteOption where user=:user and configuration=:configuration");
        query.setParameter("user", (Object)user);
        query.setParameter("configuration", (Object)configuration);
        PromoteOption option = null;
        for (PromoteOption each : query.list()) {
            if (each.getName().equals(name)) {
                option = each;
                if (option.isActive()) continue;
                option.setActive(true);
                this.save(option);
                continue;
            }
            if (!each.isActive()) continue;
            each.setActive(false);
            this.save(each);
        }
        if (option == null) {
            option = new PromoteOption();
            option.setActive(true);
            option.setName(name);
            option.setConfiguration(configuration);
            option.setUser(user);
            this.save(option);
        }
    }
}

