/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.AuthorizationManager;
import com.pmease.quickbuild.entitymanager.PermissionSetManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.hibernate.Query;
import org.hibernate.Session;

@Singleton
public class DefaultPermissionSetManager
extends AbstractEntityManager<PermissionSet>
implements PermissionSetManager {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private AuthorizationManager authorizationManager;

    @Override
    @SessionAware
    public PermissionSet get(String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from PermissionSet where name=:name");
        query.setParameter("name", (Object)name);
        query.setCacheable(true);
        return (PermissionSet)query.uniqueResult();
    }

    @Override
    public List<String> getPermissionSetNames() {
        ArrayList<String> permissionSetNames = new ArrayList<String>();
        for (PermissionSet permissionSet : this.getAll(null)) {
            permissionSetNames.add(permissionSet.getName());
        }
        return permissionSetNames;
    }

    @Override
    public PermissionSet copyAsNew(PermissionSet permissionSet) {
        PermissionSet newPermissionSet = (PermissionSet)BeanUtils.clone(permissionSet);
        newPermissionSet.setId(null);
        return newPermissionSet;
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final PermissionSet permissionSet) {
        String permissionSetId = permissionSet.getId().toString();
        for (Authorization authorization : this.authorizationManager.getAll()) {
            if (!authorization.getPermissions().contains(permissionSetId)) continue;
            authorization.getPermissions().remove(permissionSetId);
            this.authorizationManager.save(authorization);
        }
        this.getSession().delete((Object)permissionSet);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultPermissionSetManager.this.cacheManager.permissionSetRemoved(permissionSet.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final PermissionSet permissionSet) {
        super.save(permissionSet);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultPermissionSetManager.this.cacheManager.permissionSetSaved(permissionSet);
                }
            }

            public void beforeCompletion() {
            }
        });
    }
}

