/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMembershipManager
extends AbstractEntityManager<Membership>
implements MembershipManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMembershipManager.class);
    @Inject
    private CacheManager cacheManager;

    @Override
    @SessionAware(transactional=true)
    public void delete(final Membership membership) {
        super.delete(membership);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultMembershipManager.this.cacheManager.membershipRemoved(membership.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Membership membership) {
        super.save(membership);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultMembershipManager.this.cacheManager.membershipSaved(membership);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void assign(User user, Collection<Group> groups, boolean locally) {
        boolean found;
        Iterator<Membership> it = user.getMemberships().iterator();
        while (it.hasNext()) {
            Membership membership = it.next();
            if (membership.getId() == null) {
                it.remove();
                continue;
            }
            found = false;
            for (Group group : groups) {
                if (!group.getId().equals(membership.getGroup().getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (locally || !membership.isAssignedLocally()) {
                it.remove();
                this.delete(membership);
                continue;
            }
            logger.debug("User {} is still a member of group {} although this membership does not exist in external authentication system. This is because that the user is added to the group locally.", (Object)membership.getUser().getName(), (Object)membership.getGroup().getName());
        }
        for (Group group : groups) {
            found = false;
            for (Membership membership : user.getMemberships()) {
                if (!membership.getGroup().getId().equals(group.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Membership membership = new Membership();
            membership.setAssignedLocally(locally);
            membership.setGroup(group);
            membership.setUser(user);
            user.getMemberships().add(membership);
            this.save(membership);
        }
    }

    @Override
    @SessionAware(transactional=true)
    public void assign(Group group, Collection<User> users, boolean locally) {
        boolean found;
        Iterator<Membership> it = group.getMemberships().iterator();
        while (it.hasNext()) {
            Membership membership = it.next();
            if (membership.getId() == null) {
                it.remove();
                continue;
            }
            found = false;
            for (User user : users) {
                if (!user.getId().equals(membership.getUser().getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (locally || !membership.isAssignedLocally()) {
                it.remove();
                this.delete(membership);
                continue;
            }
            logger.debug("User {} is still a member of group {} although this membership does not exist in external authentication system. This is because that the user is added to the group locally.", (Object)membership.getUser().getName(), (Object)membership.getGroup().getName());
        }
        for (User user : users) {
            found = false;
            for (Membership membership : group.getMemberships()) {
                if (!membership.getUser().getId().equals(user.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Membership membership = new Membership();
            membership.setAssignedLocally(locally);
            membership.setUser(user);
            membership.setGroup(group);
            group.getMemberships().add(membership);
            this.save(membership);
        }
    }
}

