/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.inject.Singleton;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.measurement.MeasurementUtils;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.MeasurementData1D;
import com.pmease.quickbuild.model.MeasurementData1H;
import com.pmease.quickbuild.model.MeasurementData6H;
import com.pmease.quickbuild.model.MeasurementDataR00;
import com.pmease.quickbuild.model.MeasurementDataR01;
import com.pmease.quickbuild.model.MeasurementDataR02;
import com.pmease.quickbuild.model.MeasurementDataR03;
import com.pmease.quickbuild.model.MeasurementDataR04;
import com.pmease.quickbuild.persistence.SessionInterceptor;
import com.pmease.quickbuild.persistence.SessionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMeasurementDataManager
implements MeasurementDataManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMeasurementDataManager.class);
    static final double MIN_VALUE = 1.0E-100;
    static final double MAX_VALUE = 1.0E126;

    protected Session getSession() {
        Session session = SessionInterceptor.getSession();
        if (session == null) {
            throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
        }
        return session;
    }

    @Override
    public long getPollingInterval() {
        return 300000L;
    }

    @Override
    @SessionAware(transactional=true)
    public MeasurementData save(MeasurementData data) {
        Double value = data.getValue();
        if (value == null || value.isInfinite() || value.isNaN()) {
            return data;
        }
        this.getSession().saveOrUpdate((Object)data);
        return data;
    }

    private static void flushAndClear(Session session) {
        session.flush();
        session.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(List<MeasurementData> measurements) {
        Session session = SessionManager.openSession();
        try {
            Transaction tx = session.beginTransaction();
            int i = 0;
            for (MeasurementData each : measurements) {
                Double value = each.getValue();
                if (value == null || value.isInfinite() || value.isNaN() || DefaultMeasurementDataManager.isUnderflow(value)) continue;
                session.saveOrUpdate((Object)each);
                if (++i % 200 != 0) continue;
                DefaultMeasurementDataManager.flushAndClear(session);
            }
            DefaultMeasurementDataManager.flushAndClear(session);
            tx.commit();
        }
        finally {
            SessionManager.closeSession();
        }
    }

    private static boolean isUnderflow(Double value) {
        return value <= 1.0E-100 || value >= 1.0E126;
    }

    @Override
    @SessionAware
    public long getMaxTimestamp(Class<? extends MeasurementData> table) {
        String query = "SELECT timestamp from " + table.getSimpleName() + " ORDER BY timestamp DESC";
        Query q = this.getSession().createQuery(query);
        q.setMaxResults(1);
        Long time = (Long)q.uniqueResult();
        if (time == null) {
            return 0L;
        }
        return time;
    }

    @Override
    @SessionAware
    public long getMinTimestamp(Class<? extends MeasurementData> table) {
        String query = "SELECT timestamp from " + table.getSimpleName() + " ORDER BY timestamp";
        Query q = this.getSession().createQuery(query);
        q.setMaxResults(1);
        Long time = (Long)q.uniqueResult();
        if (time == null) {
            return 0L;
        }
        return time;
    }

    private static String tableName(Class<? extends MeasurementData> clazz) {
        return clazz.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long lastUpdatedTime(String source, String table) {
        Stopwatch watch = new Stopwatch().start();
        try {
            String sql = "SELECT timestamp from " + table;
            if (!Strings.isNullOrEmpty((String)source)) {
                sql = sql + " WHERE source = :source ";
            }
            sql = sql + " ORDER BY timestamp DESC";
            Query query = this.getSession().createQuery(sql);
            if (!Strings.isNullOrEmpty((String)source)) {
                query.setParameter("source", (Object)source);
            }
            query.setMaxResults(1);
            Long r = (Long)query.uniqueResult();
            long l = r == null ? 0L : r;
            return l;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("find last update time for source [" + source + "] from table [" + table + "] in " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
            }
        }
    }

    @Override
    @SessionAware
    public long getLastTimestamp(String source) {
        Stopwatch watch = new Stopwatch().start();
        long now = System.currentTimeMillis();
        int index = MeasurementUtils.getTableIndex(now);
        int deadIndex = MeasurementUtils.getDeadTableIndex(now);
        long lastTime = 0L;
        do {
            Class<? extends MeasurementData> table;
            Long time;
            if ((time = Long.valueOf(this.lastUpdatedTime(source, DefaultMeasurementDataManager.tableName(table = MeasurementUtils.getRawTable(index))))) != null) {
                lastTime = time;
                break;
            }
            if (--index >= 0) continue;
            index = 4;
        } while (index != deadIndex);
        long time = this.getMaxTimestamp(MeasurementData1H.class);
        if (lastTime >= time) {
            return lastTime;
        }
        lastTime = time;
        if (lastTime >= (time = this.lastUpdatedTime(source, DefaultMeasurementDataManager.tableName(MeasurementData6H.class)))) {
            return lastTime;
        }
        lastTime = time;
        time = this.lastUpdatedTime(source, DefaultMeasurementDataManager.tableName(MeasurementData1D.class));
        if (logger.isDebugEnabled()) {
            logger.debug("getLastTimestamp cost " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
        }
        return Math.max(lastTime, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SessionAware
    public List<MeasurementData> find(Class<? extends MeasurementData> table, SearchCriteria criteria, int start, int limit) {
        Stopwatch watch = new Stopwatch().start();
        try {
            Criteria crit = this.getSession().createCriteria(table);
            if (criteria.getCriterions() != null) {
                for (Criterion criterion : criteria.getCriterions()) {
                    crit.add(criterion);
                }
            }
            if (criteria.getOrders() != null) {
                for (Criterion criterion : criteria.getOrders()) {
                    crit.addOrder((Order)criterion);
                }
            }
            if (start > 0) {
                crit.setFirstResult(start);
            }
            if (limit > 0) {
                crit.setMaxResults(limit);
            }
            List list = crit.list();
            return list;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Find measurements in table [" + table.getSimpleName() + "] with criteria [" + criteria + "] in " + watch.elapsed(TimeUnit.MILLISECONDS) + " millis");
            }
        }
    }

    @Override
    public List<MeasurementData> find(Class<? extends MeasurementData> table, SearchCriteria criteria) {
        return this.find(table, criteria, 0, 0);
    }

    public List<MeasurementData> find(Range<Long> period, Optional<Long> nowOpt, Optional<MeasurementDataManager.TableType> typeOpt, Optional<String> sourceOpt, Optional<String> metricNameOpt, Optional<SearchCriteria> critOpt) {
        return this.find(period, nowOpt, typeOpt, sourceOpt, metricNameOpt, critOpt, MatchMode.EXACT);
    }

    @SessionAware
    public List<MeasurementData> find(Range<Long> period, Optional<Long> nowOpt, Optional<MeasurementDataManager.TableType> typeOpt, Optional<String> sourceOpt, Optional<String> metricNameOpt, Optional<SearchCriteria> critOpt, MatchMode matchMode) {
        SearchCriteria.Builder builder = SearchCriteria.builder();
        builder.add((Criterion)(period.lowerBoundType() == BoundType.OPEN ? Restrictions.gt((String)"timestamp", (Object)period.lowerEndpoint()) : Restrictions.ge((String)"timestamp", (Object)period.lowerEndpoint())));
        builder.add((Criterion)(period.upperBoundType() == BoundType.OPEN ? Restrictions.lt((String)"timestamp", (Object)period.upperEndpoint()) : Restrictions.le((String)"timestamp", (Object)period.upperEndpoint())));
        if (sourceOpt.isPresent()) {
            builder.add((Criterion)Restrictions.eq((String)"source", (Object)sourceOpt.get()));
        }
        if (metricNameOpt.isPresent()) {
            if (matchMode == MatchMode.EXACT) {
                builder.add((Criterion)Restrictions.eq((String)"metricName", (Object)metricNameOpt.get()));
            } else {
                builder.add(Restrictions.ilike((String)"metricName", (String)((String)metricNameOpt.get()), (MatchMode)matchMode));
            }
        }
        if (critOpt.isPresent()) {
            builder.add((SearchCriteria)critOpt.get());
        }
        builder.add(Order.asc((String)"timestamp"));
        SearchCriteria criteria = builder.build();
        Class[] tables = !typeOpt.isPresent() || typeOpt.get() == MeasurementDataManager.TableType.RAW ? MeasurementUtils.getTables((Long)period.lowerEndpoint(), (Long)period.upperEndpoint(), nowOpt.isPresent() ? (Long)nowOpt.get() : System.currentTimeMillis()) : new Class[]{((MeasurementDataManager.TableType)((Object)typeOpt.get())).getTableClass()};
        ArrayList measurements = Lists.newArrayList();
        for (Class table : tables) {
            measurements.addAll(this.find(table, criteria));
        }
        return measurements;
    }

    @Override
    public List<MeasurementData> find(MeasurementDataManager.TableType type, Range<Long> period, SearchCriteria criteria) {
        return this.find(type, period, System.currentTimeMillis(), criteria);
    }

    @Override
    public List<MeasurementData> find(MeasurementDataManager.TableType type, Range<Long> period, Long now, SearchCriteria criteria) {
        return this.find(period, (Optional<Long>)Optional.fromNullable((Object)now), (Optional<MeasurementDataManager.TableType>)Optional.fromNullable((Object)((Object)type)), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<SearchCriteria>)Optional.fromNullable((Object)criteria));
    }

    @Override
    public List<MeasurementData> find(Range<Long> period, String source) {
        return this.find(period, source, null);
    }

    public List<MeasurementData> find(Range<Long> period, String source, String metricName) {
        return this.find(period, source, metricName, MatchMode.EXACT);
    }

    @Override
    public List<MeasurementData> find(Range<Long> period, String source, String metricName, MatchMode matchMode) {
        return this.find(null, period, source, metricName, matchMode);
    }

    @Override
    public List<MeasurementData> find(MeasurementDataManager.TableType type, Range<Long> period, String source, String metricName) {
        return this.find(type, period, source, metricName, MatchMode.EXACT);
    }

    @Override
    public List<MeasurementData> find(MeasurementDataManager.TableType type, Range<Long> period, String source, String metricName, MatchMode matchMode) {
        return this.find(period, (Optional<Long>)Optional.absent(), (Optional<MeasurementDataManager.TableType>)Optional.fromNullable((Object)((Object)type)), (Optional<String>)Optional.fromNullable((Object)source), (Optional<String>)Optional.fromNullable((Object)metricName), (Optional<SearchCriteria>)Optional.absent(), matchMode);
    }

    @Override
    public void clearAll() {
        logger.warn("Begin clearing all measurement data ...");
        this.truncateTable(MeasurementDataR00.class);
        this.truncateTable(MeasurementDataR01.class);
        this.truncateTable(MeasurementDataR02.class);
        this.truncateTable(MeasurementDataR03.class);
        this.truncateTable(MeasurementDataR04.class);
        this.truncateTable(MeasurementData1H.class);
        this.truncateTable(MeasurementData6H.class);
        this.truncateTable(MeasurementData1D.class);
        logger.warn("Finish clearing all measurement data.");
    }

    private void truncateTable(Class<? extends MeasurementData> table) {
        logger.info("Begin truncating table [" + table.getSimpleName() + "]");
        Stopwatch watch = new Stopwatch().start();
        int rows = 0;
        try {
            rows = this.executeSql("TRUNCATE TABLE QB_MEASUREMENT_DATAR0" + MeasurementUtils.getTableIndex(table));
        }
        catch (Exception e) {
            rows = this.executeHql("DELETE FROM " + table.getSimpleName());
        }
        logger.info("Finished truncating table [" + table.getSimpleName() + "], [" + rows + "] rows removed in [" + watch.elapsed(TimeUnit.MILLISECONDS) + "] millis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeSql(String sql) {
        Session session = SessionManager.openSession();
        try {
            Transaction tx = session.beginTransaction();
            SQLQuery query = session.createSQLQuery(sql);
            int rows = query.executeUpdate();
            tx.commit();
            int n = rows;
            return n;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeHql(String hql) {
        Session session = SessionManager.openSession();
        try {
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery(hql);
            int rows = query.executeUpdate();
            tx.commit();
            int n = rows;
            return n;
        }
        finally {
            SessionManager.closeSession();
        }
    }
}

