/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.IdManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Id;
import com.pmease.quickbuild.persistence.SessionManager;
import org.hibernate.Query;
import org.hibernate.Session;

@Singleton
public class DefaultIdManager
extends AbstractEntityManager<Id>
implements IdManager {
    @Override
    @SessionAware
    public Id get(String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from Id id where id.name=:name");
        query.setParameter("name", (Object)name);
        return (Id)query.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getId(String name) {
        if (Bootstrap.isServer()) {
            if (SessionManager.getSession() == null) {
                DefaultIdManager defaultIdManager = this;
                synchronized (defaultIdManager) {
                    return this.internalGetId(name);
                }
            }
            return this.internalGetId(name);
        }
        return Quickbuild.getServerService().getId(name);
    }

    @SessionAware(transactional=true)
    protected Long internalGetId(String name) {
        Id directory = this.get(name);
        if (directory == null) {
            directory = new Id();
            directory.setName(name);
            this.getSession().save((Object)directory);
        }
        return directory.getId();
    }
}

