/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.GroupShareManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.GroupShare;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.Synchronization;
import org.hibernate.Query;

@Singleton
public class DefaultGroupShareManager
extends AbstractEntityManager<GroupShare>
implements GroupShareManager {
    @Override
    @SessionAware(transactional=true)
    public void delete(final GroupShare share) {
        super.delete(share);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.groupShareRemoved(share.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final GroupShare share) {
        super.save(share);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.groupShareSaved(share);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void share(Dashboard dashboard, Collection<Group> groups) {
        boolean found;
        Iterator<GroupShare> it = dashboard.getGroupShares().iterator();
        while (it.hasNext()) {
            GroupShare share = it.next();
            if (share.getId() == null) {
                it.remove();
                continue;
            }
            found = false;
            for (Group group : groups) {
                if (group != null) {
                    if (share.getGroup() == null || !group.getId().equals(share.getGroup().getId())) continue;
                    found = true;
                    break;
                }
                if (share.getGroup() != null) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
            this.delete(share);
        }
        for (Group group : groups) {
            found = false;
            for (GroupShare share : dashboard.getGroupShares()) {
                if (share.getGroup() != null) {
                    if (group == null || !share.getGroup().getId().equals(group.getId())) continue;
                    found = true;
                    break;
                }
                if (group != null) continue;
                found = true;
                break;
            }
            if (found) continue;
            GroupShare share = new GroupShare();
            share.setGroup(group);
            share.setDashboard(dashboard);
            dashboard.getGroupShares().add(share);
            this.save(share);
        }
    }

    @Override
    @SessionAware
    public Collection<GroupShare> getGroupShares(Group group) {
        Query query = this.getSession().createQuery("from GroupShare where group=:group");
        query.setParameter("group", (Object)group);
        return query.list();
    }
}

