/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.AuthorizationManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.GroupShareManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.setting.system.SecuritySetting;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;

@Singleton
public class DefaultGroupManager
extends AbstractEntityManager<Group>
implements GroupManager {
    @Inject
    private SettingManager settingManager;
    @Inject
    private MembershipManager membershipManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private GroupShareManager shareManager;

    @Override
    @SessionAware
    public Group get(String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from Group group where group.name=:name");
        query.setParameter("name", (Object)name);
        query.setCacheable(true);
        return (Group)query.uniqueResult();
    }

    @Override
    public List<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : this.getAll(null)) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    @Override
    public Group copyAsNew(Group group) {
        Group newGroup = (Group)BeanUtils.clone(group);
        newGroup.setId(null);
        for (Authorization authorization : group.getAuthorizations()) {
            Authorization newAuthorization = new Authorization();
            newAuthorization.setPermissions(authorization.getPermissions());
            newAuthorization.setConfiguration(authorization.getConfiguration());
            newAuthorization.setGroup(newGroup);
            newGroup.getAuthorizations().add(newAuthorization);
        }
        for (Membership membership : group.getMemberships()) {
            Membership newMembership = new Membership();
            newMembership.setGroup(newGroup);
            Hibernate.initialize(membership.getUser().getMemberships());
            newMembership.setUser(membership.getUser());
            newGroup.getMemberships().add(newMembership);
        }
        return newGroup;
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final Group group) {
        for (Membership membership : group.getMemberships()) {
            this.membershipManager.delete(membership);
        }
        for (Authorization authorization : group.getAuthorizations()) {
            this.authorizationManager.delete(authorization);
        }
        for (GroupShare share : group.getShares()) {
            this.shareManager.delete(share);
        }
        this.getSession().delete((Object)group);
        SecuritySetting securitySetting = this.settingManager.getSecuritySettingDef();
        for (VersionedDocument dom : securitySetting.getAuthenticatorDOMs()) {
            Authenticator authenticator = (Authenticator)dom.toBean();
            if (!group.getName().equals(authenticator.getDefaultGroupName())) continue;
            authenticator.setDefaultGroupName(null);
            dom.setWrapped(VersionedDocument.fromBean(authenticator).getWrapped());
        }
        if (group.getName().equals(securitySetting.getTrustUserNameInHttpHeader().getDefaultGroupName())) {
            securitySetting.getTrustUserNameInHttpHeader().setDefaultGroupName(null);
        }
        this.settingManager.saveSecuritySetting(securitySetting);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultGroupManager.this.cacheManager.groupRemoved(group.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    private void updateGroupReferences(String oldGroupName, String newGroupName) {
        SecuritySetting securitySetting = this.settingManager.getSecuritySettingDef();
        for (VersionedDocument dom : securitySetting.getAuthenticatorDOMs()) {
            Authenticator authenticator = (Authenticator)dom.toBean();
            if (!oldGroupName.equals(authenticator.getDefaultGroupName())) continue;
            authenticator.setDefaultGroupName(newGroupName);
            dom.setWrapped(VersionedDocument.fromBean(authenticator).getWrapped());
        }
        if (oldGroupName.equals(securitySetting.getTrustUserNameInHttpHeader().getDefaultGroupName())) {
            securitySetting.getTrustUserNameInHttpHeader().setDefaultGroupName(newGroupName);
        }
        this.settingManager.saveSecuritySetting(securitySetting);
    }

    @Override
    @SessionAware(transactional=true)
    public void save(Group group) {
        this.save(group, null);
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Group group, String oldGroupName) {
        super.save(group);
        if (oldGroupName != null && !oldGroupName.equals(group.getName())) {
            this.updateGroupReferences(oldGroupName, group.getName());
        }
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultGroupManager.this.cacheManager.groupSaved(group);
                }
            }

            public void beforeCompletion() {
            }
        });
    }
}

