/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.maintenance.ConfigurationSyncStep;
import com.pmease.quickbuild.maintenance.CopyPromotionsStep;
import com.pmease.quickbuild.maintenance.CopyRepositoriesStep;
import com.pmease.quickbuild.maintenance.CopyStepsStep;
import com.pmease.quickbuild.maintenance.CopyVariablesStep;
import com.pmease.quickbuild.maintenance.RecursiveSyncOption;
import com.pmease.quickbuild.maintenance.RemoveObsoleteAccountStep;
import com.pmease.quickbuild.migration.MainMigrator;
import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Audit;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.BuildDependence;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.Setting;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.PersistenceNamingStrategy;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.setting.configuration.artifactcleanup.DisableAutoCleanupArtifact;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage;
import com.pmease.quickbuild.setting.configuration.buildcleanup.DisableAutoCleanupBuild;
import com.pmease.quickbuild.setting.configuration.buildcondition.BuildIfChanged;
import com.pmease.quickbuild.setting.configuration.loglevel.InfoLogLevel;
import com.pmease.quickbuild.setting.configuration.snapshot.TakeReferencedSnapshots;
import com.pmease.quickbuild.setting.configuration.storage.UseGlobalStorage;
import com.pmease.quickbuild.setting.configuration.workspace.UseNameAsWorkspace;
import com.pmease.quickbuild.setting.system.AlertRetentionSetting;
import com.pmease.quickbuild.setting.system.AutoBackupSetting;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.setting.system.SecuritySetting;
import com.pmease.quickbuild.setting.system.SystemSetting;
import com.pmease.quickbuild.stepsupport.SequentialStep;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.taskschedule.SchedulableTask;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.taskschedule.schedule.CronSchedule;
import com.pmease.quickbuild.taskschedule.schedule.NoSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.PromptAsCheckbox;
import com.pmease.quickbuild.variable.PromptAsConfigurationPicker;
import com.pmease.quickbuild.variable.PromptAsMultiSelectionBox;
import com.pmease.quickbuild.variable.PromptAsPasswordInput;
import com.pmease.quickbuild.variable.PromptAsTextInput;
import com.pmease.quickbuild.variable.SecretValueProvider;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.wizard.WizardStep;
import com.pmease.quickbuild.web.page.AdminAccountBean;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.ManyToOne;
import org.dom4j.Branch;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultDataManager
extends AbstractEntityManager<AbstractEntity>
implements DataManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataManager.class);
    private static final int NORMAL_BATCH_SIZE = 1000;
    private static final int LARGE_BATCH_SIZE = 10000;
    @Inject
    private SettingManager settingManager;
    @Inject
    private UserManager userManager;
    @Inject
    private TaskScheduler taskScheduler;
    @Inject
    private ConfigurationManager configurationManager;
    @Inject
    private SessionFactory sessionFactory;
    private Map<Long, Pair<String, Long>> configurationInfos = new HashMap<Long, Pair<String, Long>>();
    private Map<Long, String> configurationPaths = new HashMap<Long, String>();
    private String backupTaskId;

    private boolean hasForeignKeyDependency(Class entityType1, Class entityType2) {
        for (Field field : BeanUtils.getFields(entityType1)) {
            if (field.getAnnotation(ManyToOne.class) == null) continue;
            if (field.getType() == entityType2) {
                return true;
            }
            if (field.getType() == entityType1 || !this.hasForeignKeyDependency(field.getType(), entityType2)) continue;
            return true;
        }
        return false;
    }

    private List getEntityTypes() {
        ArrayList entityTypes = new ArrayList();
        for (String entityTypeName : this.sessionFactory.getAllClassMetadata().keySet()) {
            try {
                entityTypes.add(Class.forName(entityTypeName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<Class> sorted = new ArrayList<Class>();
        while (!entityTypes.isEmpty()) {
            Class dependencyLeaf = null;
            for (Class clazz : entityTypes) {
                boolean hasDependents = false;
                for (Class clazz2 : entityTypes) {
                    if (clazz2 == clazz || !this.hasForeignKeyDependency(clazz2, clazz)) continue;
                    hasDependents = true;
                    break;
                }
                if (hasDependents) continue;
                dependencyLeaf = clazz;
                break;
            }
            if (dependencyLeaf != null) {
                sorted.add(dependencyLeaf);
                entityTypes.remove(dependencyLeaf);
                continue;
            }
            throw new RuntimeException("Looped foreigh key dependency found between model classes");
        }
        return sorted;
    }

    @Override
    @SessionAware(transactional=true)
    public List<WizardStep> initialize() {
        WizardStep step;
        Setting setting;
        ArrayList<WizardStep> serverSetupSteps = new ArrayList<WizardStep>();
        Session session = this.getSession();
        if (this.settingManager.get(Setting.DATA_VERSION_ID) == null) {
            setting = new Setting();
            setting.setId(Setting.DATA_VERSION_ID);
            setting.setObject((Serializable)((Object)MigrationHelper.getVersion(MainMigrator.class)));
            session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        }
        if (this.settingManager.get(Setting.ALERT_SETTING_ID) == null) {
            setting = new Setting();
            setting.setId(Setting.ALERT_SETTING_ID);
            setting.setObject(new AlertRetentionSetting());
            session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        }
        if (this.settingManager.get(Setting.LICENSE_KEY_ID) == null) {
            setting = new Setting();
            setting.setId(Setting.LICENSE_KEY_ID);
            setting.setObject((Serializable)((Object)"AAAAuqztAAVzcgAuY29tLnBtZWFzZS5xdWlja2J1aWxkLmxpY2Vuc2UuQ29tbXVuaXR5TGljZW5zZQAAAAAAAAABAgAAeHIAJWNvbS5wbWVhc2UucXVpY2tidWlsZC5saWNlbnNlLkxpY2Vuc2UAAAAAAAAAAQIAAUwABHV1aWR0ABJMamF2YS9sYW5nL1N0cmluZzt4cHQAJDNjOGZhYzhiLWEwNTAtNGY1ZC04NjY1LWNlYzU1MGQyYmU1ZAAAAC8wLQIUEMtKGTvjeLav0SRoLXIHCy2pHqECFQCSG6Q6P9AvQjmiuSbcnbrsHmzodg=="));
            session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        }
        if (this.settingManager.get(Setting.SECURITY_SETTING_ID) == null) {
            setting = new Setting();
            setting.setId(Setting.SECURITY_SETTING_ID);
            setting.setObject(new SecuritySetting());
            session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        }
        if (this.settingManager.get(Setting.AUTOBACKUP_SETTING_ID) == null) {
            setting = new Setting();
            setting.setId(Setting.AUTOBACKUP_SETTING_ID);
            setting.setObject(null);
            session.replicate((Object)setting, ReplicationMode.OVERWRITE);
        }
        if (this.userManager.get(User.ROOT_ID) == null) {
            final AdminAccountBean administrator = new AdminAccountBean();
            WizardStep step2 = new WizardStep(administrator, false, new String[0]){

                @Override
                protected void finished() {
                    User user = new User();
                    user.setId(User.ROOT_ID);
                    user.setName(administrator.getName());
                    user.setFullName(administrator.getFullName());
                    user.setEmail(administrator.getEmail());
                    user.setPassword(administrator.getPassword());
                    try {
                        Session session = SessionManager.openSession();
                        session.getTransaction().begin();
                        session.replicate((Object)user, ReplicationMode.OVERWRITE);
                        session.flush();
                        session.getTransaction().commit();
                        WebSession.get().setUserId(user.getId());
                    }
                    catch (Throwable throwable) {
                        try {
                            SessionManager.getSession().getTransaction().rollback();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw ExceptionUtils.wrapAsUnchecked(throwable);
                    }
                    finally {
                        SessionManager.closeSession();
                    }
                }

                @Override
                protected void skipped() {
                    throw new IllegalStateException();
                }
            };
            serverSetupSteps.add(step2);
        }
        final SystemSetting systemSetting = (setting = (Setting)this.settingManager.get(Setting.SYSTEM_SETTING_ID)) == null ? new SystemSetting() : (SystemSetting)setting.getObject();
        EditContext editContext = new EditContext(systemSetting);
        editContext.validate(false);
        if (editContext.hasError()) {
            ArrayList<String> invalidProperties = new ArrayList<String>();
            for (EditContext.EditableProperty property : editContext.getProperties()) {
                if (property.getError() == null) continue;
                invalidProperties.add(property.getName());
            }
            step = new WizardStep(systemSetting, false, invalidProperties.toArray(new String[0])){

                @Override
                protected void finished() {
                    DefaultDataManager.this.settingManager.saveSystemSetting(systemSetting);
                }

                @Override
                protected void skipped() {
                    throw new IllegalStateException();
                }
            };
            serverSetupSteps.add(step);
        }
        if (this.settingManager.get(Setting.EMAIL_SETTING_ID) == null) {
            final EmailSetting emailSetting = new EmailSetting();
            step = new WizardStep(emailSetting, true, new String[]{"smtpHost", "smtpPort", "smtpOverSSL", "smtpUser", "smtpPassword"}){

                @Override
                protected void finished() {
                    DefaultDataManager.this.settingManager.saveEmailSetting(emailSetting);
                }

                @Override
                protected void skipped() {
                    DefaultDataManager.this.settingManager.saveEmailSetting(null);
                }
            };
            serverSetupSteps.add(step);
        }
        if (this.configurationManager.get(Configuration.ROOT_ID) == null) {
            Configuration rootConf = new Configuration(true);
            rootConf.setId(Configuration.ROOT_ID);
            rootConf.setName("root");
            rootConf.setWorkspaceSetting(new UseNameAsWorkspace());
            rootConf.setStorageSetting(new UseGlobalStorage());
            rootConf.setSnapshotTaking(new TakeReferencedSnapshots());
            rootConf.setBuildCondition(new BuildIfChanged());
            rootConf.setPriority("5");
            rootConf.setDisabled(false);
            rootConf.setLegacyCmdMode(false);
            rootConf.setConcurrent(false);
            rootConf.setRecordSCMChanges(true);
            rootConf.setQueueChangedBranchesOnly(false);
            rootConf.setAuditBuildRequest(true);
            rootConf.setShowConfigurationInPipeline(true);
            rootConf.setTriggerDependents(false);
            rootConf.setArtifactStorageDOM(VersionedDocument.fromBean(new ServerArtifactStorage()));
            rootConf.setTimeout(String.valueOf(720));
            rootConf.setLogLevel(new InfoLogLevel());
            rootConf.setBuildCleanupStrategy(new DisableAutoCleanupBuild());
            rootConf.setArtifactCleanupStrategy(new DisableAutoCleanupArtifact());
            rootConf.setSchedule(new NoSchedule());
            SequentialStep sequentialStep = new SequentialStep();
            sequentialStep.setName("master");
            rootConf.getStepDOMs().put(sequentialStep.getName(), VersionedDocument.fromBean(sequentialStep));
            session.replicate((Object)rootConf, ReplicationMode.OVERWRITE);
            session.flush();
            session.evict((Object)rootConf);
            Configuration maintenanceConf = new Configuration(true);
            maintenanceConf.setDisabled(true);
            maintenanceConf.setName("~maintenance");
            maintenanceConf.setParent(rootConf);
            session.save((Object)maintenanceConf);
            Configuration syncConf = new Configuration(true);
            syncConf.setName("sync configurations");
            syncConf.setDescription("This configuration is created to demonstrate how to use the \"Maintenance/Sync Configurations\" step to sync configuration settings from remote QuickBuild server. To sync, just run this configuration and fill in necessary information on the build option page.");
            syncConf.setParent(maintenanceConf);
            syncConf.setDisabled(false);
            ConfigurationSyncStep syncStep = new ConfigurationSyncStep();
            syncStep.setName("master");
            syncStep.setServerUrl("${vars.get(\"syncServerUrl\")}");
            syncStep.setUserName("${vars.get(\"syncUserName\")}");
            syncStep.setPassword("${vars.get(\"syncPassword\")}");
            syncStep.setSrcConfigurationPath("${vars.get(\"syncSrcConfiguration\")}");
            syncStep.setDestConfigurationPath("${vars.get(\"syncDestConfiguration\")}");
            syncStep.setRecursiveSyncOption(new RecursiveSyncOption());
            syncConf.getStepDOMs().put(syncStep.getName(), VersionedDocument.fromBean(syncStep));
            Variable var = new Variable();
            var.setName("syncServerUrl");
            var.setPromptSetting(new PromptAsTextInput());
            var.getPromptSetting().setDisplayName("Remote QuickBuild Server URL");
            var.getPromptSetting().setDescription("Specify URL of remote QuickBuild server to sync configurations from.\n For example: http://remote-qb-server:8810");
            syncConf.getVariables().add(var);
            var = new Variable();
            var.setName("syncUserName");
            var.setPromptSetting(new PromptAsTextInput());
            var.getPromptSetting().setDisplayName("Remote User Name");
            var.getPromptSetting().setDescription("Specify user name to login to the remote\nQuickBuild server. This user needs to have permission to access\nsettings of the configuration and all its descedents specified below.");
            syncConf.getVariables().add(var);
            var = new Variable();
            var.setName("syncPassword");
            var.setValueProvider(new SecretValueProvider());
            var.setPromptSetting(new PromptAsPasswordInput());
            var.getPromptSetting().setDisplayName("Remote Password");
            var.getPromptSetting().setDescription("Specify password of above user.");
            syncConf.getVariables().add(var);
            var = new Variable();
            var.setName("syncSrcConfiguration");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Source Configuration");
            var.getPromptSetting().setDescription("Specify path of the configuration to sync from.\nThis configuration should exist on the remote server.");
            syncConf.getVariables().add(var);
            var = new Variable();
            var.setName("syncDestConfiguration");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Destination Configuration");
            var.getPromptSetting().setDescription("Specify path of the destination configuration for\nsyncing. This configuration should exist on current server. <b>Each descendent\nconfiguration will also be synced</b> from descendent with the same name under\nthe source configuration specified above.");
            syncConf.getVariables().add(var);
            session.save((Object)syncConf);
            Configuration copyStepsConf = new Configuration(true);
            copyStepsConf.setDisabled(false);
            copyStepsConf.setName("copy steps");
            copyStepsConf.setDescription("This configuration is created to demonstrate how to use the \"Maintenance/Copy Steps\" step to copy steps from one configuration to another. To copy, just run this configuration and fill in necessary information on the build option page.");
            copyStepsConf.setParent(maintenanceConf);
            CopyStepsStep copyStepsStep = new CopyStepsStep();
            copyStepsStep.setName("master");
            copyStepsStep.setSrcConfigurationPath("${vars.get(\"srcConf\")}");
            copyStepsStep.setDestConfigurationPath("${vars.get(\"destConf\")}");
            copyStepsStep.setStepNames("${vars.get(\"steps\")}");
            copyStepsStep.setIncludeChildSteps("vars.get(\"includeChildSteps\").asBoolean()");
            copyStepsStep.setIncludeReferencedRepositories("vars.get(\"includeReferencedRepositories\").asBoolean()");
            copyStepsConf.getStepDOMs().put(copyStepsStep.getName(), VersionedDocument.fromBean(copyStepsStep));
            var = new Variable();
            var.setName("srcConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Source Configuration");
            var.getPromptSetting().setDescription("Specify source configuration to copy steps from.");
            copyStepsConf.getVariables().add(var);
            var = new Variable();
            var.setName("steps");
            PromptAsMultiSelectionBox promptAsMultiSelectionBox = new PromptAsMultiSelectionBox();
            var.setPromptSetting(promptAsMultiSelectionBox);
            promptAsMultiSelectionBox.setDisplayName("Steps To Copy");
            promptAsMultiSelectionBox.setDescription("Specify steps to copy.");
            promptAsMultiSelectionBox.setChoices("${groovy:\nimport com.pmease.quickbuild.util.StringUtils;\ndef srcConfPath = vars.getValue(\"srcConf\");\nif (srcConfPath == null)\n  return \"\";\ndef srcConf = system.configurationManager.get(vars.getValue(\"srcConf\"));\nif (srcConf == null)\n  return \"\";\nelse\n  return StringUtils.join(srcConf.findStepNames());\n}");
            var.setPromptSetting(promptAsMultiSelectionBox);
            copyStepsConf.getVariables().add(var);
            var = new Variable();
            var.setName("includeChildSteps");
            var.setPromptSetting(new PromptAsCheckbox());
            var.getPromptSetting().setDisplayName("Include Child Steps");
            var.getPromptSetting().setDescription("Whether or not to include child steps when copy.");
            copyStepsConf.getVariables().add(var);
            var = new Variable();
            var.setName("includeReferencedRepositories");
            var.setPromptSetting(new PromptAsCheckbox());
            var.getPromptSetting().setDisplayName("Include Referenced Repositories");
            var.getPromptSetting().setDescription("Whether or not to include referenced repositories when copy.");
            copyStepsConf.getVariables().add(var);
            var = new Variable();
            var.setName("destConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Destination Configuration");
            var.getPromptSetting().setDescription("Specify destination configuration to copy steps to. Steps with same names will be overwritten.");
            copyStepsConf.getVariables().add(var);
            session.save((Object)copyStepsConf);
            Configuration copyRepositoriesConf = new Configuration(true);
            copyRepositoriesConf.setDisabled(false);
            copyRepositoriesConf.setName("copy repositories");
            copyRepositoriesConf.setDescription("This configuration is created to demonstrate how to use the \"Maintenance/Copy Repositories\" step to copy repositories from one configuration to another. To copy, just run this configuration and fill in necessary information on the build option page.");
            copyRepositoriesConf.setParent(maintenanceConf);
            CopyRepositoriesStep copyRepositoriesStep = new CopyRepositoriesStep();
            copyRepositoriesStep.setName("master");
            copyRepositoriesStep.setSrcConfigurationPath("${vars.get(\"srcConf\")}");
            copyRepositoriesStep.setDestConfigurationPath("${vars.get(\"destConf\")}");
            copyRepositoriesStep.setRepositoryNames("${vars.get(\"repositories\")}");
            copyRepositoriesConf.getStepDOMs().put(copyRepositoriesStep.getName(), VersionedDocument.fromBean(copyRepositoriesStep));
            var = new Variable();
            var.setName("srcConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Source Configuration");
            var.getPromptSetting().setDescription("Specify source configuration to copy repositories from.");
            copyRepositoriesConf.getVariables().add(var);
            var = new Variable();
            var.setName("repositories");
            promptAsMultiSelectionBox = new PromptAsMultiSelectionBox();
            var.setPromptSetting(promptAsMultiSelectionBox);
            promptAsMultiSelectionBox.setDisplayName("Repositories To Copy");
            promptAsMultiSelectionBox.setDescription("Specify repositories to copy.");
            promptAsMultiSelectionBox.setChoices("${groovy:\nimport com.pmease.quickbuild.util.StringUtils;\ndef srcConfPath = vars.getValue(\"srcConf\");\nif (srcConfPath == null)\n  return \"\";\ndef srcConf = system.configurationManager.get(vars.getValue(\"srcConf\"));\nif (srcConf == null)\n  return \"\";\nelse\n  return StringUtils.join(srcConf.findRepositoryNames());\n}");
            var.setPromptSetting(promptAsMultiSelectionBox);
            copyRepositoriesConf.getVariables().add(var);
            var = new Variable();
            var.setName("destConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Destination Configuration");
            var.getPromptSetting().setDescription("Specify destination configuration to copy repositories to. Repositories with same names will be overwritten.");
            copyRepositoriesConf.getVariables().add(var);
            session.save((Object)copyRepositoriesConf);
            Configuration copyVariablesConf = new Configuration(true);
            copyVariablesConf.setDisabled(false);
            copyVariablesConf.setName("copy variables");
            copyVariablesConf.setDescription("This configuration is created to demonstrate how to use the \"Maintenance/Copy Variables\" step to copy variables from one configuration to another. To copy, just run this configuration and fill in necessary information on the build option page.");
            copyVariablesConf.setParent(maintenanceConf);
            CopyVariablesStep copyVariablesStep = new CopyVariablesStep();
            copyVariablesStep.setName("master");
            copyVariablesStep.setSrcConfigurationPath("${vars.get(\"srcConf\")}");
            copyVariablesStep.setDestConfigurationPath("${vars.get(\"destConf\")}");
            copyVariablesStep.setVariableNames("${vars.get(\"variables\")}");
            copyVariablesConf.getStepDOMs().put(copyVariablesStep.getName(), VersionedDocument.fromBean(copyVariablesStep));
            var = new Variable();
            var.setName("srcConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Source Configuration");
            var.getPromptSetting().setDescription("Specify source configuration to copy variables from.");
            copyVariablesConf.getVariables().add(var);
            var = new Variable();
            var.setName("variables");
            promptAsMultiSelectionBox = new PromptAsMultiSelectionBox();
            var.setPromptSetting(promptAsMultiSelectionBox);
            promptAsMultiSelectionBox.setDisplayName("Variables To Copy");
            promptAsMultiSelectionBox.setDescription("Specify variables to copy.");
            promptAsMultiSelectionBox.setChoices("${groovy:\nimport com.pmease.quickbuild.util.StringUtils;\ndef srcConfPath = vars.getValue(\"srcConf\");\nif (srcConfPath == null)\n  return \"\";\ndef srcConf = system.configurationManager.get(vars.getValue(\"srcConf\"));\nif (srcConf == null)\n  return \"\";\nelse\n  return StringUtils.join(srcConf.findVariableNames());\n}");
            var.setPromptSetting(promptAsMultiSelectionBox);
            copyVariablesConf.getVariables().add(var);
            var = new Variable();
            var.setName("destConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Destination Configuration");
            var.getPromptSetting().setDescription("Specify destination configuration to copy variables to. Variables with same names will be overwritten.");
            copyVariablesConf.getVariables().add(var);
            session.save((Object)copyVariablesConf);
            Configuration copyPromotionsConf = new Configuration(true);
            copyPromotionsConf.setDisabled(false);
            copyPromotionsConf.setName("copy promotions");
            copyPromotionsConf.setDescription("This configuration is created to demonstrate how to use the \"Maintenance/Copy Promotions\" step to copy promotions from one configuration to another. To copy, just run this configuration and fill in necessary information on the build option page.");
            copyPromotionsConf.setParent(maintenanceConf);
            CopyPromotionsStep copyPromotionsStep = new CopyPromotionsStep();
            copyPromotionsStep.setName("master");
            copyPromotionsStep.setSrcConfigurationPath("${vars.get(\"srcConf\")}");
            copyPromotionsStep.setDestConfigurationPath("${vars.get(\"destConf\")}");
            copyPromotionsStep.setPromotionNames("${vars.get(\"promotions\")}");
            copyPromotionsConf.getStepDOMs().put(copyPromotionsStep.getName(), VersionedDocument.fromBean(copyPromotionsStep));
            var = new Variable();
            var.setName("srcConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Source Configuration");
            var.getPromptSetting().setDescription("Specify source configuration to copy promotions from.");
            copyPromotionsConf.getVariables().add(var);
            var = new Variable();
            var.setName("promotions");
            promptAsMultiSelectionBox = new PromptAsMultiSelectionBox();
            var.setPromptSetting(promptAsMultiSelectionBox);
            promptAsMultiSelectionBox.setDisplayName("Promotions To Copy");
            promptAsMultiSelectionBox.setDescription("Specify promotions to copy.");
            promptAsMultiSelectionBox.setChoices("${groovy:\nimport com.pmease.quickbuild.util.StringUtils;\ndef srcConfPath = vars.getValue(\"srcConf\");\nif (srcConfPath == null)\n  return \"\";\ndef srcConf = system.configurationManager.get(vars.getValue(\"srcConf\"));\nif (srcConf == null)\n  return \"\";\nelse\n  return StringUtils.join(srcConf.findPromotionNames());\n}");
            var.setPromptSetting(promptAsMultiSelectionBox);
            copyPromotionsConf.getVariables().add(var);
            var = new Variable();
            var.setName("destConf");
            var.setPromptSetting(new PromptAsConfigurationPicker());
            var.getPromptSetting().setDisplayName("Destination Configuration");
            var.getPromptSetting().setDescription("Specify destination configuration to copy promotions to. Promotions with same names will be overwritten.");
            copyPromotionsConf.getVariables().add(var);
            session.save((Object)copyPromotionsConf);
            Configuration removeObsoleteAccountsConf = new Configuration(true);
            removeObsoleteAccountsConf.setDisabled(false);
            removeObsoleteAccountsConf.setName("remove obsolete accounts");
            removeObsoleteAccountsConf.setDescription("This configuration is created to demonstrate how to use the \"Maintenance/Remove Obsolete Accounts\" step to remove obsolete accounts no longer existing in external authenticator system.");
            removeObsoleteAccountsConf.setParent(maintenanceConf);
            RemoveObsoleteAccountStep removeObsoleteAccountsStep = new RemoveObsoleteAccountStep();
            removeObsoleteAccountsStep.setName("master");
            removeObsoleteAccountsConf.getStepDOMs().put(removeObsoleteAccountsStep.getName(), VersionedDocument.fromBean(removeObsoleteAccountsStep));
            session.save((Object)removeObsoleteAccountsConf);
        }
        Query query = session.createQuery("from Build where status = :status");
        query.setParameter("status", (Object)Build.Status.RUNNING);
        for (EditContext.EditableProperty each : query.list()) {
            Build build = (Build)((Object)each);
            build.setStatus(Build.Status.CANCELLED);
            build.setCanceller((User)this.userManager.load(User.ROOT_ID));
            build.setStatusDate(new Date());
            build.setDuration(new Date().getTime() - build.getBeginDate().getTime());
            for (StepRuntime runtime : build.getStepRuntimes().values()) {
                if (runtime.getStatus() != StepRuntime.Status.RUNNING && runtime.getStatus() != StepRuntime.Status.WAITING) continue;
                runtime.setStatus(StepRuntime.Status.CANCELLED);
            }
            session.update((Object)build);
        }
        return serverSetupSteps;
    }

    @Override
    @SessionAware
    public <T extends AbstractEntity> int count(Class<T> entityType, SearchCriteria searchCriteria) {
        return this.countEntities(entityType, searchCriteria);
    }

    @Override
    @SessionAware
    public <T extends AbstractEntity> List<T> search(Class<T> entityType, SearchCriteria searchCriteria, int first, int count) {
        return this.searchEntities(entityType, searchCriteria, first, count);
    }

    @Override
    @SessionAware
    public <T extends AbstractEntity> List<Long> searchIds(Class<T> entityType, SearchCriteria searchCriteria, int first, int count) {
        return this.searchEntityIds(entityType, searchCriteria, first, count);
    }

    @Override
    @SessionAware
    public <T extends AbstractEntity> T load(Class<T> entityType, Long entityId) {
        Session session = this.getSession();
        return (T)((AbstractEntity)session.load(entityType, (Serializable)entityId));
    }

    @Override
    @SessionAware
    public <T extends AbstractEntity> T get(Class<T> entityType, Long entityId) {
        Session session = this.getSession();
        return (T)((AbstractEntity)session.get(entityType, (Serializable)entityId));
    }

    @Override
    @SessionAware
    public AbstractEntity loadEntity(Class<? extends AbstractEntity> entityType, Long entityId) {
        Session session = this.getSession();
        return (AbstractEntity)session.load(entityType, (Serializable)entityId);
    }

    @Override
    @SessionAware
    public AbstractEntity getEntity(Class<? extends AbstractEntity> entityType, Long entityId) {
        Session session = this.getSession();
        return (AbstractEntity)session.get(entityType, (Serializable)entityId);
    }

    @Override
    public AbstractEntity get(Long id) {
        throw new UnsupportedOperationException("Please call lookup(entityType, entityId) instead.");
    }

    @Override
    public AbstractEntity load(Long id) {
        throw new UnsupportedOperationException("Please call read(entityType, entityId) instead.");
    }

    @Override
    @SessionAware
    public void exportData(File exportDir, boolean excludeBuilds, boolean excludeMeasurements, boolean excludeAudits, boolean clearPasswords) {
        FileUtils.writeFile(new File(exportDir, "version.txt"), "app-version: " + Bootstrap.buildVersion + "\r\ndata-version: " + MigrationHelper.getVersion(MainMigrator.class));
        logger.info("");
        for (Class entityType : this.getEntityTypes()) {
            if (excludeBuilds && (entityType == Build.class || entityType == BuildDependence.class) || excludeMeasurements && MeasurementData.class.isAssignableFrom(entityType) || excludeAudits && entityType == Audit.class) continue;
            logger.info("Exporting table '" + entityType.getSimpleName() + "'...");
            logger.info("Querying table ids...");
            Criteria criteria = this.getSession().createCriteria(entityType, "entity").setProjection((Projection)Projections.property((String)"entity.id")).addOrder(Order.asc((String)"id"));
            List ids = criteria.list();
            int count = ids.size();
            int batchSize = MeasurementData.class.isAssignableFrom(entityType) ? 10000 : 1000;
            for (int i = 0; i < count / batchSize; ++i) {
                this.exportEntity(entityType, ids, i * batchSize, batchSize, exportDir, clearPasswords);
                this.getSession().clear();
            }
            if (count % batchSize != 0) {
                this.exportEntity(entityType, ids, count / batchSize * batchSize, count % batchSize, exportDir, clearPasswords);
            }
            logger.info("");
        }
    }

    private void exportEntity(Class entityType, List<Long> ids, int start, int count, File exportDir, boolean clearPasswords) {
        logger.info("Loading table rows ({}->{}) from database...", (Object)String.valueOf(start + 1), (Object)(start + count));
        Query query = this.getSession().createQuery("from " + entityType.getSimpleName() + " where id>=:fromId and id<=:toId");
        query.setParameter("fromId", (Object)ids.get(start));
        query.setParameter("toId", (Object)ids.get(start + count - 1));
        List entities = query.list();
        logger.info("Converting table rows to XML...");
        VersionedDocument dom = new VersionedDocument();
        Element rootElement = dom.addElement("list");
        for (Object entity : entities) {
            rootElement.appendContent((Branch)VersionedDocument.fromBean(entity));
        }
        int batchSize = MeasurementData.class.isAssignableFrom(entityType) ? 10000 : 1000;
        String fileName = start == 0 ? entityType.getSimpleName() + "s.xml" : entityType.getSimpleName() + "s.xml." + (start / batchSize + 1);
        logger.info("Writing resulting XML to file '" + fileName + "...");
        FileUtils.writeFile(new File(exportDir, fileName), dom, clearPasswords, true, true);
    }

    private List<String> getHierarchyNames(Long configurationId) {
        ArrayList<String> hierarchyNames = new ArrayList<String>();
        Pair<String, Long> configurationInfo = this.configurationInfos.get(configurationId);
        hierarchyNames.add(configurationInfo.getFirst());
        Long parentId = configurationInfo.getSecond();
        if (parentId != null) {
            hierarchyNames.addAll(this.getHierarchyNames(parentId));
        }
        return hierarchyNames;
    }

    private String getConfigurationPath(Long configurationId) {
        String pathName = this.configurationPaths.get(configurationId);
        if (pathName == null) {
            List<String> hierarchyNames = this.getHierarchyNames(configurationId);
            Collections.reverse(hierarchyNames);
            pathName = StringUtils.join(hierarchyNames, (String)"/");
            this.configurationPaths.put(configurationId, pathName);
        }
        return pathName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importData(File importDir) {
        File settingsFile = new File(importDir, Setting.class.getSimpleName() + "s.xml");
        VersionedDocument dom = FileUtils.readFileAsDom(settingsFile);
        for (Element element : dom.getRootElement().elements()) {
            Long settingId = Long.valueOf(element.elementTextTrim("id"));
            if (!settingId.equals(Setting.DATA_VERSION_ID)) continue;
            if (element.elementTextTrim("object").equals(MigrationHelper.getVersion(MainMigrator.class))) break;
            throw new QuickbuildException("Can not import from directory '" + importDir.getAbsolutePath() + "': Version mismatch.");
        }
        this.configurationInfos.clear();
        this.configurationPaths.clear();
        for (File file : importDir.listFiles()) {
            String configurationFileNamePrefix = Configuration.class.getSimpleName() + "s.xml";
            if (!file.getName().startsWith(configurationFileNamePrefix)) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                void var11_18;
                Element parentIdElement = element.element("parent");
                if (parentIdElement != null) {
                    Long l = Long.valueOf(parentIdElement.getTextTrim());
                } else {
                    Object var11_20 = null;
                }
                Pair<String, void> configurationInfo = new Pair<String, void>();
                configurationInfo.setFirst(element.elementText("name").trim());
                configurationInfo.setSecond(var11_18);
                this.configurationInfos.put(Long.valueOf(element.elementTextTrim("id")), configurationInfo);
            }
        }
        try {
            Session session = SessionManager.openSession();
            List entityTypes = this.getEntityTypes();
            try {
                session.beginTransaction();
                List configurationIds = session.createQuery("select id from Configuration").list();
                for (Long id : configurationIds) {
                    Query query = session.createQuery("update Configuration set parent=null, name=:name where id=:id");
                    query.setParameter("name", (Object)UUID.randomUUID().toString());
                    query.setParameter("id", (Object)id);
                    query.executeUpdate();
                }
                session.createQuery("update Build set promotedFrom=null").executeUpdate();
                for (final Class entityType : entityTypes) {
                    logger.info("Clearing entity '" + entityType.getSimpleName() + "'...");
                    session.createQuery("delete from " + entityType.getName()).executeUpdate();
                }
                session.flush();
                session.clear();
                session.getTransaction().commit();
            }
            catch (Throwable e) {
                session.getTransaction().rollback();
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            Collections.reverse(entityTypes);
            HashMap<Long, Long> buildPromotionSources = new HashMap<Long, Long>();
            for (final Class entityType : entityTypes) {
                File[] dataFiles;
                for (File file : dataFiles = importDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(entityType.getSimpleName() + "s.xml");
                    }
                })) {
                    try {
                        logger.info("Importing from data file '" + file.getName() + "'...");
                        session.beginTransaction();
                        dom = FileUtils.readFileAsDom(file);
                        for (Element element : dom.getRootElement().elements()) {
                            Build build;
                            AbstractEntity entity = (AbstractEntity)new VersionedDocument(element).toBean();
                            if (entity instanceof Configuration) {
                                new EditContext(entity, new String[]{"versionManager", "artifactStorage"}, true).validate(true);
                            } else {
                                BeanUtils.validate(entity);
                            }
                            if (entity instanceof Configuration) {
                                Configuration configuration = (Configuration)entity;
                                logger.info("Importing configuration '{}'...", (Object)this.getConfigurationPath(configuration.getId()));
                                configuration.setParent(configuration);
                                configuration.setName("*****");
                            } else if (entity instanceof Build && (build = (Build)entity).getPromotedFrom() != null) {
                                buildPromotionSources.put(build.getId(), Long.valueOf(element.elementText("promotedFrom").trim()));
                                build.setPromotedFrom(null);
                            }
                            session.replicate((Object)entity, ReplicationMode.EXCEPTION);
                        }
                        session.flush();
                        session.clear();
                        session.getTransaction().commit();
                    }
                    catch (Throwable e) {
                        session.getTransaction().rollback();
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
                if (entityType == Configuration.class) {
                    logger.info("Updating configuration names and parents...");
                    try {
                        session.beginTransaction();
                        for (Map.Entry<Long, Pair<String, Long>> entry : this.configurationInfos.entrySet()) {
                            Query query = session.createQuery("update Configuration set parent.id=:parentId, name=:name where id=:id");
                            query.setParameter("id", (Object)entry.getKey());
                            query.setParameter("parentId", (Object)entry.getValue().getSecond());
                            query.setParameter("name", (Object)entry.getValue().getFirst());
                            query.executeUpdate();
                        }
                        session.getTransaction().commit();
                        continue;
                    }
                    catch (Throwable e) {
                        session.getTransaction().rollback();
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
                if (entityType != Build.class) continue;
                logger.info("Updating build promotion sources...");
                try {
                    session.beginTransaction();
                    for (Map.Entry<Long, Pair<String, Long>> entry : buildPromotionSources.entrySet()) {
                        Query query = session.createQuery("update Build set promotedFrom.id=:promotionSourceId where id=:id");
                        query.setParameter("id", (Object)entry.getKey());
                        query.setParameter("promotionSourceId", entry.getValue());
                        query.executeUpdate();
                    }
                    session.getTransaction().commit();
                }
                catch (Throwable e) {
                    session.getTransaction().rollback();
                    throw ExceptionUtils.wrapAsUnchecked(e);
                    return;
                }
            }
        }
        finally {
            SessionManager.closeSession();
        }
    }

    @Override
    @SessionAware(transactional=true)
    public void clearDatabase() {
        for (Class entityType : this.getEntityTypes()) {
            String tableName = new PersistenceNamingStrategy().classToTableName(entityType.getName());
            this.getSession().createSQLQuery("drop table " + tableName).executeUpdate();
        }
    }

    @Override
    public void scheduleBackup() {
        AutoBackupSetting setting;
        if (this.backupTaskId != null) {
            this.taskScheduler.unschedule(this.backupTaskId);
        }
        if ((setting = this.settingManager.getAutoBackupSetting()) != null) {
            this.backupTaskId = this.taskScheduler.schedule(new SchedulableTask(){

                @Override
                public void execute() {
                    File backupDir = new File(setting.getFolder());
                    if (!backupDir.isAbsolute()) {
                        backupDir = new File(Bootstrap.installDir, setting.getFolder());
                    }
                    FileUtils.createDir(backupDir);
                    File tempDir = FileUtils.createTempDir("backup");
                    try {
                        Quickbuild.getInstance(DataManager.class).exportData(tempDir, setting.isExcludeBuilds(), setting.isExcludeMeasurements(), setting.isExcludeAudits(), false);
                        File backupFile = new File(backupDir, DateTimeFormat.forPattern((String)setting.getFilePattern()).print((ReadableInstant)new DateTime()) + ".zip");
                        FileUtils.zip(tempDir, backupFile);
                    }
                    catch (Exception e) {
                        Alert alert = new Alert();
                        alert.setAlertMessage("Database auto-backup is failed with below error.\n" + ExceptionUtils.extractImportantMessage(e) + "\n" + "Check server log for details.");
                        alert.setPriority(Alert.AlertPriority.HIGH);
                        alert.setSubject("Database auto-backup is failed");
                        alert.setTrigger(Grid.instance.getLocalNode().getAddress());
                        AlertManager.instance.alert(alert);
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    finally {
                        FileUtils.deleteDir(tempDir);
                    }
                }

                @Override
                public Schedule getSchedule() {
                    CronSchedule schedule = new CronSchedule();
                    schedule.setExpression(setting.getSchedule());
                    schedule.setPaused(false);
                    return schedule;
                }
            });
        }
    }
}

