/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.DashboardManager;
import com.pmease.quickbuild.entitymanager.GroupShareManager;
import com.pmease.quickbuild.entitymanager.UserShareManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.util.BeanUtils;
import javax.transaction.Synchronization;
import org.hibernate.LockOptions;
import org.hibernate.Session;

@Singleton
public class DefaultDashboardManager
extends AbstractEntityManager<Dashboard>
implements DashboardManager {
    @Inject
    private GroupShareManager groupShareManager;
    @Inject
    private UserShareManager userShareManager;

    @Override
    @SessionAware(transactional=true)
    public void delete(final Dashboard dashboard) {
        Session session = this.getSession();
        session.buildLockRequest(LockOptions.NONE).lock((Object)dashboard);
        for (GroupShare groupShare : dashboard.getGroupShares()) {
            this.groupShareManager.delete(groupShare);
        }
        for (UserShare userShare : dashboard.getUserShares()) {
            this.userShareManager.delete(userShare);
        }
        session.delete((Object)dashboard);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.dashboardRemoved(dashboard.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Dashboard dashboard) {
        super.save(dashboard);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.dashboardSaved(dashboard);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    public Dashboard copyAsNew(Dashboard dashboard) {
        Dashboard newDashboard = (Dashboard)BeanUtils.clone(dashboard);
        newDashboard.setId(null);
        return newDashboard;
    }
}

