/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.ResourceAccessManager;
import com.pmease.quickbuild.entitymanager.TriggerDependenceManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.extensionpoint.ActionListener;
import com.pmease.quickbuild.extensionpoint.ConfigurationListener;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.TriggerDependence;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.setting.configuration.workspace.UseIdAsWorkspace;
import com.pmease.quickbuild.setting.configuration.workspace.UseNameAsWorkspace;
import com.pmease.quickbuild.setting.configuration.workspace.WorkspaceSetting;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.variable.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.transaction.Synchronization;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.util.SerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultConfigurationManager
extends AbstractEntityManager<Configuration>
implements ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigurationManager.class);
    @Inject
    private CacheManager cacheManager;
    @Inject
    private BuildEngine buildEngine;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private BuildManager buildManager;
    @Inject
    private ScriptEngine scriptEngine;
    @Inject
    private TriggerDependenceManager triggerDependenceManager;
    @Inject
    private ResourceAccessManager resourceUsageManager;

    @Override
    @SessionAware
    public Configuration get(Configuration parent, String name) {
        Query query;
        Session session = this.getSession();
        if (parent != null) {
            query = session.createQuery("from Configuration where parent.id=:parentId and name=:name");
            query.setParameter("parentId", (Object)parent.getId());
        } else {
            query = session.createQuery("from Configuration where parent = null and name = :name");
        }
        query.setString("name", name);
        return (Configuration)query.uniqueResult();
    }

    private Long getChildId(Long parentId, String name) {
        Query query;
        Session session = this.getSession();
        if (parentId != null) {
            query = session.createQuery("select id from Configuration where parent.id=:parentId and name=:name");
            query.setParameter("parentId", (Object)parentId);
        } else {
            query = session.createQuery("select id from Configuration where parent = null and name = :name");
        }
        query.setString("name", name);
        return (Long)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Configuration get(String pathName) {
        String[] names = StringUtils.split((String)pathName, (char)'/');
        Configuration configuration = null;
        for (int i = 0; i < names.length; ++i) {
            if ((configuration = this.get(configuration, names[i].trim())) != null) continue;
            return null;
        }
        return configuration;
    }

    @Override
    @SessionAware
    public Long getId(String pathName) {
        String[] names = StringUtils.split((String)pathName, (char)'/');
        Long childId = null;
        for (int i = 0; i < names.length; ++i) {
            if ((childId = this.getChildId(childId, names[i].trim())) != null) continue;
            return null;
        }
        return childId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(final Configuration configuration) {
        boolean bl;
        UseIdAsWorkspace useIdAsWorkspace;
        UseNameAsWorkspace useNameAsWorkspace;
        for (ConfigurationListener listener : PluginManager.instance.getExtensions(ConfigurationListener.class)) {
            listener.onDelete(configuration);
        }
        for (Configuration child : this.getChildren(configuration)) {
            this.delete(child);
        }
        logger.debug("Deleting configuration '" + configuration.getPathName() + "'...");
        Session session = SessionManager.openSession();
        Transaction tx = session.beginTransaction();
        try {
            for (TriggerDependence triggerDependence : this.triggerDependenceManager.getDependencies(configuration)) {
                this.triggerDependenceManager.delete(triggerDependence);
            }
            for (TriggerDependence triggerDependence : this.triggerDependenceManager.getDependents(configuration)) {
                this.triggerDependenceManager.delete(triggerDependence);
            }
            this.resourceUsageManager.deleteBy(configuration);
            session.flush();
            tx.commit();
        }
        catch (Throwable t) {
            tx.rollback();
            throw ExceptionUtils.wrapAsUnchecked(t);
        }
        finally {
            SessionManager.closeSession();
        }
        for (Build build : this.buildManager.getBuilds(configuration)) {
            this.buildManager.delete(build, true);
        }
        List<ActionListener> listeners = this.pluginManager.getExtensions(ActionListener.class);
        for (ActionListener each : listeners) {
            each.removeConfiguration(configuration);
        }
        logger.trace("Removing configuration publish directory '" + configuration.getPublishDir().getAbsolutePath() + "'...");
        FileUtils.deleteDir(configuration.getPublishDir());
        boolean bl2 = false;
        WorkspaceSetting workspaceSetting = configuration.findWorkspaceSetting();
        if (workspaceSetting instanceof UseNameAsWorkspace && (useNameAsWorkspace = (UseNameAsWorkspace)workspaceSetting).isRemoveWorkspaceUponDeletion()) {
            boolean bl3 = true;
        }
        if (workspaceSetting instanceof UseIdAsWorkspace && (useIdAsWorkspace = (UseIdAsWorkspace)workspaceSetting).isRemoveWorkspaceUponDeletion()) {
            bl = true;
        }
        if (bl) {
            try {
                for (GridNode each : Grid.instance.getAllNodes()) {
                    String workspace = each.getWorkspaceDir(configuration.getId());
                    logger.trace("Removing configuration workspace (node: {}, workspace: {})", (Object)each.getAddress(), (Object)workspace);
                    each.deleteDir(workspace);
                }
            }
            catch (Exception e) {
                logger.warn("Error removing configuration workspaces.", (Throwable)e);
            }
        }
        session = SessionManager.openSession();
        tx = session.beginTransaction();
        try {
            session.delete((Object)configuration);
            logger.trace("Removing configuration entry from cache...");
            tx.registerSynchronization(new Synchronization(){

                public void afterCompletion(int status) {
                    if (status == 3) {
                        DefaultConfigurationManager.this.cacheManager.configurationRemoved(configuration.getId());
                        DefaultConfigurationManager.this.buildEngine.configurationRemoved(configuration.getId());
                    }
                }

                public void beforeCompletion() {
                }
            });
            session.flush();
            tx.commit();
        }
        catch (Throwable t) {
            tx.rollback();
            throw ExceptionUtils.wrapAsUnchecked(t);
        }
        finally {
            SessionManager.closeSession();
        }
        String onDeletionScript = configuration.findOnConfigurationDeletionScript();
        if (onDeletionScript != null) {
            Context.push(configuration);
            try {
                logger.trace("Executing on configuration deletion script...");
                this.scriptEngine.evaluate(onDeletionScript, Context.buildEvalContext(configuration, null));
            }
            finally {
                Context.pop();
            }
        }
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Configuration configuration) {
        final boolean isNew = configuration.isNew();
        for (ConfigurationListener listener : PluginManager.instance.getExtensions(ConfigurationListener.class)) {
            listener.onSave(configuration);
        }
        super.save(configuration);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultConfigurationManager.this.cacheManager.configurationSaved(configuration, isNew);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public void saveStatus(Configuration configuration, String errorMessage, Date statusDate) {
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)configuration);
        configuration.setErrorMessage(errorMessage);
        configuration.setStatusDate(statusDate);
        this.save(configuration);
    }

    @Override
    @SessionAware
    public void saveData(Configuration configuration, LinkedHashMap<String, Serializable> data) {
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)configuration);
        configuration.setData(data);
        this.save(configuration);
    }

    @Override
    @SessionAware
    public void saveShortBranches(Configuration configuration, ArrayList<ShortBranch> shortBranches) {
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)configuration);
        configuration.setShortBranches(shortBranches);
        this.save(configuration);
    }

    @Override
    @SessionAware
    public void saveVersionManager(Configuration configuration, VersionedDocument versionManagerDOM) {
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)configuration);
        configuration.setVersionManagerDOM(versionManagerDOM);
        this.save(configuration);
    }

    @Override
    @SessionAware
    public void refreshVersionManager(Configuration configuration) {
        Query query = this.getSession().createQuery("select versionManagerDOM from Configuration where id=:configurationId");
        query.setParameter("configurationId", (Object)configuration.getId());
        configuration.setVersionManagerDOM((VersionedDocument)query.uniqueResult());
    }

    @Override
    @SessionAware
    public void saveVariables(Configuration configuration) {
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setVariables(configuration.getVariables());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void saveNotifications(Configuration configuration) {
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setNotifications(configuration.getNotifications());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void savePromotions(Configuration configuration) {
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setPromotions(configuration.getPromotions());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void saveSchedule(Configuration configuration) {
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setSchedule(configuration.getSchedule());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void saveActiveRepository(Configuration configuration) {
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setActiveRepository(configuration.getActiveRepository());
        this.save(reloaded);
    }

    @Override
    public Configuration copyAsNew(Configuration configuration, boolean recursively) {
        if (recursively) {
            Configuration newConfiguration = this.copyAsNew(configuration, false);
            this.copyChildren(configuration, newConfiguration);
            return newConfiguration;
        }
        Configuration newConfiguration = (Configuration)BeanUtils.clone(configuration);
        newConfiguration.getData().clear();
        newConfiguration.setId(null);
        return newConfiguration;
    }

    @Override
    public void copyChildren(Configuration from, Configuration to) {
        for (Configuration fromChild : from.getChildren()) {
            Configuration toChild = this.copyAsNew(fromChild, false);
            to.getChildren().add(toChild);
            toChild.setParent(to);
            this.copyChildren(fromChild, toChild);
        }
    }

    @Override
    @SessionAware
    public void deleteRepository(Configuration configuration, String repositoryName) {
        configuration.getRepositoryDOMs().remove(repositoryName);
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setRepositoryDOMs(configuration.getRepositoryDOMs());
        this.save(reloaded);
        this.removeRepositoryReferences(reloaded, repositoryName);
    }

    @Override
    @SessionAware
    public void deleteAggregation(Configuration configuration, String aggregationName) {
        configuration.getAggregationDOMs().remove(aggregationName);
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setAggregationDOMs(configuration.getAggregationDOMs());
        this.save(reloaded);
    }

    private void removeRepositoryReferences(Configuration configuration, String repositoryName) {
        if (configuration.findRepositoryDeclarer(repositoryName) == null) {
            HashSet<String> stepsToDelete = new HashSet<String>();
            for (VersionedDocument dom : configuration.getStepDOMs().values()) {
                RepositoryStep repositoryStep;
                Step step = (Step)dom.toBean();
                if (!(step instanceof RepositoryStep) || !repositoryName.equals((repositoryStep = (RepositoryStep)step).getRepositoryName())) continue;
                stepsToDelete.add(step.getName());
            }
            for (String stepName : stepsToDelete) {
                this.deleteStep(configuration, stepName);
            }
            Query query = this.getSession().createQuery("select id, repositoryDOMs, stepDOMs from Configuration where parent=:configuration");
            query.setParameter("configuration", (Object)configuration);
            List resultset = query.list();
            for (Object[] row : resultset) {
                Configuration child = new Configuration();
                child.setParent(configuration);
                child.setId((Long)row[0]);
                child.setRepositoryDOMs((LinkedHashMap)row[1]);
                child.setStepDOMs((LinkedHashMap)row[2]);
                this.removeRepositoryReferences(child, repositoryName);
            }
        }
    }

    @Override
    @SessionAware
    public void deleteStep(Configuration configuration, String stepName) {
        configuration.getStepDOMs().remove(stepName);
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setStepDOMs(configuration.getStepDOMs());
        this.save(reloaded);
        this.removeStepReferences(reloaded, stepName);
    }

    private void removeStepReferences(Configuration configuration, String stepName) {
        if (configuration.findStepDeclarer(stepName) == null) {
            boolean updated = false;
            for (VersionedDocument dom : configuration.getStepDOMs().values()) {
                CompositeStep compositeStep;
                List<String> childStepNames;
                Step step = (Step)dom.toBean();
                if (!(step instanceof CompositeStep) || !(childStepNames = (compositeStep = (CompositeStep)step).getChildStepNames()).contains(stepName)) continue;
                childStepNames.remove(stepName);
                dom.setWrapped(VersionedDocument.fromBean(compositeStep).getWrapped());
                updated = true;
            }
            if (updated) {
                Configuration reloaded = (Configuration)this.load(configuration.getId());
                reloaded.setStepDOMs(configuration.getStepDOMs());
                this.save(reloaded);
            }
            Query query = this.getSession().createQuery("select id, stepDOMs from Configuration where parent=:configuration");
            query.setParameter("configuration", (Object)configuration);
            List resultset = query.list();
            for (Object[] row : resultset) {
                Configuration child = new Configuration();
                child.setParent(configuration);
                child.setId((Long)row[0]);
                child.setStepDOMs((LinkedHashMap)row[1]);
                this.removeStepReferences(child, stepName);
            }
        }
    }

    @SessionAware
    public void updateStepReferences(Configuration configuration, String oldStepName, String newStepName) {
        if (configuration.getStepDOMs().containsKey(oldStepName)) {
            return;
        }
        boolean updated = false;
        for (VersionedDocument dom : configuration.getStepDOMs().values()) {
            CompositeStep compositeStep;
            List<String> childStepNames;
            Step step = (Step)dom.toBean();
            if (!(step instanceof CompositeStep) || !(childStepNames = (compositeStep = (CompositeStep)step).getChildStepNames()).contains(oldStepName)) continue;
            if (childStepNames instanceof Set) {
                childStepNames.remove(oldStepName);
                childStepNames.add(newStepName);
            } else if (childStepNames instanceof List) {
                List<String> listOfStepNames = childStepNames;
                int index = listOfStepNames.indexOf(oldStepName);
                listOfStepNames.remove(index);
                if (!listOfStepNames.contains(newStepName)) {
                    listOfStepNames.add(index, newStepName);
                }
            } else {
                throw new QuickbuildException("Unexpected collection type of child step names: " + childStepNames.getClass().getName());
            }
            dom.setWrapped(VersionedDocument.fromBean(compositeStep).getWrapped());
            updated = true;
        }
        if (updated) {
            Configuration reloaded = (Configuration)this.load(configuration.getId());
            reloaded.setStepDOMs(configuration.getStepDOMs());
            this.save(reloaded);
        }
        Query query = this.getSession().createQuery("select id, stepDOMs from Configuration where parent=:configuration");
        query.setParameter("configuration", (Object)configuration);
        List resultset = query.list();
        for (Object[] row : resultset) {
            Configuration child = new Configuration();
            child.setParent(configuration);
            child.setId((Long)row[0]);
            child.setStepDOMs((LinkedHashMap)row[1]);
            this.updateStepReferences(child, oldStepName, newStepName);
        }
    }

    @SessionAware
    public void updateRepositoryReferences(Configuration configuration, String oldRepositoryName, String newRepositoryName) {
        if (configuration.getRepositoryDOMs().containsKey(oldRepositoryName)) {
            return;
        }
        boolean updated = false;
        for (VersionedDocument dom : configuration.getStepDOMs().values()) {
            RepositoryStep repositoryStep;
            Step step = (Step)dom.toBean();
            if (!(step instanceof RepositoryStep) || !oldRepositoryName.equals((repositoryStep = (RepositoryStep)step).getRepositoryName())) continue;
            repositoryStep.setRepositoryName(newRepositoryName);
            dom.setWrapped(VersionedDocument.fromBean(repositoryStep).getWrapped());
            updated = true;
        }
        if (updated) {
            Configuration reloaded = (Configuration)this.load(configuration.getId());
            reloaded.setStepDOMs(configuration.getStepDOMs());
            this.save(reloaded);
        }
        Query query = this.getSession().createQuery("select id, repositoryDOMs, stepDOMs from Configuration where parent=:configuration");
        query.setParameter("configuration", (Object)configuration);
        List resultset = query.list();
        for (Object[] row : resultset) {
            Configuration child = new Configuration();
            child.setParent(configuration);
            child.setId((Long)row[0]);
            child.setRepositoryDOMs((LinkedHashMap)row[1]);
            child.setStepDOMs((LinkedHashMap)row[2]);
            this.updateRepositoryReferences(child, oldRepositoryName, newRepositoryName);
        }
    }

    @Override
    @SessionAware
    public void saveRepository(Configuration configuration, Repository<?> repository, String oldRepositoryName) {
        VersionedDocument dom = VersionedDocument.fromBean(repository);
        if (configuration.getRepositoryDOMs().containsKey(oldRepositoryName)) {
            configuration.getRepositoryDOMs().remove(oldRepositoryName);
            if (!oldRepositoryName.equals(repository.getName())) {
                this.updateRepositoryReferences(configuration, oldRepositoryName, repository.getName());
            }
        }
        configuration.getRepositoryDOMs().put(repository.getName(), dom);
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setRepositoryDOMs(configuration.getRepositoryDOMs());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void saveAggregation(Configuration configuration, Aggregation aggregation, String oldAggregationName) {
        VersionedDocument dom = VersionedDocument.fromBean(aggregation);
        configuration.getAggregationDOMs().remove(oldAggregationName);
        configuration.getAggregationDOMs().put(aggregation.getName(), dom);
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setAggregationDOMs(configuration.getAggregationDOMs());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void saveStep(Configuration configuration, Step step, String oldStepName) {
        VersionedDocument dom = VersionedDocument.fromBean(step);
        if (configuration.getStepDOMs().containsKey(oldStepName)) {
            configuration.getStepDOMs().remove(oldStepName);
            if (!oldStepName.equals(step.getName())) {
                this.updateStepReferences(configuration, oldStepName, step.getName());
            }
        }
        configuration.getStepDOMs().put(step.getName(), dom);
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        reloaded.setStepDOMs(configuration.getStepDOMs());
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public void saveRepository(Long configurationId, Repository<?> repository) {
        if (Bootstrap.isServer()) {
            Configuration configuration = (Configuration)this.load(configurationId);
            if (configuration.getRepositoryDOMs().containsKey(repository.getName())) {
                VersionedDocument dom = VersionedDocument.fromBean(repository);
                configuration.getRepositoryDOMs().put(repository.getName(), dom);
                this.save(configuration);
            }
        } else {
            Quickbuild.getServerService().repositoryMigrated(configurationId, SerializationHelper.serialize(repository));
        }
    }

    @Override
    @SessionAware
    public void saveAggregation(Long configurationId, Aggregation aggregation) {
        Validate.isTrue((boolean)Bootstrap.isServer());
        Configuration configuration = (Configuration)this.load(configurationId);
        if (configuration.getAggregationDOMs().containsKey(aggregation.getName())) {
            VersionedDocument dom = VersionedDocument.fromBean(aggregation);
            configuration.getAggregationDOMs().put(aggregation.getName(), dom);
            this.save(configuration);
        }
    }

    @Override
    @SessionAware
    public void saveStep(Long configurationId, Step step) {
        if (Bootstrap.isServer()) {
            Configuration configuration = (Configuration)this.load(configurationId);
            if (configuration.getStepDOMs().containsKey(step.getName())) {
                VersionedDocument dom = VersionedDocument.fromBean(step);
                configuration.getStepDOMs().put(step.getName(), dom);
                this.save(configuration);
            }
        } else {
            Quickbuild.getServerService().stepMigrated(configurationId, SerializationHelper.serialize(step));
        }
    }

    @Override
    @SessionAware
    public int getAverageDuration(Long configurationId, Date from, Date to) {
        Double duration;
        Criteria criteria = this.getSession().createCriteria(Build.class);
        criteria.setProjection((Projection)Projections.avg((String)"duration"));
        criteria.add((Criterion)Restrictions.eq((String)"configuration.id", (Object)configurationId));
        criteria.add(Restrictions.isNotNull((String)"duration"));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.CANCELLED))));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.TIMEOUT))));
        if (from != null) {
            criteria.add((Criterion)Restrictions.ge((String)"beginDate", (Object)from));
        }
        if (to != null) {
            criteria.add((Criterion)Restrictions.le((String)"beginDate", (Object)to));
        }
        if ((duration = (Double)criteria.uniqueResult()) != null) {
            return duration.intValue();
        }
        return -1;
    }

    @Override
    @SessionAware
    public int getSuccessRate(Long configurationId, Date from, Date to) {
        int failedBuilds;
        Criteria criteria = this.getSession().createCriteria(Build.class);
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)"configuration.id", (Object)configurationId));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.SUCCESSFUL)), (Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.RECOMMENDED))));
        if (from != null) {
            criteria.add((Criterion)Restrictions.ge((String)"beginDate", (Object)from));
        }
        if (to != null) {
            criteria.add((Criterion)Restrictions.le((String)"beginDate", (Object)to));
        }
        int successfulBuilds = ((Long)criteria.uniqueResult()).intValue();
        criteria = this.getSession().createCriteria(Build.class);
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)"configuration.id", (Object)configurationId));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.FAILED)));
        if (from != null) {
            criteria.add((Criterion)Restrictions.ge((String)"beginDate", (Object)from));
        }
        if (to != null) {
            criteria.add((Criterion)Restrictions.le((String)"beginDate", (Object)to));
        }
        if (successfulBuilds + (failedBuilds = ((Long)criteria.uniqueResult()).intValue()) != 0) {
            return successfulBuilds * 100 / (successfulBuilds + failedBuilds);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveVariable(Configuration configuration, String varName, String varValue) {
        if (Bootstrap.isServer()) {
            Lock lock = LockUtils.lock("variable: " + configuration.getId());
            try {
                this.internalSaveVariable(configuration, varName, varValue);
            }
            finally {
                lock.unlock();
            }
        } else {
            Quickbuild.getServerService().saveVariable(configuration.getId(), varName, varValue);
        }
    }

    @SessionAware
    protected void internalSaveVariable(Configuration configuration, String varName, String varValue) {
        Configuration reloaded = (Configuration)this.load(configuration.getId());
        for (Variable each : reloaded.getVariables()) {
            if (!each.getName().equals(varName)) continue;
            each.setValue(varValue);
        }
        this.save(reloaded);
    }

    @Override
    @SessionAware
    public Collection<Configuration> getChildren(Configuration parent) {
        Query query = this.getSession().createQuery("from Configuration where parent=:parent");
        query.setParameter("parent", (Object)parent);
        return query.list();
    }

    @Override
    @SessionAware
    public Collection<Configuration> getDescendents(Configuration parent) {
        ArrayList<Configuration> descendents = new ArrayList<Configuration>();
        for (Configuration child : this.getChildren(parent)) {
            descendents.add(child);
            descendents.addAll(this.getDescendents(child));
        }
        return descendents;
    }
}

