/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Singleton;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.grid.cloud.TestInfo;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.util.HashSet;
import java.util.UUID;
import javax.transaction.Synchronization;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultCloudProfileManager
extends AbstractEntityManager<CloudProfile>
implements CloudProfileManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCloudProfileManager.class);

    @Override
    @SessionAware(transactional=true)
    public void save(final CloudProfile cloudProfile) {
        super.save(cloudProfile);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.cloudProfileSaved(cloudProfile);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final CloudProfile cloudProfile) {
        this.getSession().buildLockRequest(new LockOptions(LockMode.NONE)).lock((Object)cloudProfile);
        logger.info("Deleting cloud profile '{}'...", (Object)cloudProfile.getName());
        HashSet<String> nodeAddressesInUse = new HashSet<String>();
        for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
            for (StepRuntime runtime : request.getBuild().getStepRuntimes().values()) {
                if (runtime.getStatus() != StepRuntime.Status.RUNNING) continue;
                nodeAddressesInUse.add(runtime.getNodeAddress());
            }
        }
        for (Token token : cloudProfile.getTokens()) {
            if (nodeAddressesInUse.contains(token.getAddress())) {
                throw new QuickbuildException("Unable to delete profile as its launched node '" + token.getAddress() + "' is still being used by builds.");
            }
            logger.info("Terminating launched node '{}' of this profile...", (Object)token.getAddress());
            cloudProfile.getNodeLauncher().terminateNode(token.getNodeLaunchId());
            TokenManager.instance.delete(token);
        }
        super.delete(cloudProfile);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    CacheManager.instance.cloudProfileRemoved(cloudProfile.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public CloudProfile get(String name) {
        Session session = this.getSession();
        Query query = session.createQuery("from CloudProfile profile where profile.name=:name");
        query.setParameter("name", (Object)name);
        query.setCacheable(true);
        return (CloudProfile)query.uniqueResult();
    }

    @Override
    public CloudProfile copyAsNew(CloudProfile cloudProfile) {
        CloudProfile newCloudProfile = (CloudProfile)BeanUtils.clone(cloudProfile);
        newCloudProfile.setId(null);
        return newCloudProfile;
    }

    @Override
    public void testLaunch(CloudProfile cloudProfile) {
        try {
            TestInfo testInfo = new TestInfo();
            try {
                logger.info("Running test launch for profile '" + cloudProfile.getName() + "'...");
                Token token = new Token();
                token.setHostName("Unknown");
                token.setPort(0);
                token.setIp(UUID.randomUUID().toString());
                token.setCloudProfile(cloudProfile);
                token.setTest(true);
                token.setValue(UUID.randomUUID().toString());
                testInfo.setTestToken(token.getValue());
                String userData = "<$CloudNodeUserData$>" + token.getValue();
                token.setNodeLaunchId(cloudProfile.getNodeLauncher().launchNode(userData));
                TokenManager.instance.save(token);
            }
            catch (Exception e) {
                logger.error("Error running test launch for profile '" + cloudProfile.getName() + "'.", (Throwable)e);
                testInfo.setErrorMessage(ExceptionUtils.extractImportantMessage(e));
            }
            cloudProfile.setTestInfo(testInfo);
            this.save(cloudProfile);
        }
        catch (Exception e) {
            logger.error("Error saving cloud profile '" + cloudProfile.getName() + "'.", (Throwable)e);
        }
    }
}

