/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.extensionpoint.ActionListener;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.setting.configuration.buildcleanup.BuildCleanupStrategy;
import com.pmease.quickbuild.setting.configuration.buildcleanup.ReserveBuildsByCount;
import com.pmease.quickbuild.setting.configuration.buildcleanup.ReserveBuildsByDays;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultBuildManager
extends AbstractEntityManager<Build>
implements BuildManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBuildManager.class);
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ConfigurationManager configurationManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ScriptEngine scriptEngine;

    @Override
    @SessionAware
    public Build get(Configuration configuration, String version) {
        if (version.equals("latest")) {
            return this.getLatest(configuration);
        }
        if (version.equals("latest_finished")) {
            return this.getLatestFinished(configuration);
        }
        if (Build.RESERVED_VERSIONS.contains(version)) {
            return this.getLatest(configuration, Build.Status.valueOf(StringUtils.substringAfter((String)version, (String)"_").toUpperCase()));
        }
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and version=:version order by id desc");
        query.setParameter("configurationId", (Object)configuration.getId());
        query.setParameter("version", (Object)version);
        List result = query.list();
        return result.isEmpty() ? null : result.get(0);
    }

    @Override
    @SessionAware
    public Build getLatestFinished(Configuration configuration) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and status!=:running order by id desc");
        query.setParameter("configurationId", (Object)configuration.getId());
        query.setParameter("running", (Object)Build.Status.RUNNING);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getFirst(Configuration configuration) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId order by id");
        query.setParameter("configurationId", (Object)configuration.getId());
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getNext(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id > :id order by id");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("id", (Object)build.getId());
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getPrevious(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id < :id order by id desc");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("id", (Object)HibernateUtils.getId(build));
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getPrevious(Build build, String shortBranch) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and shortBranch=:shortBranch and id < :id order by id desc");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("shortBranch", (Object)shortBranch);
        query.setParameter("id", (Object)HibernateUtils.getId(build));
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getNextSuccessful(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id>:id and (status=:successful or status=:recommended) order by id");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("id", (Object)build.getId());
        query.setParameter("successful", (Object)Build.Status.SUCCESSFUL);
        query.setParameter("recommended", (Object)Build.Status.RECOMMENDED);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getPreviousSuccessful(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id<:id and (status=:successful or status=:recommended) order by id desc");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("id", (Object)build.getId());
        query.setParameter("successful", (Object)Build.Status.SUCCESSFUL);
        query.setParameter("recommended", (Object)Build.Status.RECOMMENDED);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getPreviousRecommended(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id<:id and status=:recommended order by id desc");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("id", (Object)build.getId());
        query.setParameter("recommended", (Object)Build.Status.RECOMMENDED);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getLatest(Configuration configuration) {
        return this.getLatest(configuration, null);
    }

    @Override
    public void delete(Build build) {
        this.delete(build, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(final Build build, boolean asResultOfConfigurationRemoval) {
        logger.debug("Deleting build (id: {}, version: {})...", (Object)build.getId(), (Object)build.getVersion());
        List<ActionListener> listeners = this.pluginManager.getExtensions(ActionListener.class);
        for (ActionListener each : listeners) {
            each.removeBuild(build, asResultOfConfigurationRemoval);
        }
        logger.trace("Deleting build publish directory '" + build.getPublishDir().getAbsolutePath() + "'...");
        build.getConfiguration().findArtifactStorage().cleanupArtifacts(build, null);
        logger.trace("Removing promotion source constraints from database...");
        Session session = SessionManager.openSession();
        Transaction tx = session.beginTransaction();
        try {
            Query query = session.createQuery("update Build set promotedFrom=null where promotedFrom=:build");
            query.setParameter("build", (Object)build);
            query.executeUpdate();
            tx.commit();
        }
        catch (Throwable t) {
            tx.rollback();
            throw ExceptionUtils.wrapAsUnchecked(t);
        }
        finally {
            SessionManager.closeSession();
        }
        logger.trace("Removing build record from database...");
        session = SessionManager.openSession();
        tx = session.beginTransaction();
        if (!asResultOfConfigurationRemoval) {
            tx.registerSynchronization(new Synchronization(){

                public void afterCompletion(int status) {
                    if (status == 3) {
                        DefaultBuildManager.this.cacheManager.buildRemoved(build);
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        try {
            session.delete((Object)build);
            session.flush();
            tx.commit();
        }
        catch (Throwable t) {
            tx.rollback();
            throw ExceptionUtils.wrapAsUnchecked(t);
        }
        finally {
            SessionManager.closeSession();
        }
        String onDeletionScript = build.getConfiguration().findOnBuildDeletionScript();
        if (onDeletionScript != null) {
            Context.push(build);
            try {
                logger.trace("Executing on build deletion script...");
                this.scriptEngine.evaluate(onDeletionScript, Context.buildEvalContext(build, null));
            }
            finally {
                Context.pop();
            }
        }
        logger.trace("Build has been deleted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBuildsBefore(Configuration configuration, Date date) {
        Session session = SessionManager.openSession();
        try {
            Query query = session.createQuery("from Build where configuration=:configuration and beginDate<:date");
            query.setParameter("configuration", (Object)configuration);
            query.setParameter("date", (Object)date);
            for (Build build : query.list()) {
                this.delete(build);
            }
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reserveBuildsByCount(Configuration configuration, int reserveCount) {
        Session session = SessionManager.openSession();
        try {
            ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
            criterions.add(Restrictions.eq((String)"configuration", (Object)configuration));
            long count = this.count(new SearchCriteria(criterions.toArray(new Criterion[criterions.size()]), new Order[0]));
            if (count > (long)reserveCount) {
                Query query = session.createQuery("from Build where configuration=:configuration order by id");
                query.setParameter("configuration", (Object)configuration);
                query.setFirstResult(0);
                query.setMaxResults((int)count - reserveCount);
                for (Build build : query.list()) {
                    this.delete(build);
                }
            }
        }
        finally {
            SessionManager.closeSession();
        }
    }

    @Override
    @SessionAware
    public Build getPreviousFinished(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id<:id and status!=:running order by id desc");
        query.setParameter("configurationId", (Object)build.getConfiguration().getId());
        query.setParameter("id", (Object)build.getId());
        query.setParameter("running", (Object)Build.Status.RUNNING);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Build build) {
        final boolean isNew = build.isNew();
        super.save(build);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultBuildManager.this.cacheManager.buildSaved(build, isNew);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public Build getLatest(Configuration configuration, Build.Status status) {
        Query query;
        Session session = this.getSession();
        if (status != null) {
            if (status == Build.Status.SUCCESSFUL) {
                query = session.createQuery("from Build where configuration.id=:configurationId and (status=:successful or status=:recommended) order by id desc");
                query.setParameter("successful", (Object)Build.Status.SUCCESSFUL);
                query.setParameter("recommended", (Object)Build.Status.RECOMMENDED);
            } else {
                query = session.createQuery("from Build where configuration.id=:configurationId and status=:status order by id desc");
                query.setParameter("status", (Object)status);
            }
        } else {
            query = session.createQuery("from Build where configuration.id=:configurationId order by id desc");
        }
        query.setParameter("configurationId", (Object)configuration.getId());
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public Build getLatest(Configuration configuration, Build.Status status, String shortBranch) {
        Query query;
        Session session = this.getSession();
        if (status != null) {
            if (status == Build.Status.SUCCESSFUL) {
                query = session.createQuery("from Build where configuration.id=:configurationId and shortBranch=:shortBranch and (status=:successful or status=:recommended) order by id desc");
                query.setParameter("successful", (Object)Build.Status.SUCCESSFUL);
                query.setParameter("recommended", (Object)Build.Status.RECOMMENDED);
            } else {
                query = session.createQuery("from Build where configuration.id=:configurationId and shortBranch=:shortBranch and status=:status order by id desc");
                query.setParameter("status", (Object)status);
            }
        } else {
            query = session.createQuery("from Build where configuration.id=:configurationId and shortBranch=:shortBranch order by id desc");
        }
        query.setParameter("configurationId", (Object)configuration.getId());
        query.setParameter("shortBranch", (Object)shortBranch);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware(transactional=true)
    public void move(List<Long> buildIds, Configuration configuration) {
        Session session = this.getSession();
        final HashMap<Build, Long> moves = new HashMap<Build, Long>();
        for (Long id : buildIds) {
            Query query = session.createQuery("select configuration.id from Build where id=:id");
            query.setParameter("id", (Object)id);
            Long oldConfigurationId = (Long)query.uniqueResult();
            query = session.createQuery("update Build set configuration=:configuration where id=:id");
            query.setParameter("configuration", (Object)configuration);
            query.setParameter("id", (Object)id);
            query.executeUpdate();
            Build build = new Build();
            build.setId(id);
            build.setConfiguration(configuration);
            moves.put(build, oldConfigurationId);
        }
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    for (Map.Entry entry : moves.entrySet()) {
                        DefaultBuildManager.this.cacheManager.buildMoved((Build)entry.getKey(), (Long)entry.getValue());
                    }
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void move(final Build build, Configuration configuration) {
        final Long oldConfigurationId = build.getConfiguration().getId();
        build.setConfiguration(configuration);
        this.save(build);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultBuildManager.this.cacheManager.buildMoved(build, oldConfigurationId);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public Build.Status getStatus(Long buildId) {
        Session session = this.getSession();
        Query query = session.createQuery("select status from Build where id=:buildId");
        query.setParameter("buildId", (Object)buildId);
        return (Build.Status)((Object)query.uniqueResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Configuration configuration, String version) {
        Session session = SessionManager.openSession();
        try {
            Query query = session.createQuery("from Build where configuration.id=:configurationId and version=:version");
            query.setParameter("configurationId", (Object)configuration.getId());
            query.setParameter("version", (Object)version);
            for (Build build : query.list()) {
                this.delete(build);
            }
        }
        finally {
            SessionManager.closeSession();
        }
    }

    @Override
    public Build get(String name) {
        int pos = name.indexOf(46);
        Validate.isTrue((pos != -1 ? 1 : 0) != 0);
        Long configurationId = Long.valueOf(name.substring(0, pos));
        Configuration configuration = (Configuration)this.configurationManager.load(configurationId);
        String version = StringUtils.substringAfter((String)name, (String)".");
        return this.get(configuration, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maintain() {
        for (Configuration configuration : this.configurationManager.getAll(null)) {
            Context.push(configuration);
            try {
                String interpolated;
                BuildCleanupStrategy cleanupStrategy = configuration.findBuildCleanupStrategy();
                if (cleanupStrategy instanceof ReserveBuildsByDays) {
                    logger.info("Removing unwanted builds of configuration '{}'...", (Object)configuration.getPathName());
                    ReserveBuildsByDays reserveByDays = (ReserveBuildsByDays)cleanupStrategy;
                    interpolated = ScriptEngine.instance.interpolate(reserveByDays.getReserveDays(), Context.buildEvalContext(null, null));
                    long reserveMillis = 86400000L * Long.parseLong(interpolated);
                    if (reserveMillis == 0L) continue;
                    this.removeBuildsBefore(configuration, new Date(System.currentTimeMillis() - reserveMillis));
                    continue;
                }
                if (!(cleanupStrategy instanceof ReserveBuildsByCount)) continue;
                logger.info("Removing unwanted builds of configuration '{}'...", (Object)configuration.getPathName());
                ReserveBuildsByCount reserveByCount = (ReserveBuildsByCount)cleanupStrategy;
                interpolated = ScriptEngine.instance.interpolate(reserveByCount.getReserveCount(), Context.buildEvalContext(null, null));
                int reserveCount = Integer.parseInt(interpolated);
                if (reserveCount == 0) continue;
                this.reserveBuildsByCount(configuration, reserveCount);
            }
            catch (Exception e) {
                logger.error("Error running cleanup for configuration '" + configuration.getPathName() + "'.", (Throwable)e);
            }
            finally {
                Context.pop();
            }
        }
    }

    @Override
    @SessionAware
    public List<Build> getBuilds(Configuration configuration) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration=:configuration order by id");
        query.setParameter("configuration", (Object)configuration);
        return query.list();
    }

    @Override
    @SessionAware
    public Build getPromotedTo(Build build) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where promotedFrom=:build order by id desc");
        query.setParameter("build", (Object)build);
        query.setMaxResults(1);
        return (Build)query.uniqueResult();
    }

    @Override
    @SessionAware
    public List<Build> getBuildsBetween(Build from, Build to) {
        Session session = this.getSession();
        Query query = session.createQuery("from Build where configuration.id=:configurationId and id>:fromId and id<:toId order by id desc");
        query.setParameter("configurationId", (Object)to.getConfiguration().getId());
        query.setParameter("toId", (Object)to.getId());
        query.setParameter("fromId", (Object)from.getId());
        return query.list();
    }
}

