/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.AuthorizationManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.Synchronization;

@Singleton
public class DefaultAuthorizationManager
extends AbstractEntityManager<Authorization>
implements AuthorizationManager {
    @Inject
    private CacheManager cacheManager;

    @Override
    @SessionAware(transactional=true)
    public void delete(final Authorization authorization) {
        super.delete(authorization);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultAuthorizationManager.this.cacheManager.authorizationRemoved(authorization.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void save(final Authorization authorization) {
        super.save(authorization);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultAuthorizationManager.this.cacheManager.authorizationSaved(authorization);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void authorize(Group group, Collection<Authorization> authorizations) {
        boolean found;
        Iterator<Authorization> it = group.getAuthorizations().iterator();
        while (it.hasNext()) {
            Authorization authorization = it.next();
            found = false;
            for (Authorization newAuthorization : authorizations) {
                if (!newAuthorization.getConfiguration().getId().equals(authorization.getConfiguration().getId())) continue;
                found = true;
                authorization.setPermissions(new ArrayList<String>(newAuthorization.getPermissions()));
                this.save(authorization);
            }
            if (found) continue;
            it.remove();
            this.delete(authorization);
        }
        for (Authorization newAuthorization : authorizations) {
            found = false;
            for (Authorization authorization : group.getAuthorizations()) {
                if (!authorization.getConfiguration().getId().equals(newAuthorization.getConfiguration().getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Authorization authorization = new Authorization();
            authorization.setConfiguration(newAuthorization.getConfiguration());
            authorization.setGroup(group);
            authorization.setPermissions(new ArrayList<String>(newAuthorization.getPermissions()));
            group.getAuthorizations().add(authorization);
            this.save(authorization);
        }
    }

    @Override
    @SessionAware(transactional=true)
    public void authorize(Configuration configuration, Collection<Authorization> authorizations) {
        boolean found;
        Iterator<Authorization> it = configuration.getAuthorizations().iterator();
        while (it.hasNext()) {
            Authorization authorization = it.next();
            found = false;
            for (Authorization newAuthorization : authorizations) {
                if (!newAuthorization.getGroup().getId().equals(authorization.getGroup().getId())) continue;
                found = true;
                authorization.setPermissions(new ArrayList<String>(newAuthorization.getPermissions()));
                this.save(authorization);
            }
            if (found) continue;
            it.remove();
            this.delete(authorization);
        }
        for (Authorization newAuthorization : authorizations) {
            found = false;
            for (Authorization authorization : configuration.getAuthorizations()) {
                if (!authorization.getGroup().getId().equals(newAuthorization.getGroup().getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Authorization authorization = new Authorization();
            authorization.setConfiguration(configuration);
            authorization.setGroup(newAuthorization.getGroup());
            authorization.setPermissions(new ArrayList<String>(newAuthorization.getPermissions()));
            configuration.getAuthorizations().add(authorization);
            this.save(authorization);
        }
    }
}

