/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.model.Audit;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import java.util.Date;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAuditManager
extends AbstractEntityManager<Audit>
implements AuditManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuditManager.class);

    @Override
    public void audit(String userName, String source, String action, String content, String previousContent) {
        if (content != null && Objects.equal((Object)content, (Object)previousContent)) {
            return;
        }
        Preconditions.checkNotNull((Object)source, (Object)"Event source should not be empty.");
        Preconditions.checkNotNull((Object)action, (Object)"Event action should not be empty.");
        Audit audit = new Audit();
        if (userName == null) {
            User u = Context.getUser();
            if (u != null) {
                audit.setUser(u.getDisplayName());
            } else {
                audit.setUser("Anonymous");
            }
        } else {
            audit.setUser(userName);
        }
        audit.setSource(source);
        audit.setAction(action);
        audit.setContent(content);
        audit.setPreviousContent(previousContent);
        audit.setTimestamp(new Date());
        this.save(audit);
    }

    @Override
    public void audit(String source, String action) {
        this.audit(source, action, null, null);
    }

    @Override
    public void audit(Configuration configuration, String action, String content, String previousContent) {
        this.audit(configuration.getPathName() + "/", action, content, previousContent);
    }

    @Override
    public void audit(Configuration configuration, String action) {
        this.audit(configuration, action, null, null);
    }

    @Override
    @SessionAware
    public void maintain() {
        logger.info("Removing obsolete audit entries.");
        int auditPreserveDays = CacheManager.instance.getSystemSetting().getAuditPreserveDays();
        long reserveMillis = (long)auditPreserveDays * 24L * 3600L * 1000L;
        Query query = this.getSession().createQuery("delete from Audit where timestamp<:date");
        query.setParameter("date", (Object)new Date(System.currentTimeMillis() - reserveMillis));
        query.executeUpdate();
    }

    @Override
    public void audit(String source, String action, String content, String previousContent) {
        this.audit(null, source, action, content, previousContent);
    }
}

