/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.event.NodeAlertEvent;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.RingBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAlertManager
extends AbstractEntityManager<Alert>
implements AlertManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAlertManager.class);
    @Inject
    private PluginManager pluginManager;
    private final ListeningExecutorService executor;
    private final AlertRingBuffer ringBuffer;
    private final Monitor monitor = new Monitor();
    private static final int MAX_ALERT_SIZE = 2048;

    DefaultAlertManager() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("alert-notification-handler-%d").setPriority(5).build();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(2048), tf));
        this.ringBuffer = new AlertRingBuffer(4096);
    }

    @Override
    public void start() {
        List<Alert> last = this.getLastN(2048);
        this.addToCache(last);
    }

    @SessionAware
    public List<Alert> getLastN(int n) {
        Criteria criteria = this.getSession().createCriteria(Alert.class);
        criteria.addOrder(Order.desc((String)"ctime"));
        criteria.setMaxResults(1024);
        return criteria.list();
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public void publish(final NodeAlertEvent event) {
        this.addToCache(event.getAlerts());
        ListenableFuture future = this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Notifier notifier : DefaultAlertManager.this.pluginManager.getExtensions(Notifier.class)) {
                    try {
                        notifier.notify(event);
                    }
                    catch (Throwable e) {
                        logger.error("Failed post node alert event [" + event + "] to notifier " + Joiner.on((String)", ").join(notifier.getChannelNames()));
                    }
                }
                return null;
            }
        });
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                logger.debug("Post node alert event successfully.");
            }

            public void onFailure(Throwable t) {
                logger.error("Failed post node alert event [" + event + "].");
            }
        });
    }

    @Override
    @SessionAware
    public void alert(Alert alert) {
        this.save(alert);
        this.publish(new NodeAlertEvent(Collections.singletonList(alert)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Alert> getLastNFromCache(int n) {
        this.monitor.enter();
        try {
            List alerts = this.ringBuffer.getLastN(n);
            ArrayList actual = Lists.newArrayList();
            for (Alert each : alerts) {
                if (Strings.isNullOrEmpty((String)each.getSubject())) continue;
                actual.add(each.clone());
            }
            ArrayList arrayList = actual;
            return arrayList;
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(List<Alert> alerts) {
        this.monitor.enter();
        try {
            this.ringBuffer.addAll(alerts);
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    @SessionAware
    public void maintain() {
        logger.info("Removing obsolete message entries.");
        int alertPreserveDays = CacheManager.instance.getAlertRetentionSetting().getPerserveDays();
        long reserveMillis = (long)alertPreserveDays * 24L * 3600L * 1000L;
        Query query = this.getSession().createQuery("delete from Alert where ctime<:date");
        query.setParameter("date", (Object)(System.currentTimeMillis() - reserveMillis));
        query.executeUpdate();
    }

    private static void flushAndClear(Session session) {
        session.flush();
        session.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(List<Alert> alerts) {
        Session session = SessionManager.openSession();
        try {
            Transaction tx = session.beginTransaction();
            int i = 0;
            for (Alert each : alerts) {
                session.saveOrUpdate((Object)each);
                if (++i % 200 != 0) continue;
                DefaultAlertManager.flushAndClear(session);
            }
            DefaultAlertManager.flushAndClear(session);
            tx.commit();
        }
        finally {
            SessionManager.closeSession();
        }
    }

    private static class AlertEventFactory
    implements RingBuffer.EventFactory<Alert> {
        private AlertEventFactory() {
        }

        @Override
        public Alert newInstance() {
            return new Alert();
        }
    }

    private static class AlertRingBuffer
    extends RingBuffer<Alert> {
        public AlertRingBuffer(int bufferSize) {
            super(new AlertEventFactory(), bufferSize);
        }

        public void add(Alert alert) {
            long seq = this.next();
            Alert entry = (Alert)this.get(seq);
            entry.copy(alert);
            this.publish(seq);
        }

        public void addAll(List<Alert> alerts) {
            if (alerts == null || alerts.isEmpty()) {
                return;
            }
            for (Alert each : alerts) {
                this.add(each);
            }
        }
    }
}

