/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.AlarmManager;
import com.pmease.quickbuild.entitymanager.impl.AbstractEntityManager;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.model.User;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Synchronization;

@Singleton
public class DefaultAlarmManager
extends AbstractEntityManager<Alarm>
implements AlarmManager {
    @Inject
    private CacheManager cacheManager;

    @Override
    @SessionAware(transactional=true)
    public void save(final Alarm alarm) {
        super.save(alarm);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultAlarmManager.this.cacheManager.alarmSaved(alarm);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(final Alarm alarm) {
        super.delete(alarm);
        this.getSession().getTransaction().registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    DefaultAlarmManager.this.cacheManager.alarmRemoved(alarm.getId());
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    @Override
    @SessionAware
    public Map<String, Set<User>> getNotifierUsers(Notifier notifier) {
        HashMap users = Maps.newHashMap();
        for (Alarm alarm : this.getAll()) {
            HashSet<User> notifierUsers = (HashSet<User>)users.get(alarm.getNotifier());
            if (notifierUsers == null) {
                notifierUsers = new HashSet<User>();
                users.put(alarm.getNotifier(), notifierUsers);
            }
            notifierUsers.add(alarm.getUser());
        }
        HashMap<String, Set<User>> notifierUsers = new HashMap<String, Set<User>>();
        for (String each : notifier.getChannelNames()) {
            Set channelUsers = (Set)users.get(each);
            if (channelUsers == null || channelUsers.isEmpty()) continue;
            notifierUsers.put(each, channelUsers);
        }
        return notifierUsers;
    }
}

