/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager.impl;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.entitymanager.EntityManager;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.persistence.SessionInterceptor;
import com.pmease.quickbuild.persistence.SessionManager;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

public abstract class AbstractEntityManager<T extends AbstractEntity>
implements EntityManager<T> {
    private Class<T> entityClass;

    public AbstractEntityManager() {
        ParameterizedType genericSuperClazz;
        block3: {
            Class<?> currentClass = this.getClass();
            do {
                Type superType;
                if ((superType = currentClass.getGenericSuperclass()) != null && superType instanceof ParameterizedType) {
                    genericSuperClazz = (ParameterizedType)superType;
                    if (genericSuperClazz.getRawType() != AbstractEntityManager.class) {
                        currentClass = currentClass.getSuperclass();
                        continue;
                    }
                    break block3;
                }
                currentClass = currentClass.getSuperclass();
            } while (currentClass != null);
            throw new RuntimeException("Failed to determine actual parameter type.");
        }
        this.entityClass = (Class)genericSuperClazz.getActualTypeArguments()[0];
    }

    @Override
    @SessionAware(transactional=true)
    public void delete(T entity) {
        Session session = this.getSession();
        session.delete(entity);
    }

    @Override
    @SessionAware
    public T load(Long id) {
        Session session = this.getSession();
        AbstractEntity entity = (AbstractEntity)session.load(this.entityClass, (Serializable)id);
        if (SessionManager.getSession() == null) {
            Hibernate.initialize((Object)entity);
        }
        return (T)entity;
    }

    @Override
    @SessionAware
    public T get(Long id) {
        Session session = this.getSession();
        return (T)((AbstractEntity)session.get(this.entityClass, (Serializable)id));
    }

    @Override
    @SessionAware(transactional=true)
    public void save(T entity) {
        this.getSession().saveOrUpdate(entity);
    }

    protected Session getSession() {
        Session session = SessionInterceptor.getSession();
        if (session == null) {
            throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
        }
        return session;
    }

    @Override
    @SessionAware
    public List<T> search(SearchCriteria searchCriteria, int first, int count) {
        return this.searchEntities(this.entityClass, searchCriteria, first, count);
    }

    @Override
    @SessionAware
    public List<Long> searchIds(SearchCriteria searchCriteria, int first, int count) {
        return this.searchEntityIds(this.entityClass, searchCriteria, first, count);
    }

    @Override
    @SessionAware
    public int count(SearchCriteria searchCriteria) {
        return this.countEntities(this.entityClass, searchCriteria);
    }

    @Override
    @SessionAware
    public int count() {
        return this.countEntities(this.entityClass, new SearchCriteria());
    }

    @Override
    @SessionAware
    public List<T> getAll(Order order) {
        SearchCriteria searchCriteria = new SearchCriteria();
        if (order != null) {
            searchCriteria.setOrders(new Order[]{order});
        }
        return this.search(searchCriteria, 0, 0);
    }

    @Override
    @SessionAware
    public List<T> getAll() {
        return this.getAll(null);
    }

    @SessionAware
    protected <T2 extends AbstractEntity> int countEntities(Class<T2> entityType, SearchCriteria searchCriteria) {
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(entityType);
        for (int i = 0; i < searchCriteria.getCriterions().length; ++i) {
            criteria.add(searchCriteria.getCriterions()[i]);
        }
        criteria.setProjection(Projections.rowCount());
        return ((Long)criteria.uniqueResult()).intValue();
    }

    @SessionAware
    protected <T2 extends AbstractEntity> List<T2> searchEntities(Class<T2> entityType, SearchCriteria searchCriteria, int first, int count) {
        int i;
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(entityType);
        for (i = 0; i < searchCriteria.getCriterions().length; ++i) {
            criteria.add(searchCriteria.getCriterions()[i]);
        }
        for (i = 0; i < searchCriteria.getOrders().length; ++i) {
            criteria.addOrder(searchCriteria.getOrders()[i]);
        }
        criteria.setFirstResult(first);
        if (count != 0) {
            criteria.setMaxResults(count);
        }
        return criteria.list();
    }

    @SessionAware
    protected <T2 extends AbstractEntity> List<Long> searchEntityIds(Class<T2> entityType, SearchCriteria searchCriteria, int first, int count) {
        int i;
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(entityType);
        for (i = 0; i < searchCriteria.getCriterions().length; ++i) {
            criteria.add(searchCriteria.getCriterions()[i]);
        }
        for (i = 0; i < searchCriteria.getOrders().length; ++i) {
            criteria.addOrder(searchCriteria.getOrders()[i]);
        }
        criteria.setFirstResult(first);
        if (count != 0) {
            criteria.setMaxResults(count);
        }
        criteria.setProjection((Projection)Projections.property((String)"id"));
        return criteria.list();
    }
}

