/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager;

import com.google.common.collect.Range;
import com.google.inject.ImplementedBy;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.impl.DefaultMeasurementDataManager;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.MeasurementData1D;
import com.pmease.quickbuild.model.MeasurementData1H;
import com.pmease.quickbuild.model.MeasurementData6H;
import java.util.List;
import org.hibernate.criterion.MatchMode;

@ImplementedBy(value=DefaultMeasurementDataManager.class)
public interface MeasurementDataManager {
    public static final MeasurementDataManager instance = Quickbuild.getInstance(MeasurementDataManager.class);

    public MeasurementData save(MeasurementData var1);

    public void save(List<MeasurementData> var1);

    public long getPollingInterval();

    public void clearAll();

    public long getMaxTimestamp(Class<? extends MeasurementData> var1);

    public long getMinTimestamp(Class<? extends MeasurementData> var1);

    public long getLastTimestamp(String var1);

    public List<MeasurementData> find(Class<? extends MeasurementData> var1, SearchCriteria var2, int var3, int var4);

    public List<MeasurementData> find(Class<? extends MeasurementData> var1, SearchCriteria var2);

    public List<MeasurementData> find(Range<Long> var1, String var2);

    public List<MeasurementData> find(TableType var1, Range<Long> var2, String var3, String var4);

    public List<MeasurementData> find(TableType var1, Range<Long> var2, String var3, String var4, MatchMode var5);

    public List<MeasurementData> find(Range<Long> var1, String var2, String var3, MatchMode var4);

    public List<MeasurementData> find(TableType var1, Range<Long> var2, Long var3, SearchCriteria var4);

    public List<MeasurementData> find(TableType var1, Range<Long> var2, SearchCriteria var3);

    public static enum TableType {
        RAW(MeasurementData.class, 300000L),
        ONE_HOUR(MeasurementData1H.class, 3600000L),
        SIX_HOURS(MeasurementData6H.class, 21600000L),
        ONE_DAY(MeasurementData1D.class, 86400000L);

        final Class<? extends MeasurementData> tableClass;
        final long interval;

        private TableType(Class<? extends MeasurementData> tableClass, long interval) {
            this.tableClass = tableClass;
            this.interval = interval;
        }

        public Class<? extends MeasurementData> getTableClass() {
            return this.tableClass;
        }

        public long getInterval() {
            return this.interval;
        }
    }
}

