/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager;

import com.google.inject.ImplementedBy;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.EntityManager;
import com.pmease.quickbuild.entitymanager.impl.DefaultConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.stepsupport.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;

@ScriptApi(value="This interface provides configuration management functionalities.")
@ImplementedBy(value=DefaultConfigurationManager.class)
public interface ConfigurationManager
extends EntityManager<Configuration> {
    public static final ConfigurationManager instance = Quickbuild.getInstance(ConfigurationManager.class);

    @ScriptApi(value="Get configuration by parent and name. Null will be returned if not found.")
    public Configuration get(Configuration var1, String var2);

    @ScriptApi(value="Get configuration by path name. Null will be returned if not found.")
    public Configuration get(String var1);

    public Long getId(String var1);

    public void saveStatus(Configuration var1, String var2, Date var3);

    public void saveData(Configuration var1, LinkedHashMap<String, Serializable> var2);

    public void saveShortBranches(Configuration var1, ArrayList<ShortBranch> var2);

    public void saveVersionManager(Configuration var1, VersionedDocument var2);

    public void refreshVersionManager(Configuration var1);

    public void saveVariables(Configuration var1);

    public void saveVariable(Configuration var1, String var2, String var3);

    public void saveNotifications(Configuration var1);

    public void savePromotions(Configuration var1);

    @ScriptApi(value="Save schedule of the configuration.")
    public void saveSchedule(Configuration var1);

    public void saveActiveRepository(Configuration var1);

    public Configuration copyAsNew(Configuration var1, boolean var2);

    public void copyChildren(Configuration var1, Configuration var2);

    public void deleteStep(Configuration var1, String var2);

    public void deleteRepository(Configuration var1, String var2);

    public void deleteAggregation(Configuration var1, String var2);

    public void saveStep(Configuration var1, Step var2, String var3);

    public void saveRepository(Configuration var1, Repository<?> var2, String var3);

    public void saveAggregation(Configuration var1, Aggregation var2, String var3);

    public void saveRepository(Long var1, Repository<?> var2);

    public void saveAggregation(Long var1, Aggregation var2);

    public void saveStep(Long var1, Step var2);

    public int getSuccessRate(Long var1, Date var2, Date var3);

    public int getAverageDuration(Long var1, Date var2, Date var3);

    @ScriptApi(value="Get direct child configurations of specified configuration.")
    public Collection<Configuration> getChildren(Configuration var1);

    @ScriptApi(value="Get all descendent configurations of specified configuration.")
    public Collection<Configuration> getDescendents(Configuration var1);
}

