/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.entitymanager;

import com.google.inject.ImplementedBy;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.EntityManager;
import com.pmease.quickbuild.entitymanager.impl.DefaultBuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import java.util.Date;
import java.util.List;

@ImplementedBy(value=DefaultBuildManager.class)
@ScriptApi(value="This interface handles loading of build object.")
public interface BuildManager
extends EntityManager<Build> {
    public static final BuildManager instance = Quickbuild.getInstance(BuildManager.class);

    @ScriptApi(value="Get build of specified version in specified configuration. <em>null</em> will be returned if not found.")
    public Build get(Configuration var1, String var2);

    @ScriptApi(value="Get latest build of specified status in specified configuration. <em>null</em> will be returned if not found.")
    public Build getLatest(Configuration var1, Build.Status var2);

    @ScriptApi(value="Get latest build of specified status and specified short branch in specified configuration. <em>null</em> will be returned if not found.")
    public Build getLatest(Configuration var1, Build.Status var2, String var3);

    @ScriptApi(value="Get latest build in specified configuration. Null will be returned if not found.")
    public Build getLatest(Configuration var1);

    public Build getPromotedTo(Build var1);

    @ScriptApi(value="Get latest finished build of specified configuration. Null will be returned if not found.")
    public Build getLatestFinished(Configuration var1);

    @ScriptApi(value="Get first build of specified configuration. Null will be returned if not found.")
    public Build getFirst(Configuration var1);

    @ScriptApi(value="Get next build of specified build. Null will be returned if not found.")
    public Build getNext(Build var1);

    @ScriptApi(value="Get previous build of specified build. Null will be returned if not found.")
    public Build getPrevious(Build var1);

    @ScriptApi(value="Get previous build of specified build and specified short branch. Null will be returned if not found.")
    public Build getPrevious(Build var1, String var2);

    @ScriptApi(value="Get previous finished build of specified build. Null will be returned if not found.")
    public Build getPreviousFinished(Build var1);

    @ScriptApi(value="Get previous successful build of specified build. Null will be returned if not found.")
    public Build getPreviousSuccessful(Build var1);

    public List<Build> getBuildsBetween(Build var1, Build var2);

    @ScriptApi(value="Get previous recommended build of specified build. Null will be returned if not found.")
    public Build getPreviousRecommended(Build var1);

    @ScriptApi(value="Get next successful build of specified build. Null will be returned if not found.")
    public Build getNextSuccessful(Build var1);

    public void removeBuildsBefore(Configuration var1, Date var2);

    public void reserveBuildsByCount(Configuration var1, int var2);

    public void delete(Configuration var1, String var2);

    public void move(List<Long> var1, Configuration var2);

    public void move(Build var1, Configuration var2);

    public Build.Status getStatus(Long var1);

    public Build get(String var1);

    public void delete(Build var1, boolean var2);

    public List<Build> getBuilds(Configuration var1);

    public void maintain();
}

