/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.dependency.DependencyResolver;
import com.pmease.quickbuild.dependency.DependencyRevision;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.rest.RestModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Editable(order=100, name="latest build (generate new if necessary)")
@ScriptApi(value="If there are new changes in dependency configuration, a new build will be generated and resolved as the dependency build; otherwise, the latest finished build will be resolved as dependency build.")
public class TriggerForLatestFinishedResolver
implements DependencyResolver {
    private static final long serialVersionUID = 1L;
    private QuickbuildRepository repository;
    private List<Property> variables = new ArrayList<Property>();

    public TriggerForLatestFinishedResolver(QuickbuildRepository repository) {
        this.repository = repository;
    }

    @Editable(order=300, description="Define variables to be used when trigger the dependency configuration. Please note that variables defined here will override variables defined in the dependency configuration.")
    @ScriptApi(value="Get variables passed to dependency configuration when it runs to generate new dependency build.")
    public List<Property> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Property> variables) {
        this.variables = variables;
    }

    @ScriptApi(value="Get the repository object")
    public QuickbuildRepository getRepository() {
        return this.repository;
    }

    @Override
    public DependencyRevision getDependency() {
        BuildRequest currentRequest = Context.getRequest();
        HashMap<String, String> variableMap = new HashMap<String, String>();
        for (Property property : this.getVariables()) {
            variableMap.put(property.getName(), property.getValue());
        }
        ArrayList<DependencyInfo> infos = new ArrayList<DependencyInfo>();
        for (String configurationPath : this.repository.getConfigurationPathList()) {
            RequestResult result;
            Long configurationId = this.repository.getConfigurationId(configurationPath);
            if (this.repository.getServer() != null) {
                WebResource resource = RestModule.resource(this.repository.getServer().getUrl(), "rest/build_requests", this.repository.getServer().getUserName(), this.repository.getServer().getPassword());
                BuildRequest newRequest = new BuildRequest();
                newRequest.setConfigurationId(configurationId);
                newRequest.setRespectBuildCondition(true);
                newRequest.getVariables().putAll(variableMap);
                newRequest.getUpstreamRequestIds().add(currentRequest.getId());
                result = (RequestResult)resource.post(RequestResult.class, (Object)newRequest);
                resource = RestModule.resource(this.repository.getServer().getUrl(), "rest/ids", this.repository.getServer().getUserName(), this.repository.getServer().getPassword()).queryParam("request_id", result.getRequestId());
                ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
                while (response.getStatus() == 204) {
                    if (result.isLoopedRequest()) {
                        throw new QuickbuildException("Looped dependency found for configuration '" + configurationPath + "' at server '" + this.repository.getServer().getUrl() + "'.");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    response = (ClientResponse)resource.get(ClientResponse.class);
                }
                if (response.getStatus() != 200) {
                    throw new RuntimeException("Error retrieving id of dependency build: " + (String)response.getEntity(String.class));
                }
                DependencyInfo info = new DependencyInfo();
                info.setBuildId((Long)resource.get(Long.class));
                info.setConfigurationPath(configurationPath);
                info.setWaitForFinish(!result.isLoopedRequest());
                infos.add(info);
                continue;
            }
            BuildRequest newRequest = new BuildRequest();
            newRequest.setConfigurationId(configurationId);
            newRequest.setUpstreamConfigurationId(Context.getConfiguration().getId());
            newRequest.setRespectBuildCondition(true);
            newRequest.getUpstreamRequestIds().add(currentRequest.getId());
            newRequest.getVariables().putAll(variableMap);
            ServerService serverService = Quickbuild.getServerService();
            result = serverService.requestBuild(currentRequest.getRequesterId(), currentRequest.isScheduled(), newRequest);
            if (!result.isLoopedRequest() && Context.getConfiguration().findAuditBuildRequest().booleanValue()) {
                Quickbuild.getServerService().audit(currentRequest.getRequesterId(), configurationPath + "/", "Build request was submitted as result of resolving build dependency in configuration '" + Context.getConfiguration() + "'.", null, null);
            }
            NodeService nodeService = Quickbuild.getInstance(Grid.class).getLocalNode().getNodeService();
            String nodeAddress = Grid.instance.getLocalNode().getAddress();
            Long buildId = serverService.getBuildId(result.getRequestId(), nodeAddress);
            while (buildId == null) {
                if (result.isLoopedRequest()) {
                    throw new QuickbuildException("Looped dependency found for configuration '" + configurationPath + "'.");
                }
                buildId = nodeService.getBuildId(result.getRequestId(), 300000L);
                if (buildId != null) continue;
                Context.getLogger().trace("Triggered build id not found in cache, continue to query from server...");
                buildId = serverService.getBuildId(result.getRequestId(), nodeAddress);
            }
            DependencyInfo info = new DependencyInfo();
            info.setBuildId(buildId);
            info.setConfigurationPath(configurationPath);
            info.setWaitForFinish(!result.isLoopedRequest());
            infos.add(info);
        }
        return new DependencyRevision(infos, true);
    }
}

