/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.annotation.ConfigurationPaths;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.dependency.ConfigurationProvider;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Specify configuration paths", order=100)
public class SpecifiedConfigurations
implements ConfigurationProvider {
    private static final long serialVersionUID = 1L;
    private String configurationPaths;

    @Editable(order=200, name="Configurations", description="Specify the dependency configurations to retrieve files from. Multiple configurations should be separated by comma or new line character. For example, <b>root/project1/componentA, root/project1/componentB</b>.")
    @ConfigurationPaths
    @NotEmpty
    @ScriptApi(value="Get paths of the dependency configuration.")
    @Scriptable
    public String getConfigurationPaths() {
        return this.configurationPaths;
    }

    public void setConfigurationPaths(String configurationPaths) {
        this.configurationPaths = configurationPaths;
    }

    @Override
    public List<String> getConfigurations() {
        if (this.getConfigurationPaths() != null) {
            return StringUtils.splitAndTrim(this.getConfigurationPaths());
        }
        return new ArrayList<String>();
    }
}

