/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.dependency.DependencyResolver;
import com.pmease.quickbuild.dependency.DependencyRevision;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=400, name="specify a build version")
@ScriptApi(value="Resolve dependency build as a specified build.")
public class SpecifiedBuildResolver
implements DependencyResolver {
    private static final long serialVersionUID = 1L;
    private QuickbuildRepository repository;
    private String buildVersion;

    public SpecifiedBuildResolver(QuickbuildRepository repository) {
        this.repository = repository;
    }

    @Editable
    @NotEmpty
    @ScriptApi(value="Get version of dependency build.")
    @Scriptable
    public String getBuildVersion() {
        return this.buildVersion;
    }

    public void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    @ScriptApi(value="Get repository object")
    public QuickbuildRepository getRepository() {
        return this.repository;
    }

    @Override
    public DependencyRevision getDependency() {
        ArrayList<DependencyInfo> infos = new ArrayList<DependencyInfo>();
        for (String configurationPath : this.repository.getConfigurationPathList()) {
            Long configurationId = this.repository.getConfigurationId(configurationPath);
            if (this.repository.getServer() != null) {
                WebResource resource = RestModule.resource(this.repository.getServer().getUrl(), "rest/ids/", this.repository.getServer().getUserName(), this.repository.getServer().getPassword());
                resource = resource.queryParam("build_name", configurationId + "." + this.getBuildVersion());
                DependencyInfo info = new DependencyInfo();
                info.setBuildId((Long)resource.get(Long.class));
                info.setConfigurationPath(configurationPath);
                info.setWaitForFinish(true);
                infos.add(info);
                continue;
            }
            ConfigurationManager configurationManager = Quickbuild.getInstance(ConfigurationManager.class);
            Configuration configuration = (Configuration)configurationManager.load(configurationId);
            BuildManager buildManager = Quickbuild.getInstance(BuildManager.class);
            Build build = buildManager.get(configuration, this.getBuildVersion());
            if (build != null) {
                DependencyInfo info = new DependencyInfo();
                info.setBuildId(build.getId());
                info.setConfigurationPath(configurationPath);
                info.setWaitForFinish(true);
                infos.add(info);
                continue;
            }
            throw new QuickbuildException(ExceptionUtils.buildMessage("Dependent build not found", "configuration", configurationPath, "build", this.getBuildVersion()));
        }
        return new DependencyRevision(infos, true);
    }
}

