/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ConfigurationPaths;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.dependency.ConfigurationProvider;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.dependency.DependencyResolver;
import com.pmease.quickbuild.dependency.DependencyRevision;
import com.pmease.quickbuild.dependency.DependencyServer;
import com.pmease.quickbuild.dependency.FileRetrieval;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.repository.usermapping.UserMapping;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.ServletUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.apache.wicket.util.io.IOUtils;
import org.dom4j.Element;

@Editable(name="QuickBuild")
@ScriptApi(value="QuickBuild repository can be used to retrieve artifacts from another configuration and is normally used to handle build dependencies.")
public class QuickbuildRepository
extends Repository<DependencyRevision> {
    private static final long serialVersionUID = 1L;
    private DependencyServer server;
    private ConfigurationProvider configurationProvider;
    private DependencyResolver dependencyResolver;
    private List<FileRetrieval> retrievals = new ArrayList<FileRetrieval>();
    private transient Map<String, Long> configurationIds;

    @Override
    public int getQuietPeriod() {
        return super.getQuietPeriod();
    }

    @Override
    public UserMapping getUserMapping() {
        return super.getUserMapping();
    }

    @Editable(order=100, description="Check this if you want to retrieve files from another server. Configuration specified below will be considered to reside on the specified server if this option is checked.")
    @ScriptApi(value="Get the QuickBuild server from where to retrieve files. Null means current server.")
    public DependencyServer getServer() {
        return this.server;
    }

    public void setServer(DependencyServer server) {
        this.server = server;
    }

    @Editable(order=200, name="Configurations", description="Specify the dependency configurations to retrieve files from. Multiple configurations should be separated by comma or new line character. For example, <b>root/project1/componentA, root/project1/componentB</b>.")
    @ConfigurationPaths
    @NotNull
    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public List<String> getConfigurationPathList() {
        return this.getConfigurationProvider().getConfigurations();
    }

    @Editable(order=500, name="Build", description="Specify the build from which to retrieve files. Note that if <i>latest finished build</i> is selected, builds using this dependency will not be considered failed even if this build is failed.")
    @NotNull
    @ScriptApi(value="Get dependency resolver")
    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public void setDependencyResolver(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    @Editable(name="Files to Retrieve", order=600, description="Specify files to retrieve from the dependency build.")
    @ScriptApi(value="Get dependency files to retrieve.")
    public List<FileRetrieval> getRetrievals() {
        return this.retrievals;
    }

    public void setRetrievals(List<FileRetrieval> retrievals) {
        this.retrievals = retrievals;
    }

    @Override
    @ScriptApi(value="Get revision of the repository.")
    public DependencyRevision getRevision() {
        return (DependencyRevision)super.getRevision();
    }

    Long getConfigurationId(String configurationPath) {
        Long configurationId;
        if (this.configurationIds == null) {
            this.configurationIds = new HashMap<String, Long>();
        }
        if ((configurationId = this.configurationIds.get(configurationPath)) == null) {
            if (this.getServer() != null) {
                WebResource resource = RestModule.resource(this.getServer().getUrl(), "rest/ids", this.getServer().getUserName(), this.getServer().getPassword());
                ClientResponse response = (ClientResponse)resource.queryParam("configuration_path", configurationPath).get(ClientResponse.class);
                if (response.getStatus() == 204) {
                    throw new QuickbuildException("Dependency configuration '" + configurationPath + "' not found at server '" + this.getServer().getUrl() + "'.");
                }
                if (response.getStatus() != 200) {
                    throw new QuickbuildException("Error querying id of dependency configuration '" + configurationPath + "' at server '" + this.getServer().getUrl() + ": " + (String)response.getEntity(String.class));
                }
                configurationId = (Long)response.getEntity(Long.class);
            } else {
                Configuration configuration = Quickbuild.getInstance(ConfigurationManager.class).get(configurationPath);
                if (configuration != null) {
                    configurationId = configuration.getId();
                } else {
                    throw new QuickbuildException("Dependency configuration '" + configurationPath + "' not found.");
                }
            }
            this.configurationIds.put(configurationPath, configurationId);
        }
        return configurationId;
    }

    private void downloadDependencies(Long dependencyBuildId) {
        if (this.getServer() != null) {
            for (FileRetrieval retrieval : this.getRetrievals()) {
                InputStream is = null;
                try {
                    String content = "build_id=" + dependencyBuildId + "&" + "src_path" + "=" + URLEncoder.encode(retrieval.getSrcPath(), "UTF-8") + "&" + "file_patterns" + "=" + URLEncoder.encode(retrieval.getFilePatterns(), "UTF-8");
                    is = ServletUtils.download(this.getServer().getUrl() + "/batch_download" + "?" + content, this.getServer().getUserName(), this.getServer().getPassword());
                    File destDir = retrieval.getDestPath() != null ? new File(Context.getConfiguration().getWorkspaceDir(), retrieval.getDestPath()) : Context.getConfiguration().getWorkspaceDir();
                    FileUtils.unzip(is, destDir);
                }
                catch (Exception e) {
                    try {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)is);
            }
        } else {
            Build dependencyBuild = (Build)BuildManager.instance.load(dependencyBuildId);
            ArtifactStorage artifactStorage = dependencyBuild.getConfiguration().findArtifactStorage();
            for (FileRetrieval retrieval : this.getRetrievals()) {
                File destDir = retrieval.getDestPath() != null ? new File(Context.getConfiguration().getWorkspaceDir(), retrieval.getDestPath()) : Context.getConfiguration().getWorkspaceDir();
                Context.getLogger().debug("Downloading artifacts from dependency build '" + dependencyBuild.getConfiguration() + ":" + dependencyBuild.getVersion() + "' (srcPath: {}, filePatterns: {}, destDir: {})...", new Object[]{retrieval.getSrcPath(), retrieval.getFilePatterns(), destDir.getAbsolutePath()});
                if (artifactStorage.getBatchSupport() != null) {
                    artifactStorage.getBatchSupport().download(dependencyBuild, retrieval.getSrcPath(), retrieval.getFilePatterns(), destDir);
                    continue;
                }
                for (String each : Quickbuild.getServerService().listArtifacts(dependencyBuildId, retrieval.getSrcPath(), retrieval.getFilePatterns())) {
                    artifactStorage.download(dependencyBuild, each, new File(destDir, each));
                }
            }
        }
    }

    @Override
    protected void checkoutByRevision(DependencyRevision revision) {
        for (DependencyInfo info : revision.getValue()) {
            if (this.getServer() != null) {
                if (info.isWaitForFinish()) {
                    Context.getLogger().info("Waiting for finish of dependency build (server: {}, configuration: {}, build id: {})", new Object[]{this.getServer().getUrl(), info.getConfigurationPath(), info.getBuildId().toString()});
                    WebResource resource = RestModule.resource(this.getServer().getUrl(), "rest/builds/" + info.getBuildId() + "/status", this.getServer().getUserName(), this.getServer().getPassword());
                    Build.Status status = (Build.Status)((Object)resource.get(Build.Status.class));
                    while (status == Build.Status.RUNNING) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        status = (Build.Status)((Object)resource.get(Build.Status.class));
                    }
                    if (status == null) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage("Dependency build not found", "server", this.getServer().getUrl(), "configuration", info.getConfigurationPath(), "build id", info.getBuildId()));
                    }
                    if (status != Build.Status.CANCELLED && status != Build.Status.TIMEOUT) {
                        this.downloadDependencies(info.getBuildId());
                    }
                    if (!revision.isFailDependentBuildIfIAmFailed() || status == Build.Status.RECOMMENDED || status == Build.Status.SUCCESSFUL) continue;
                    throw new QuickbuildException(ExceptionUtils.buildMessage("Dependency build not successful", "server", this.getServer().getUrl(), "configuration", info.getConfigurationPath(), "build id", info.getBuildId()));
                }
                Context.getLogger().warn("Looped dependency detected for configuration '" + info.getConfigurationPath() + "' at server '" + this.getServer().getUrl() + "', checkout without waiting for finish of dependency build.");
                this.downloadDependencies(info.getBuildId());
                continue;
            }
            if (info.isWaitForFinish()) {
                Context.getLogger().info("Waiting for finish of dependency build (configuration: {}, build id: {})", (Object)info.getConfigurationPath(), (Object)info.getBuildId());
                String nodeAddress = Grid.instance.getLocalNode().getAddress();
                NodeService nodeService = Grid.instance.getLocalNode().getNodeService();
                ServerService serverService = Quickbuild.getServerService();
                Build.Status status = serverService.getBuildStatus(info.getBuildId(), nodeAddress);
                while (status == Build.Status.RUNNING) {
                    status = nodeService.getBuildStatus(info.getBuildId(), 300000L);
                    if (status != null) continue;
                    Context.getLogger().trace("Status of triggered build not found in cache, querying from database...");
                    status = serverService.getBuildStatus(info.getBuildId(), nodeAddress);
                }
                if (status == null) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage("Dependency build not found", "configuration", info.getConfigurationPath(), "build id", info.getBuildId()));
                }
                if (status != Build.Status.CANCELLED && status != Build.Status.TIMEOUT) {
                    this.downloadDependencies(info.getBuildId());
                }
                if (!revision.isFailDependentBuildIfIAmFailed() || status == Build.Status.RECOMMENDED || status == Build.Status.SUCCESSFUL) continue;
                throw new QuickbuildException(ExceptionUtils.buildMessage("Dependency build not successful", "configuration", info.getConfigurationPath(), "build id", info.getBuildId()));
            }
            Context.getLogger().warn("Looped dependency detected for configuration '" + info.getConfigurationPath() + "', checkout without waiting for finish " + "of dependency build.");
            this.downloadDependencies(info.getBuildId());
        }
    }

    @Override
    protected List<Changeset> getChangesBetween(DependencyRevision startRevision, DependencyRevision endRevision) {
        ArrayList<Changeset> changesets = new ArrayList<Changeset>();
        if (!((Object)startRevision.getValue()).equals(endRevision.getValue())) {
            for (DependencyInfo info : endRevision.getValue()) {
                String version;
                Long buildId = DependencyInfo.getBuildId(startRevision.getValue(), info.getConfigurationPath());
                if (info.getBuildId().equals(buildId)) continue;
                Changeset changeset = new Changeset();
                if (this.getServer() != null) {
                    WebResource resource = RestModule.resource(this.getServer().getUrl(), "rest/builds/" + info.getBuildId() + "/version", this.getServer().getUserName(), this.getServer().getPassword());
                    version = (String)resource.get(String.class);
                    resource = RestModule.resource(this.getServer().getUrl(), "rest/builds/" + info.getBuildId() + "/begin_date", this.getServer().getUserName(), this.getServer().getPassword());
                    changeset.setDate((Date)resource.get(Date.class));
                } else {
                    Build build = (Build)BuildManager.instance.load(info.getBuildId());
                    version = build.getVersion();
                    changeset.setDate(build.getBeginDate());
                    changeset.setUser(build.getRequesterName());
                }
                changeset.setId(UUID.randomUUID().toString());
                changeset.setComment("New version '" + version + "' available in dependency configuration '" + info.getConfigurationPath() + "'.");
                changesets.add(changeset);
            }
            for (DependencyInfo info : startRevision.getValue()) {
                if (DependencyInfo.getBuildId(endRevision.getValue(), info.getConfigurationPath()) != null) continue;
                Changeset changeset = new Changeset();
                changeset.setId(UUID.randomUUID().toString());
                changeset.setComment("Dependency to configuration '" + info.getConfigurationPath() + "' has been removed.");
                changesets.add(changeset);
            }
        }
        return changesets;
    }

    @Override
    protected DependencyRevision getHeadRevision() {
        DependencyRevision revision = this.getDependencyResolver().getDependency();
        Context.getLogger().info("Dependency builds have been resolved.");
        return revision;
    }

    @Override
    public ProofBuildSupport<? extends LocalChange> getProofBuildSupport() {
        return null;
    }

    @Override
    public SourceViewSupport<DependencyRevision> getSourceViewSupport() {
        return null;
    }

    @Override
    protected void labelOnRevision(DependencyRevision revision, String label, String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isQuietSince(Date date) {
        return true;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element passwordElement;
        Element userNameElement;
        Element serverUrlElement;
        String serverUrl = dom.getValue("serverUrl");
        if (serverUrl != null) {
            String password;
            Element serverElement = dom.getRootElement().addElement("server");
            serverElement.addElement("repository").addAttribute("reference", "../..");
            serverElement.addElement("url").setText(serverUrl);
            String userName = dom.getValue("userName");
            if (userName != null) {
                serverElement.addElement("userName").setText(userName);
            }
            if ((password = dom.getValue("password")) != null) {
                serverElement.addElement("password").setText(password);
            }
        }
        if ((serverUrlElement = dom.getRootElement().element("serverUrl")) != null) {
            serverUrlElement.detach();
        }
        if ((userNameElement = dom.getRootElement().element("userName")) != null) {
            userNameElement.detach();
        }
        if ((passwordElement = dom.getRootElement().element("password")) != null) {
            passwordElement.detach();
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        Element filesToRetrieveElement = dom.getRootElement().element("filesToRetrieve");
        filesToRetrieveElement.setName("retrievals");
        for (Element each : filesToRetrieveElement.elements()) {
            each.setName("com.pmease.quickbuild.dependency.FileRetrieval");
            each.addElement("repository").addAttribute("reference", "../../..");
        }
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        Element configurationPathElement = dom.getRootElement().element("configurationPath");
        String configurationPath = configurationPathElement.getTextTrim();
        configurationPathElement.detach();
        Element providerElement = dom.getRootElement().addElement("configurationProvider");
        providerElement.addAttribute("class", "com.pmease.quickbuild.dependency.SpecifiedConfigurations");
        providerElement.addElement("configurationPaths").setText(configurationPath);
    }
}

