/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.dependency.DependencyResolver;
import com.pmease.quickbuild.dependency.DependencyRevision;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.rest.RestModule;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;

@Editable(order=300, name="latest recommended build")
@ScriptApi(value="Resolve the dependency build as latest recommended build.")
public class LatestRecommendedResolver
implements DependencyResolver {
    private static final long serialVersionUID = 1L;
    private QuickbuildRepository repository;

    public LatestRecommendedResolver(QuickbuildRepository repository) {
        this.repository = repository;
    }

    @ScriptApi(value="Get the repository object")
    public QuickbuildRepository getRepository() {
        return this.repository;
    }

    @Override
    public DependencyRevision getDependency() {
        ArrayList<DependencyInfo> infos = new ArrayList<DependencyInfo>();
        for (String configurationPath : this.repository.getConfigurationPathList()) {
            Long configurationId = this.repository.getConfigurationId(configurationPath);
            if (this.repository.getServer() != null) {
                WebResource resource = RestModule.resource(this.repository.getServer().getUrl(), "rest/ids/", this.repository.getServer().getUserName(), this.repository.getServer().getPassword());
                resource = resource.queryParam("build_name", Build.name4latest(configurationId, Build.Status.RECOMMENDED));
                DependencyInfo info = new DependencyInfo();
                info.setBuildId((Long)resource.get(Long.class));
                info.setConfigurationPath(configurationPath);
                info.setWaitForFinish(true);
                infos.add(info);
                continue;
            }
            ConfigurationManager configurationManager = Quickbuild.getInstance(ConfigurationManager.class);
            Configuration configuration = (Configuration)configurationManager.load(configurationId);
            Build build = configuration.getLatestBuild(Build.Status.RECOMMENDED);
            if (build != null) {
                DependencyInfo info = new DependencyInfo();
                info.setBuildId(build.getId());
                info.setConfigurationPath(configurationPath);
                info.setWaitForFinish(true);
                infos.add(info);
                continue;
            }
            throw new QuickbuildException("No recommended build found in dependent configuration '" + configurationPath + "'.");
        }
        return new DependencyRevision(infos, true);
    }
}

