/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.dependency;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.dependency.ConfigurationProvider;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@Editable(name="All child configurations matching specified pattern", order=200)
public class FilteredChildConfigurations
implements ConfigurationProvider {
    private static final long serialVersionUID = 1L;
    private String pattern;

    @Editable(description="If not specified, all child configurations will be returned.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public List<String> getConfigurations() {
        ArrayList<String> paths = new ArrayList<String>();
        Pattern pattern = null;
        if (this.getPattern() != null) {
            pattern = Pattern.compile(this.getPattern());
        }
        for (Configuration child : ConfigurationManager.instance.getChildren(Context.getConfiguration())) {
            if (pattern != null && !pattern.matcher(child.getPathName()).matches()) continue;
            paths.add(child.getPathName());
        }
        return paths;
    }
}

